/*
 * Decompiled with CFR 0.152.
 */
package esmska.integration.mac;

import esmska.Context;
import esmska.integration.IntegrationAdapter;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ToolBarUI;

public class UnifiedToolbarUI
extends ToolBarUI {
    private static final Color ACTIVE_TOP_GRADIENT_COLOR = new Color(0xBCBCBC);
    private static final Color ACTIVE_BOTTOM_GRADIENT_COLOR = new Color(0x9A9A9A);
    private static final Color INACTIVE_TOP_GRADIENT_COLOR = new Color(0xE4E4E4);
    private static final Color INACTIVE_BOTTOM_GRADIENT_COLOR = new Color(0xD1D1D1);
    private static final IntegrationAdapter ADAPTER = IntegrationAdapter.getInstance();

    public static void installSupport() {
        if (System.getProperty("os.version").contains("10.5")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Context.mainFrame.getToolbar().setUI(new UnifiedToolbarUI());
                    Context.mainFrame.getToolbar().invalidate();
                }
            });
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int height = c.getHeight();
        boolean focused = Context.mainFrame.isFocused() || ADAPTER.isModalSheetVisible();
        Color topColor = focused ? ACTIVE_TOP_GRADIENT_COLOR : INACTIVE_TOP_GRADIENT_COLOR;
        Color bottomColor = focused ? ACTIVE_BOTTOM_GRADIENT_COLOR : INACTIVE_BOTTOM_GRADIENT_COLOR;
        GradientPaint paint = new GradientPaint(0.0f, 1.0f, topColor, 0.0f, height, bottomColor);
        Graphics2D graphics2D = (Graphics2D)g.create();
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, 0, c.getWidth(), height);
        graphics2D.dispose();
    }
}

