/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.GeoBBox;
import org.apache.lucene.geo3d.GeoDegenerateHorizontalLine;
import org.apache.lucene.geo3d.GeoDegenerateLatitudeZone;
import org.apache.lucene.geo3d.GeoDegenerateLongitudeSlice;
import org.apache.lucene.geo3d.GeoDegeneratePoint;
import org.apache.lucene.geo3d.GeoDegenerateVerticalLine;
import org.apache.lucene.geo3d.GeoLatitudeZone;
import org.apache.lucene.geo3d.GeoLongitudeSlice;
import org.apache.lucene.geo3d.GeoNorthLatitudeZone;
import org.apache.lucene.geo3d.GeoNorthRectangle;
import org.apache.lucene.geo3d.GeoRectangle;
import org.apache.lucene.geo3d.GeoSouthLatitudeZone;
import org.apache.lucene.geo3d.GeoSouthRectangle;
import org.apache.lucene.geo3d.GeoWideDegenerateHorizontalLine;
import org.apache.lucene.geo3d.GeoWideLongitudeSlice;
import org.apache.lucene.geo3d.GeoWideNorthRectangle;
import org.apache.lucene.geo3d.GeoWideRectangle;
import org.apache.lucene.geo3d.GeoWideSouthRectangle;
import org.apache.lucene.geo3d.GeoWorld;
import org.apache.lucene.geo3d.PlanetModel;

public class GeoBBoxFactory {
    private GeoBBoxFactory() {
    }

    public static GeoBBox makeGeoBBox(PlanetModel planetModel, double topLat, double bottomLat, double leftLon, double rightLon) {
        if (topLat > 1.5707963267948966) {
            topLat = 1.5707963267948966;
        }
        if (bottomLat < -1.5707963267948966) {
            bottomLat = -1.5707963267948966;
        }
        if (leftLon < -Math.PI) {
            leftLon = -Math.PI;
        }
        if (rightLon > Math.PI) {
            rightLon = Math.PI;
        }
        if (Math.abs(leftLon + Math.PI) < 1.0E-12 && Math.abs(rightLon - Math.PI) < 1.0E-12) {
            if (Math.abs(topLat - 1.5707963267948966) < 1.0E-12 && Math.abs(bottomLat + 1.5707963267948966) < 1.0E-12) {
                return new GeoWorld(planetModel);
            }
            if (Math.abs(topLat - bottomLat) < 1.0E-12) {
                if (Math.abs(topLat - 1.5707963267948966) < 1.0E-12 || Math.abs(topLat + 1.5707963267948966) < 1.0E-12) {
                    return new GeoDegeneratePoint(planetModel, topLat, 0.0);
                }
                return new GeoDegenerateLatitudeZone(planetModel, topLat);
            }
            if (Math.abs(topLat - 1.5707963267948966) < 1.0E-12) {
                return new GeoNorthLatitudeZone(planetModel, bottomLat);
            }
            if (Math.abs(bottomLat + 1.5707963267948966) < 1.0E-12) {
                return new GeoSouthLatitudeZone(planetModel, topLat);
            }
            return new GeoLatitudeZone(planetModel, topLat, bottomLat);
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (topLat == 1.5707963267948966 && bottomLat == -1.5707963267948966) {
            if (Math.abs(leftLon - rightLon) < 1.0E-12) {
                return new GeoDegenerateLongitudeSlice(planetModel, leftLon);
            }
            if (extent >= Math.PI) {
                return new GeoWideLongitudeSlice(planetModel, leftLon, rightLon);
            }
            return new GeoLongitudeSlice(planetModel, leftLon, rightLon);
        }
        if (Math.abs(leftLon - rightLon) < 1.0E-12) {
            if (Math.abs(topLat - bottomLat) < 1.0E-12) {
                return new GeoDegeneratePoint(planetModel, topLat, leftLon);
            }
            return new GeoDegenerateVerticalLine(planetModel, topLat, bottomLat, leftLon);
        }
        if (extent >= Math.PI) {
            if (Math.abs(topLat - bottomLat) < 1.0E-12) {
                return new GeoWideDegenerateHorizontalLine(planetModel, topLat, leftLon, rightLon);
            }
            if (Math.abs(topLat - 1.5707963267948966) < 1.0E-12) {
                return new GeoWideNorthRectangle(planetModel, bottomLat, leftLon, rightLon);
            }
            if (Math.abs(bottomLat + 1.5707963267948966) < 1.0E-12) {
                return new GeoWideSouthRectangle(planetModel, topLat, leftLon, rightLon);
            }
            return new GeoWideRectangle(planetModel, topLat, bottomLat, leftLon, rightLon);
        }
        if (Math.abs(topLat - bottomLat) < 1.0E-12) {
            if (Math.abs(topLat - 1.5707963267948966) < 1.0E-12 || Math.abs(topLat + 1.5707963267948966) < 1.0E-12) {
                return new GeoDegeneratePoint(planetModel, topLat, 0.0);
            }
            return new GeoDegenerateHorizontalLine(planetModel, topLat, leftLon, rightLon);
        }
        if (Math.abs(topLat - 1.5707963267948966) < 1.0E-12) {
            return new GeoNorthRectangle(planetModel, bottomLat, leftLon, rightLon);
        }
        if (Math.abs(bottomLat + 1.5707963267948966) < 1.0E-12) {
            return new GeoSouthRectangle(planetModel, topLat, leftLon, rightLon);
        }
        return new GeoRectangle(planetModel, topLat, bottomLat, leftLon, rightLon);
    }
}

