/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.RealtimeRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.fetch.source.FetchSourceContext;

public class GetRequest
extends SingleShardRequest<GetRequest>
implements RealtimeRequest {
    private String type;
    private String id;
    private String routing;
    private String preference;
    private String[] fields;
    private FetchSourceContext fetchSourceContext;
    private boolean refresh = false;
    Boolean realtime;
    private VersionType versionType = VersionType.INTERNAL;
    private long version = -3L;
    private boolean ignoreErrorsOnGeneratedFields;

    public GetRequest() {
        this.type = "_all";
    }

    public GetRequest(GetRequest getRequest, ActionRequest originalRequest) {
        super(originalRequest);
        this.index = getRequest.index;
        this.type = getRequest.type;
        this.id = getRequest.id;
        this.routing = getRequest.routing;
        this.preference = getRequest.preference;
        this.fields = getRequest.fields;
        this.fetchSourceContext = getRequest.fetchSourceContext;
        this.refresh = getRequest.refresh;
        this.realtime = getRequest.realtime;
        this.version = getRequest.version;
        this.versionType = getRequest.versionType;
        this.ignoreErrorsOnGeneratedFields = getRequest.ignoreErrorsOnGeneratedFields;
    }

    public GetRequest(String index) {
        super(index);
        this.type = "_all";
    }

    public GetRequest(ActionRequest request, String index) {
        super(request, index);
    }

    public GetRequest(String index, String type, String id) {
        super(index);
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validateNonNullIndex();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (!this.versionType.validateVersionForReads(this.version)) {
            validationException = ValidateActions.addValidationError("illegal version value [" + this.version + "] for version type [" + this.versionType.name() + "]", validationException);
        }
        return validationException;
    }

    public GetRequest type(@Nullable String type) {
        if (type == null) {
            type = "_all";
        }
        this.type = type;
        return this;
    }

    public GetRequest id(String id) {
        this.id = id;
        return this;
    }

    public GetRequest parent(String parent) {
        if (this.routing == null) {
            this.routing = parent;
        }
        return this;
    }

    public GetRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public GetRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        return this.routing;
    }

    public String preference() {
        return this.preference;
    }

    public GetRequest fetchSourceContext(FetchSourceContext context) {
        this.fetchSourceContext = context;
        return this;
    }

    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    public GetRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public GetRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public boolean realtime() {
        return this.realtime == null ? true : this.realtime;
    }

    public GetRequest realtime(Boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public long version() {
        return this.version;
    }

    public GetRequest version(long version) {
        this.version = version;
        return this;
    }

    public GetRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public GetRequest ignoreErrorsOnGeneratedFields(boolean ignoreErrorsOnGeneratedFields) {
        this.ignoreErrorsOnGeneratedFields = ignoreErrorsOnGeneratedFields;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    public boolean ignoreErrorsOnGeneratedFields() {
        return this.ignoreErrorsOnGeneratedFields;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        byte realtime;
        super.readFrom(in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        int size = in.readInt();
        if (size >= 0) {
            this.fields = new String[size];
            for (int i = 0; i < size; ++i) {
                this.fields[i] = in.readString();
            }
        }
        if ((realtime = in.readByte()) == 0) {
            this.realtime = false;
        } else if (realtime == 1) {
            this.realtime = true;
        }
        this.ignoreErrorsOnGeneratedFields = in.readBoolean();
        this.versionType = VersionType.fromValue(in.readByte());
        this.version = in.readLong();
        this.fetchSourceContext = FetchSourceContext.optionalReadFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        if (this.fields == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.fields.length);
            for (String field : this.fields) {
                out.writeString(field);
            }
        }
        if (this.realtime == null) {
            out.writeByte((byte)-1);
        } else if (!this.realtime.booleanValue()) {
            out.writeByte((byte)0);
        } else {
            out.writeByte((byte)1);
        }
        out.writeBoolean(this.ignoreErrorsOnGeneratedFields);
        out.writeByte(this.versionType.getValue());
        out.writeLong(this.version);
        FetchSourceContext.optionalWriteToStream(this.fetchSourceContext, out);
    }

    public String toString() {
        return "get [" + this.index + "][" + this.type + "][" + this.id + "]: routing [" + this.routing + "]";
    }
}

