/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty.cors;

import java.util.HashSet;
import org.elasticsearch.common.Strings;
import org.elasticsearch.http.netty.cors.CorsConfig;
import org.elasticsearch.rest.support.RestUtils;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class CorsHandler
extends SimpleChannelUpstreamHandler {
    public static final String ANY_ORIGIN = "*";
    private final CorsConfig config;
    private HttpRequest request;

    public CorsHandler(CorsConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.config = config;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.config.isCorsSupportEnabled() && e.getMessage() instanceof HttpRequest) {
            this.request = (HttpRequest)e.getMessage();
            if (RestUtils.isBrowser(this.request.headers().get("User-Agent"))) {
                if (CorsHandler.isPreflightRequest(this.request)) {
                    this.handlePreflight(ctx, this.request);
                    return;
                }
                if (this.config.isShortCircuit() && !this.validateOrigin()) {
                    CorsHandler.forbidden(ctx, this.request);
                    return;
                }
            }
        }
        super.messageReceived(ctx, e);
    }

    public static void setCorsResponseHeaders(HttpRequest request, HttpResponse resp, CorsConfig config) {
        String originHeaderVal;
        if (!config.isCorsSupportEnabled()) {
            return;
        }
        String originHeader = request.headers().get("Origin");
        if (!Strings.isNullOrEmpty(originHeader) && (originHeaderVal = config.isAnyOriginSupported() ? ANY_ORIGIN : (config.isOriginAllowed(originHeader) ? originHeader : null)) != null) {
            resp.headers().add("Access-Control-Allow-Origin", (Object)originHeaderVal);
        }
        if (config.isCredentialsAllowed()) {
            resp.headers().add("Access-Control-Allow-Credentials", (Object)"true");
        }
    }

    private void handlePreflight(ChannelHandlerContext ctx, HttpRequest request) {
        DefaultHttpResponse response = new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.OK);
        if (this.setOrigin((HttpResponse)response)) {
            this.setAllowMethods((HttpResponse)response);
            this.setAllowHeaders((HttpResponse)response);
            this.setAllowCredentials((HttpResponse)response);
            this.setMaxAge((HttpResponse)response);
            this.setPreflightHeaders((HttpResponse)response);
            ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
        } else {
            CorsHandler.forbidden(ctx, request);
        }
    }

    private static void forbidden(ChannelHandlerContext ctx, HttpRequest request) {
        ctx.getChannel().write((Object)new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.FORBIDDEN)).addListener(ChannelFutureListener.CLOSE);
    }

    private void setPreflightHeaders(HttpResponse response) {
        response.headers().add(this.config.preflightResponseHeaders());
    }

    private boolean setOrigin(HttpResponse response) {
        String origin = this.request.headers().get("Origin");
        if (!Strings.isNullOrEmpty(origin)) {
            if ("null".equals(origin) && this.config.isNullOriginAllowed()) {
                CorsHandler.setAnyOrigin(response);
                return true;
            }
            if (this.config.isAnyOriginSupported()) {
                if (this.config.isCredentialsAllowed()) {
                    this.echoRequestOrigin(response);
                    CorsHandler.setVaryHeader(response);
                } else {
                    CorsHandler.setAnyOrigin(response);
                }
                return true;
            }
            if (this.config.isOriginAllowed(origin)) {
                CorsHandler.setOrigin(response, origin);
                CorsHandler.setVaryHeader(response);
                return true;
            }
        }
        return false;
    }

    private boolean validateOrigin() {
        if (this.config.isAnyOriginSupported()) {
            return true;
        }
        String origin = this.request.headers().get("Origin");
        if (Strings.isNullOrEmpty(origin)) {
            return true;
        }
        if ("null".equals(origin) && this.config.isNullOriginAllowed()) {
            return true;
        }
        return this.config.isOriginAllowed(origin);
    }

    private void echoRequestOrigin(HttpResponse response) {
        CorsHandler.setOrigin(response, this.request.headers().get("Origin"));
    }

    private static void setVaryHeader(HttpResponse response) {
        response.headers().set("Vary", (Object)"Origin");
    }

    private static void setAnyOrigin(HttpResponse response) {
        CorsHandler.setOrigin(response, ANY_ORIGIN);
    }

    private static void setOrigin(HttpResponse response, String origin) {
        response.headers().set("Access-Control-Allow-Origin", (Object)origin);
    }

    private void setAllowCredentials(HttpResponse response) {
        if (this.config.isCredentialsAllowed() && !response.headers().get("Access-Control-Allow-Origin").equals(ANY_ORIGIN)) {
            response.headers().set("Access-Control-Allow-Credentials", (Object)"true");
        }
    }

    private static boolean isPreflightRequest(HttpRequest request) {
        HttpHeaders headers = request.headers();
        return request.getMethod().equals((Object)HttpMethod.OPTIONS) && headers.contains("Origin") && headers.contains("Access-Control-Request-Method");
    }

    private void setAllowMethods(HttpResponse response) {
        HashSet<String> strMethods = new HashSet<String>();
        for (HttpMethod method : this.config.allowedRequestMethods()) {
            strMethods.add(method.getName().trim());
        }
        response.headers().set("Access-Control-Allow-Methods", strMethods);
    }

    private void setAllowHeaders(HttpResponse response) {
        response.headers().set("Access-Control-Allow-Headers", this.config.allowedRequestHeaders());
    }

    private void setMaxAge(HttpResponse response) {
        response.headers().set("Access-Control-Max-Age", (Object)this.config.maxAge());
    }
}

