/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class ProcessInfo
implements Streamable,
ToXContent {
    long refreshInterval;
    private long id;
    private boolean mlockall;

    ProcessInfo() {
    }

    public ProcessInfo(long id, boolean mlockall) {
        this.id = id;
        this.mlockall = mlockall;
    }

    public long refreshInterval() {
        return this.refreshInterval;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public long getId() {
        return this.id;
    }

    public boolean isMlockall() {
        return this.mlockall;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.PROCESS);
        builder.timeValueField(Fields.REFRESH_INTERVAL_IN_MILLIS, Fields.REFRESH_INTERVAL, this.refreshInterval);
        builder.field(Fields.ID, this.id);
        builder.field(Fields.MLOCKALL, this.mlockall);
        builder.endObject();
        return builder;
    }

    public static ProcessInfo readProcessInfo(StreamInput in) throws IOException {
        ProcessInfo info = new ProcessInfo();
        info.readFrom(in);
        return info;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.refreshInterval = in.readLong();
        this.id = in.readLong();
        this.mlockall = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.refreshInterval);
        out.writeLong(this.id);
        out.writeBoolean(this.mlockall);
    }

    static final class Fields {
        static final XContentBuilderString PROCESS = new XContentBuilderString("process");
        static final XContentBuilderString REFRESH_INTERVAL = new XContentBuilderString("refresh_interval");
        static final XContentBuilderString REFRESH_INTERVAL_IN_MILLIS = new XContentBuilderString("refresh_interval_in_millis");
        static final XContentBuilderString ID = new XContentBuilderString("id");
        static final XContentBuilderString MLOCKALL = new XContentBuilderString("mlockall");

        Fields() {
        }
    }
}

