/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.BucketStreamContext;
import org.elasticsearch.search.aggregations.bucket.BucketStreams;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class DoubleTerms
extends InternalTerms<DoubleTerms, Bucket> {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("terms", "dterms");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public DoubleTerms readResult(StreamInput in) throws IOException {
            DoubleTerms buckets = new DoubleTerms();
            buckets.readFrom(in);
            return buckets;
        }
    };
    private static final BucketStreams.Stream<Bucket> BUCKET_STREAM = new BucketStreams.Stream<Bucket>(){

        @Override
        public Bucket readResult(StreamInput in, BucketStreamContext context) throws IOException {
            Bucket buckets = new Bucket(context.formatter(), (Boolean)context.attributes().get("showDocCountError"));
            buckets.readFrom(in);
            return buckets;
        }

        @Override
        public BucketStreamContext getBucketStreamContext(Bucket bucket) {
            BucketStreamContext context = new BucketStreamContext();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("showDocCountError", bucket.showDocCountError);
            context.attributes(attributes);
            context.formatter(bucket.formatter);
            return context;
        }
    };
    private ValueFormatter formatter;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
        BucketStreams.registerStream(BUCKET_STREAM, TYPE.stream());
    }

    DoubleTerms() {
    }

    public DoubleTerms(String name, Terms.Order order, ValueFormatter formatter, int requiredSize, int shardSize, long minDocCount, List<? extends InternalTerms.Bucket> buckets, boolean showTermDocCountError, long docCountError, long otherDocCount, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, order, requiredSize, shardSize, minDocCount, buckets, showTermDocCountError, docCountError, otherDocCount, pipelineAggregators, metaData);
        this.formatter = formatter;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public DoubleTerms create(List<Bucket> buckets) {
        return new DoubleTerms(this.name, this.order, this.formatter, this.requiredSize, this.shardSize, this.minDocCount, buckets, this.showTermDocCountError, this.docCountError, this.otherDocCount, this.pipelineAggregators(), this.metaData);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.term, prototype.docCount, aggregations, prototype.showDocCountError, prototype.docCountError, prototype.formatter);
    }

    @Override
    protected DoubleTerms create(String name, List<InternalTerms.Bucket> buckets, long docCountError, long otherDocCount, InternalTerms prototype) {
        return new DoubleTerms(name, prototype.order, ((DoubleTerms)prototype).formatter, prototype.requiredSize, prototype.shardSize, prototype.minDocCount, buckets, prototype.showTermDocCountError, docCountError, otherDocCount, prototype.pipelineAggregators(), prototype.getMetaData());
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.docCountError = in.getVersion().onOrAfter(Version.V_1_4_0_Beta1) ? in.readLong() : -1L;
        this.order = InternalOrder.Streams.readOrder(in);
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.requiredSize = DoubleTerms.readSize(in);
        this.shardSize = DoubleTerms.readSize(in);
        this.showTermDocCountError = in.readBoolean();
        this.minDocCount = in.readVLong();
        this.otherDocCount = in.readVLong();
        int size = in.readVInt();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(size);
        for (int i = 0; i < size; ++i) {
            Bucket bucket = new Bucket(this.formatter, this.showTermDocCountError);
            bucket.readFrom(in);
            buckets.add(bucket);
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeLong(this.docCountError);
        }
        InternalOrder.Streams.writeOrder(this.order, out);
        ValueFormatterStreams.writeOptional(this.formatter, out);
        DoubleTerms.writeSize(this.requiredSize, out);
        DoubleTerms.writeSize(this.shardSize, out);
        out.writeBoolean(this.showTermDocCountError);
        out.writeVLong(this.minDocCount);
        out.writeVLong(this.otherDocCount);
        out.writeVInt(this.buckets.size());
        for (InternalTerms.Bucket bucket : this.buckets) {
            bucket.writeTo(out);
        }
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("doc_count_error_upper_bound", this.docCountError);
        builder.field("sum_other_doc_count", this.otherDocCount);
        builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        for (InternalTerms.Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    static class Bucket
    extends InternalTerms.Bucket {
        double term;

        public Bucket(ValueFormatter formatter, boolean showDocCountError) {
            super(formatter, showDocCountError);
        }

        public Bucket(double term, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, ValueFormatter formatter) {
            super(docCount, aggregations, showDocCountError, docCountError, formatter);
            this.term = term;
        }

        @Override
        public String getKeyAsString() {
            return String.valueOf(this.term);
        }

        @Override
        public Object getKey() {
            return this.term;
        }

        @Override
        public Number getKeyAsNumber() {
            return this.term;
        }

        @Override
        int compareTerm(Terms.Bucket other) {
            return Double.compare(this.term, ((Number)other.getKey()).doubleValue());
        }

        @Override
        Bucket newBucket(long docCount, InternalAggregations aggs, long docCountError) {
            return new Bucket(this.term, docCount, aggs, this.showDocCountError, docCountError, this.formatter);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.term = in.readDouble();
            this.docCount = in.readVLong();
            this.docCountError = -1L;
            if (this.showDocCountError) {
                this.docCountError = in.readLong();
            }
            this.aggregations = InternalAggregations.readAggregations(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.term);
            out.writeVLong(this.getDocCount());
            if (this.showDocCountError) {
                out.writeLong(this.docCountError);
            }
            this.aggregations.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(InternalAggregation.CommonFields.KEY, this.term);
            if (this.formatter != ValueFormatter.RAW) {
                builder.field(InternalAggregation.CommonFields.KEY_AS_STRING, this.formatter.format(this.term));
            }
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, this.getDocCount());
            if (this.showDocCountError) {
                builder.field("doc_count_error_upper_bound", this.getDocCountError());
            }
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }
    }
}

