/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.xml.AbstractXmlAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class UndoAction
extends AbstractXmlAction {
    private MindMapController controller;
    private boolean isUndoAction;
    protected Vector actionPairList = new Vector();
    private long timeOfLastAdd = 0L;
    private boolean actionFrameStarted = false;
    private static final long TIME_TO_BEGIN_NEW_ACTION = 100L;
    protected static Logger logger;

    public UndoAction(MindMapController controller) {
        this(controller, controller.getText("undo"), new ImageIcon(controller.getResource("images/undo.png")), controller);
        this.controller = controller;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().toString());
        }
    }

    protected UndoAction(MindMapController adapter, String text, Icon icon, MindMapController mode) {
        super(text, icon, mode);
        this.controller = adapter;
        this.setEnabled(false);
        this.isUndoAction = false;
    }

    public boolean isUndoAction() {
        return this.isUndoAction;
    }

    @Override
    protected void xmlActionPerformed(ActionEvent arg0) {
        if (this.actionPairList.size() > 0) {
            ActionPair pair = (ActionPair)this.actionPairList.get(0);
            this.informUndoPartner(pair);
            this.actionPairList.remove(0);
            this.undoDoAction(pair);
        }
        if (this.actionPairList.size() == 0) {
            this.setEnabled(false);
        }
    }

    protected void informUndoPartner(ActionPair pair) {
        this.controller.redo.add(pair.reverse());
        this.controller.redo.setEnabled(true);
    }

    protected void undoDoAction(ActionPair pair) {
        logger.info("Undo, doing: " + Tools.printXmlAction(pair.getUndoAction()));
        logger.info("Redo, would: " + Tools.printXmlAction(pair.getDoAction()));
        this.isUndoAction = true;
        this.controller.doTransaction("Undo", new ActionPair(pair.getUndoAction(), pair.getDoAction()));
        this.isUndoAction = false;
    }

    @Override
    public void setEnabled(boolean arg0) {
        if (arg0) {
            super.setEnabled(this.actionPairList.size() != 0);
        } else {
            super.setEnabled(false);
        }
    }

    public void add(ActionPair pair) {
        XmlAction dcDo = Tools.deepCopy(pair.getDoAction());
        XmlAction dcUndo = Tools.deepCopy(pair.getUndoAction());
        long currentTime = System.currentTimeMillis();
        if (this.actionPairList.size() > 0 && (this.actionFrameStarted || currentTime - this.timeOfLastAdd < 100L)) {
            CompoundAction remedia;
            CompoundAction action;
            ActionPair firstPair = (ActionPair)this.actionPairList.get(0);
            if (!(firstPair.getDoAction() instanceof CompoundAction) || !(firstPair.getUndoAction() instanceof CompoundAction)) {
                action = new CompoundAction();
                action.addChoice((Object)firstPair.getDoAction());
                remedia = new CompoundAction();
                remedia.addChoice((Object)firstPair.getUndoAction());
                this.actionPairList.remove(0);
                this.actionPairList.add(0, new ActionPair((XmlAction)action, (XmlAction)remedia));
                firstPair = (ActionPair)this.actionPairList.get(0);
            } else {
                action = (CompoundAction)firstPair.getDoAction();
                remedia = (CompoundAction)firstPair.getUndoAction();
            }
            action.addChoice((Object)dcDo);
            remedia.addAtChoice(0, (Object)dcUndo);
        } else {
            ActionPair storagePair = new ActionPair(dcDo, dcUndo);
            this.actionPairList.add(0, storagePair);
            int maxEntries = 100;
            try {
                maxEntries = new Integer(this.controller.getFrame().getProperty("undo_levels"));
            }
            catch (NumberFormatException e) {
                Resources.getInstance().logException(e);
            }
            while (this.actionPairList.size() > maxEntries) {
                this.actionPairList.remove(this.actionPairList.size() - 1);
            }
        }
        this.startActionFrame();
        this.timeOfLastAdd = currentTime;
    }

    private void startActionFrame() {
        if (!this.actionFrameStarted && EventQueue.isDispatchThread()) {
            this.actionFrameStarted = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UndoAction.this.actionFrameStarted = false;
                }
            });
        }
    }

    public void clear() {
        this.actionPairList.clear();
    }

    public void print() {
        logger.info("Undo list:");
        int j = 0;
        for (ActionPair pair : this.actionPairList) {
            logger.info("line " + j++ + " = " + Tools.printXmlAction(pair.getDoAction()));
        }
    }
}

