/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import org.gradle.internal.SystemProperties;
import org.gradle.logging.internal.AbstractStyledTextOutput;

public abstract class AbstractLineChoppingStyledTextOutput
extends AbstractStyledTextOutput {
    private final char[] eolChars;
    private final String eol = SystemProperties.getInstance().getLineSeparator();
    private int seenCharsFromEol;

    protected AbstractLineChoppingStyledTextOutput() {
        this.eolChars = this.eol.toCharArray();
    }

    protected final void doAppend(String text) {
        int max = text.length();
        int pos = 0;
        int start = 0;
        while (pos < max) {
            if (this.seenCharsFromEol == this.eolChars.length) {
                this.doStartLine();
                this.seenCharsFromEol = 0;
            }
            if (this.seenCharsFromEol < this.eolChars.length && text.charAt(pos) == this.eolChars[this.seenCharsFromEol]) {
                ++this.seenCharsFromEol;
                ++pos;
                if (this.seenCharsFromEol != this.eolChars.length) continue;
                if (start < pos - this.seenCharsFromEol) {
                    this.doLineText(text.substring(start, pos - this.seenCharsFromEol));
                }
                this.doEndLine(this.eol);
                start = pos;
                continue;
            }
            if (this.seenCharsFromEol > 0 && start == 0) {
                this.doLineText(this.eol.substring(0, this.seenCharsFromEol));
                start = pos;
            }
            this.seenCharsFromEol = 0;
            ++pos;
        }
        if (start < pos - this.seenCharsFromEol) {
            this.doLineText(text.substring(start, pos - this.seenCharsFromEol));
        }
    }

    protected void doStartLine() {
    }

    protected abstract void doLineText(CharSequence var1);

    protected abstract void doEndLine(CharSequence var1);
}

