/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import com.google.common.collect.ImmutableListMultimap;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.PluginDependenciesSpec;
import org.gradle.plugin.use.PluginDependencySpec;
import org.gradle.plugin.use.internal.DefaultPluginRequest;
import org.gradle.plugin.use.internal.InvalidPluginRequestException;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginRequestCollector {
    private final ScriptSource scriptSource;
    private final List<DependencySpecImpl> specs = new LinkedList<DependencySpecImpl>();

    public PluginRequestCollector(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public PluginDependenciesSpec createSpec(final int lineNumber) {
        return new PluginDependenciesSpec(){

            public PluginDependencySpec id(String id) {
                DependencySpecImpl spec = new DependencySpecImpl(id, lineNumber);
                PluginRequestCollector.this.specs.add(spec);
                return spec;
            }
        };
    }

    public List<PluginRequest> getRequests() {
        List pluginRequests = CollectionUtils.collect(this.specs, (Transformer)new Transformer<PluginRequest, DependencySpecImpl>(){

            public PluginRequest transform(DependencySpecImpl original) {
                return new DefaultPluginRequest(original.id, original.version, original.lineNumber, PluginRequestCollector.this.scriptSource);
            }
        });
        ImmutableListMultimap groupedById = CollectionUtils.groupBy((Iterable)pluginRequests, (Transformer)new Transformer<PluginId, PluginRequest>(){

            public PluginId transform(PluginRequest pluginRequest) {
                return pluginRequest.getId();
            }
        });
        for (PluginId key : groupedById.keySet()) {
            List pluginRequestsForId = groupedById.get((Object)key);
            if (pluginRequestsForId.size() <= 1) continue;
            PluginRequest first = (PluginRequest)pluginRequests.get(0);
            PluginRequest second = (PluginRequest)pluginRequests.get(1);
            InvalidPluginRequestException exception = new InvalidPluginRequestException(second, "Plugin with id '" + key + "' was already requested at line " + first.getLineNumber());
            throw new LocationAwareException((Throwable)((Object)exception), second.getScriptDisplayName(), (Integer)second.getLineNumber());
        }
        return pluginRequests;
    }

    private static class DependencySpecImpl
    implements PluginDependencySpec {
        private final PluginId id;
        private String version;
        private final int lineNumber;

        private DependencySpecImpl(String id, int lineNumber) {
            this.id = PluginId.of(id);
            this.lineNumber = lineNumber;
        }

        public void version(String version) {
            this.version = version;
        }
    }
}

