/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.internal.AsmBackedClassGenerator;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TmpDirTemporaryFileProvider;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.groovy.scripts.StringScriptSource;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.DefaultProjectDescriptorRegistry;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.invocation.DefaultGradle;
import org.gradle.logging.LoggingServiceRegistry;
import org.gradle.testfixtures.internal.TestBuildScopeServices;
import org.gradle.testfixtures.internal.TestGlobalScopeServices;
import org.gradle.util.GFileUtils;

public class ProjectBuilderImpl {
    private static ServiceRegistry globalServices;
    private static final AsmBackedClassGenerator CLASS_GENERATOR;

    public Project createChildProject(String name, Project parent, File projectDir) {
        ProjectInternal parentProject = (ProjectInternal)parent;
        DefaultProject project = CLASS_GENERATOR.newInstance(DefaultProject.class, name, parentProject, projectDir != null ? projectDir.getAbsoluteFile() : new File(parentProject.getProjectDir(), name), new StringScriptSource("test build file", null), parentProject.getGradle(), parentProject.getGradle().getServiceRegistryFactory(), parentProject.getClassLoaderScope().createChild("project-" + name), parentProject.getBaseClassLoaderScope());
        parentProject.addChildProject(project);
        parentProject.getProjectRegistry().addProject(project);
        return project;
    }

    public Project createProject(String name, File inputProjectDir) {
        File projectDir = this.prepareProjectDir(inputProjectDir);
        File homeDir = new File(projectDir, "gradleHome");
        StartParameter startParameter = new StartParameter();
        File userHomeDir = new File(projectDir, "userHome");
        startParameter.setGradleUserHomeDir(userHomeDir);
        NativeServices.initialize((File)userHomeDir);
        TestBuildScopeServices topLevelRegistry = new TestBuildScopeServices(this.getGlobalServices(), startParameter, homeDir);
        GradleInternal gradle = CLASS_GENERATOR.newInstance(DefaultGradle.class, null, startParameter, topLevelRegistry.get(ServiceRegistryFactory.class));
        DefaultProjectDescriptor projectDescriptor = new DefaultProjectDescriptor(null, name, projectDir, new DefaultProjectDescriptorRegistry(), (PathToFileResolver)topLevelRegistry.get(FileResolver.class));
        ClassLoaderScope baseScope = gradle.getClassLoaderScope();
        ClassLoaderScope rootProjectScope = baseScope.createChild("root-project");
        ProjectInternal project = ((IProjectFactory)topLevelRegistry.get(IProjectFactory.class)).createProject(projectDescriptor, null, gradle, rootProjectScope, baseScope);
        gradle.setRootProject(project);
        gradle.setDefaultProject(project);
        return project;
    }

    private ServiceRegistry getGlobalServices() {
        if (globalServices == null) {
            globalServices = ServiceRegistryBuilder.builder().displayName("global services").parent((ServiceRegistry)LoggingServiceRegistry.newNestedLogging()).parent((ServiceRegistry)NativeServices.getInstance()).provider((Object)new TestGlobalScopeServices()).build();
        }
        return globalServices;
    }

    public File prepareProjectDir(File projectDir) {
        if (projectDir == null) {
            TmpDirTemporaryFileProvider temporaryFileProvider = new TmpDirTemporaryFileProvider();
            projectDir = temporaryFileProvider.createTemporaryDirectory("gradle", "projectDir", new String[0]);
            projectDir.deleteOnExit();
        } else {
            projectDir = GFileUtils.canonicalise(projectDir);
        }
        return projectDir;
    }

    static {
        CLASS_GENERATOR = new AsmBackedClassGenerator();
    }
}

