/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Collection;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PropertyAccessorType {
    IS_GETTER(2){

        @Override
        public ModelType<?> propertyTypeFor(Method method) {
            return ModelType.returnType(method);
        }
    }
    ,
    GET_GETTER(3){

        @Override
        public ModelType<?> propertyTypeFor(Method method) {
            return ModelType.returnType(method);
        }
    }
    ,
    SETTER(3){

        @Override
        public ModelType<?> propertyTypeFor(Method method) {
            return ModelType.paramType(method, 0);
        }
    };

    private final int prefixLength;

    private PropertyAccessorType(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public String propertyNameFor(Method method) {
        return this.propertyNameFor(method.getName());
    }

    public String propertyNameFor(String methodName) {
        String methodNamePrefixRemoved = methodName.substring(this.prefixLength);
        return Introspector.decapitalize(methodNamePrefixRemoved);
    }

    public abstract ModelType<?> propertyTypeFor(Method var1);

    public static PropertyAccessorType of(Method method) {
        String methodName = method.getName();
        if (!PropertyAccessorType.hasVoidReturnType(method) && PropertyAccessorType.takesNoParameter(method)) {
            if (PropertyAccessorType.isGetGetterName(methodName)) {
                return GET_GETTER;
            }
            if (PropertyAccessorType.isIsGetterName(methodName)) {
                return IS_GETTER;
            }
        }
        if (PropertyAccessorType.hasVoidReturnType(method) && PropertyAccessorType.takesSingleParameter(method) && PropertyAccessorType.isSetterName(methodName)) {
            return SETTER;
        }
        return null;
    }

    public static PropertyAccessorType fromName(String methodName) {
        if (PropertyAccessorType.isGetGetterName(methodName)) {
            return GET_GETTER;
        }
        if (PropertyAccessorType.isIsGetterName(methodName)) {
            return IS_GETTER;
        }
        if (PropertyAccessorType.isSetterName(methodName)) {
            return SETTER;
        }
        return null;
    }

    public static boolean hasVoidReturnType(Method method) {
        return Void.TYPE.equals(method.getReturnType());
    }

    public static boolean takesNoParameter(Method method) {
        return method.getParameterTypes().length == 0;
    }

    public static boolean takesSingleParameter(Method method) {
        return method.getParameterTypes().length == 1;
    }

    public static boolean isPropertyMethodName(String methodName) {
        return PropertyAccessorType.isGetGetterName(methodName) || PropertyAccessorType.isIsGetterName(methodName) || PropertyAccessorType.isSetterName(methodName);
    }

    public static boolean isGetterName(String methodName) {
        return PropertyAccessorType.isGetGetterName(methodName) || PropertyAccessorType.isIsGetterName(methodName);
    }

    private static boolean isGetGetterName(String methodName) {
        return methodName.startsWith("get") && !"get".equals(methodName) && PropertyAccessorType.hasAtMostOneFirstLowerCaseCharStartingFrom(methodName, 4);
    }

    private static boolean isIsGetterName(String methodName) {
        return methodName.startsWith("is") && !"is".equals(methodName) && PropertyAccessorType.hasAtMostOneFirstLowerCaseCharStartingFrom(methodName, 3);
    }

    public static boolean isSetterName(String methodName) {
        return methodName.startsWith("set") && !"set".equals(methodName) && PropertyAccessorType.hasAtMostOneFirstLowerCaseCharStartingFrom(methodName, 4);
    }

    private static boolean hasAtMostOneFirstLowerCaseCharStartingFrom(String methodName, int position) {
        if (methodName.length() <= position || Character.isUpperCase(methodName.charAt(position - 1))) {
            return true;
        }
        return Character.isUpperCase(methodName.charAt(position));
    }

    public static boolean hasGetter(Collection<PropertyAccessorType> accessorTypes) {
        return accessorTypes.contains((Object)GET_GETTER) || accessorTypes.contains((Object)IS_GETTER);
    }

    public static boolean hasSetter(Collection<PropertyAccessorType> accessorTypes) {
        return accessorTypes.contains((Object)SETTER);
    }
}

