/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.javadoc;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.javadoc.AntGroovydoc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Groovydoc
extends SourceTask {
    private FileCollection groovyClasspath;
    private FileCollection classpath;
    private File destinationDir;
    private AntGroovydoc antGroovydoc;
    private boolean use;
    private boolean noTimestamp;
    private boolean noVersionStamp;
    private String windowTitle;
    private String docTitle;
    private String header;
    private String footer;
    private String overview;
    private Set<Link> links = new HashSet<Link>();
    boolean includePrivate;

    public Groovydoc() {
        this.getLogging().captureStandardOutput(LogLevel.INFO);
    }

    @TaskAction
    protected void generate() {
        this.checkGroovyClasspathNonEmpty(this.getGroovyClasspath().getFiles());
        this.getAntGroovydoc().execute((FileCollection)this.getSource(), this.getDestinationDir(), this.isUse(), this.isNoTimestamp(), this.isNoVersionStamp(), this.getWindowTitle(), this.getDocTitle(), this.getHeader(), this.getFooter(), this.getOverview(), this.isIncludePrivate(), this.getLinks(), (Iterable<File>)this.getGroovyClasspath(), (Iterable<File>)this.getClasspath(), this.getProject());
    }

    private void checkGroovyClasspathNonEmpty(Collection<File> classpath) {
        if (classpath.isEmpty()) {
            throw new InvalidUserDataException("You must assign a Groovy library to the groovy configuration!");
        }
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    @InputFiles
    public FileCollection getGroovyClasspath() {
        return this.groovyClasspath;
    }

    public void setGroovyClasspath(FileCollection groovyClasspath) {
        this.groovyClasspath = groovyClasspath;
    }

    @InputFiles
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    public AntGroovydoc getAntGroovydoc() {
        if (this.antGroovydoc == null) {
            IsolatedAntBuilder antBuilder = (IsolatedAntBuilder)this.getServices().get(IsolatedAntBuilder.class);
            ClassPathRegistry classPathRegistry = (ClassPathRegistry)this.getServices().get(ClassPathRegistry.class);
            this.antGroovydoc = new AntGroovydoc(antBuilder, classPathRegistry);
        }
        return this.antGroovydoc;
    }

    public void setAntGroovydoc(AntGroovydoc antGroovydoc) {
        this.antGroovydoc = antGroovydoc;
    }

    @Input
    public boolean isUse() {
        return this.use;
    }

    public void setUse(boolean use) {
        this.use = use;
    }

    @Input
    public boolean isNoTimestamp() {
        return this.noTimestamp;
    }

    public void setNoTimestamp(boolean noTimestamp) {
        this.noTimestamp = noTimestamp;
    }

    @Input
    public boolean isNoVersionStamp() {
        return this.noVersionStamp;
    }

    public void setNoVersionStamp(boolean noVersionStamp) {
        this.noVersionStamp = noVersionStamp;
    }

    @Input
    @Optional
    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    @Input
    @Optional
    public String getDocTitle() {
        return this.docTitle;
    }

    public void setDocTitle(String docTitle) {
        this.docTitle = docTitle;
    }

    @Input
    @Optional
    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    @Input
    @Optional
    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getOverview() {
        return this.overview;
    }

    public void setOverview(String overview) {
        this.overview = overview;
    }

    @Input
    public boolean isIncludePrivate() {
        return this.includePrivate;
    }

    public void setIncludePrivate(boolean includePrivate) {
        this.includePrivate = includePrivate;
    }

    @Input
    public Set<Link> getLinks() {
        return Collections.unmodifiableSet(this.links);
    }

    public void setLinks(Set<Link> links) {
        this.links = links;
    }

    public void link(String url, String ... packages) {
        this.links.add(new Link(url, packages));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Link
    implements Serializable {
        private List<String> packages = new ArrayList<String>();
        private String url;

        public Link(String url, String ... packages) {
            this.throwExceptionIfNull(url, "Url must not be null");
            if (packages.length == 0) {
                throw new InvalidUserDataException("You must specify at least one package!");
            }
            for (String aPackage : packages) {
                this.throwExceptionIfNull(aPackage, "A package must not be null");
            }
            this.packages = Arrays.asList(packages);
            this.url = url;
        }

        private void throwExceptionIfNull(String value, String message) {
            if (value == null) {
                throw new InvalidUserDataException(message);
            }
        }

        public List<String> getPackages() {
            return Collections.unmodifiableList(this.packages);
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Link link = (Link)o;
            if (this.packages != null ? !this.packages.equals(link.packages) : link.packages != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(link.url) : link.url != null);
        }

        public int hashCode() {
            int result = this.packages != null ? this.packages.hashCode() : 0;
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            return result;
        }
    }
}

