/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.services;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.PosixFiles;
import net.rubygrapefruit.platform.Process;
import net.rubygrapefruit.platform.ProcessLauncher;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.Terminals;
import net.rubygrapefruit.platform.WindowsRegistry;
import net.rubygrapefruit.platform.internal.DefaultProcessLauncher;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.nativeintegration.NativeIntegrationUnavailableException;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.NativePlatformConsoleDetector;
import org.gradle.internal.nativeintegration.console.NoOpConsoleDetector;
import org.gradle.internal.nativeintegration.console.WindowsConsoleDetector;
import org.gradle.internal.nativeintegration.filesystem.services.FileSystemServices;
import org.gradle.internal.nativeintegration.filesystem.services.UnavailablePosixFiles;
import org.gradle.internal.nativeintegration.jna.JnaBootPathConfigurer;
import org.gradle.internal.nativeintegration.jna.UnsupportedEnvironment;
import org.gradle.internal.nativeintegration.processenvironment.NativePlatformBackedProcessEnvironment;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeServices
extends DefaultServiceRegistry
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeServices.class);
    private static boolean useNativePlatform = "true".equalsIgnoreCase(System.getProperty("org.gradle.native", "true"));
    private static final NativeServices INSTANCE = new NativeServices();
    private static boolean initialized;
    public static final String NATIVE_DIR_OVERRIDE = "org.gradle.native.dir";

    public static void initialize(File userHomeDir) {
        NativeServices.initialize(userHomeDir, true);
    }

    public static synchronized void initialize(File userHomeDir, boolean initializeJNA) {
        if (!initialized) {
            String overrideProperty = System.getProperty(NATIVE_DIR_OVERRIDE);
            File nativeDir = overrideProperty == null ? new File(userHomeDir, "native") : new File(overrideProperty);
            if (useNativePlatform) {
                try {
                    Native.init((File)nativeDir);
                }
                catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                    LOGGER.debug("Native-platform is not available.");
                    useNativePlatform = false;
                }
                catch (NativeException ex) {
                    if (ex.getCause() instanceof UnsatisfiedLinkError && ex.getCause().getMessage().toLowerCase().contains("already loaded in another classloader")) {
                        LOGGER.debug("Unable to initialize native-platform. Failure: {}", (Object)NativeServices.format(ex));
                        useNativePlatform = false;
                    }
                    throw ex;
                }
            }
            if (OperatingSystem.current().isWindows() && initializeJNA) {
                new JnaBootPathConfigurer().configure(nativeDir);
            }
            initialized = true;
        }
    }

    public static synchronized NativeServices getInstance() {
        if (!initialized) {
            throw new IllegalStateException("Cannot get an instance of NativeServices without first calling initialize().");
        }
        return INSTANCE;
    }

    private NativeServices() {
        this.addProvider(new FileSystemServices());
    }

    public void close() {
    }

    protected OperatingSystem createOperatingSystem() {
        return OperatingSystem.current();
    }

    protected Jvm createJvm() {
        return Jvm.current();
    }

    protected ProcessEnvironment createProcessEnvironment(OperatingSystem operatingSystem) {
        if (useNativePlatform) {
            try {
                Process process = (Process)Native.get(Process.class);
                return new NativePlatformBackedProcessEnvironment(process);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform process integration is not available. Continuing with fallback.");
            }
        }
        return new UnsupportedEnvironment();
    }

    protected ConsoleDetector createConsoleDetector(OperatingSystem operatingSystem) {
        if (useNativePlatform) {
            try {
                Terminals terminals = (Terminals)Native.get(Terminals.class);
                return new NativePlatformConsoleDetector(terminals);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform terminal integration is not available. Continuing with fallback.");
            }
            catch (NativeException ex) {
                LOGGER.debug("Unable to load from native-platform backed ConsoleDetector. Continuing with fallback. Failure: {}", (Object)NativeServices.format(ex));
            }
        }
        try {
            if (operatingSystem.isWindows()) {
                return new WindowsConsoleDetector();
            }
        }
        catch (LinkageError e) {
            LOGGER.debug("Unable to load native library. Continuing with fallback. Failure: {}", (Object)NativeServices.format(e));
        }
        return new NoOpConsoleDetector();
    }

    protected WindowsRegistry createWindowsRegistry(OperatingSystem operatingSystem) {
        if (useNativePlatform && operatingSystem.isWindows()) {
            return (WindowsRegistry)Native.get(WindowsRegistry.class);
        }
        return this.notAvailable(WindowsRegistry.class);
    }

    protected SystemInfo createSystemInfo() {
        if (useNativePlatform) {
            try {
                return (SystemInfo)Native.get(SystemInfo.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform system info is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(SystemInfo.class);
    }

    protected ProcessLauncher createProcessLauncher() {
        if (useNativePlatform) {
            try {
                return (ProcessLauncher)Native.get(ProcessLauncher.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform process launcher is not available. Continuing with fallback.");
            }
        }
        return new DefaultProcessLauncher();
    }

    protected PosixFiles createPosixFiles() {
        if (useNativePlatform) {
            try {
                return (PosixFiles)Native.get(PosixFiles.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform posix files is not available.  Continuing with fallback.");
            }
        }
        return this.notAvailable(UnavailablePosixFiles.class);
    }

    private <T> T notAvailable(Class<T> type) {
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new BrokenService(type.getSimpleName()));
    }

    private static String format(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        builder.append(throwable.toString());
        for (Throwable current = throwable.getCause(); current != null; current = current.getCause()) {
            builder.append(SystemProperties.getInstance().getLineSeparator());
            builder.append("caused by: ");
            builder.append(current.toString());
        }
        return builder.toString();
    }

    private static class BrokenService
    implements InvocationHandler {
        private final String type;

        private BrokenService(String type) {
            this.type = type;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new NativeIntegrationUnavailableException(String.format("%s is not supported on this operating system.", this.type));
        }
    }
}

