/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.internal.concurrent;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.gradle.testkit.jarjar.org.gradle.internal.UncheckedException;
import org.gradle.testkit.jarjar.org.gradle.internal.concurrent.ExecutorPolicy;
import org.gradle.testkit.jarjar.org.gradle.internal.concurrent.StoppableExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StoppableExecutorImpl
extends AbstractExecutorService
implements StoppableExecutor {
    private final ExecutorService executor;
    private final ThreadLocal<Runnable> executing = new ThreadLocal();
    private final ExecutorPolicy executorPolicy;

    StoppableExecutorImpl(ExecutorService executor, ExecutorPolicy executorPolicy) {
        this.executor = executor;
        this.executorPolicy = executorPolicy;
    }

    @Override
    public void execute(final Runnable command) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                StoppableExecutorImpl.this.executing.set(command);
                try {
                    StoppableExecutorImpl.this.executorPolicy.onExecute(command);
                }
                finally {
                    StoppableExecutorImpl.this.executing.set(null);
                }
            }
        });
    }

    @Override
    public void requestStop() {
        this.executor.shutdown();
    }

    @Override
    public void stop() {
        this.stop(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public void stop(int timeoutValue, TimeUnit timeoutUnits) throws IllegalStateException {
        this.requestStop();
        if (this.executing.get() != null) {
            throw new IllegalStateException("Cannot stop this executor from an executor thread.");
        }
        try {
            if (!this.executor.awaitTermination(timeoutValue, timeoutUnits)) {
                this.executor.shutdownNow();
                throw new IllegalStateException("Timeout waiting for concurrent jobs to complete.");
            }
        }
        catch (InterruptedException e) {
            throw new UncheckedException(e);
        }
        this.executorPolicy.onStop();
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }
}

