/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.internal.event;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.testkit.jarjar.org.gradle.api.Action;
import org.gradle.testkit.jarjar.org.gradle.internal.event.AbstractBroadcastDispatch;
import org.gradle.testkit.jarjar.org.gradle.messaging.dispatch.Dispatch;
import org.gradle.testkit.jarjar.org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.testkit.jarjar.org.gradle.messaging.dispatch.ReflectionDispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastDispatch<T>
extends AbstractBroadcastDispatch<T> {
    private final Map<Object, Dispatch<MethodInvocation>> handlers = new LinkedHashMap<Object, Dispatch<MethodInvocation>>();

    public BroadcastDispatch(Class<T> type) {
        super(type);
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    public void add(Dispatch<MethodInvocation> dispatch) {
        this.handlers.put(dispatch, dispatch);
    }

    public void add(T listener) {
        this.handlers.put(listener, new ReflectionDispatch(listener));
    }

    public void add(String methodName, Action<?> action) {
        this.assertIsMethod(methodName);
        this.handlers.put(action, new ActionInvocationHandler(methodName, action));
    }

    private void assertIsMethod(String methodName) {
        for (Method method : this.type.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Method %s() not found for listener type %s.", methodName, this.type.getSimpleName()));
    }

    public void remove(Object listener) {
        this.handlers.remove(listener);
    }

    public void removeAll() {
        this.handlers.clear();
    }

    @Override
    public void dispatch(MethodInvocation message) {
        Iterator<Dispatch<MethodInvocation>> iterator = new ArrayList<Dispatch<MethodInvocation>>(this.handlers.values()).iterator();
        this.dispatch(message, iterator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActionInvocationHandler
    implements Dispatch<MethodInvocation> {
        private final String methodName;
        private final Action action;

        public ActionInvocationHandler(String methodName, Action action) {
            this.methodName = methodName;
            this.action = action;
        }

        @Override
        public void dispatch(MethodInvocation message) {
            if (message.getMethod().getName().equals(this.methodName)) {
                this.action.execute(message.getArguments()[0]);
            }
        }
    }
}

