/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.internal.jvm;

import org.gradle.testkit.jarjar.org.gradle.api.GradleException;
import org.gradle.testkit.jarjar.org.gradle.api.JavaVersion;
import org.gradle.testkit.jarjar.org.gradle.util.GradleVersion;

public class UnsupportedJavaRuntimeException
extends GradleException {
    public UnsupportedJavaRuntimeException(String message) {
        super(message);
    }

    public UnsupportedJavaRuntimeException(JavaVersion javaVersion) {
        super(String.format("Gradle %s requires Java 6 or later to run. Your build is currently configured to use Java %s.", GradleVersion.current().getVersion(), javaVersion.getMajorVersion()));
    }

    public static UnsupportedJavaRuntimeException usingUnsupportedVersion(String component, JavaVersion minVersion) {
        return new UnsupportedJavaRuntimeException(String.format("%s %s requires Java %s or later to run. You are currently using Java %s.", component, GradleVersion.current().getVersion(), minVersion.getMajorVersion(), JavaVersion.current().getMajorVersion()));
    }

    public static UnsupportedJavaRuntimeException configuredWithUnsupportedVersion(String component, JavaVersion minVersion, JavaVersion configuredVersion) {
        return new UnsupportedJavaRuntimeException(String.format("%s %s requires Java %s or later to run. Your build is currently configured to use Java %s.", component, GradleVersion.current().getVersion(), minVersion.getMajorVersion(), configuredVersion.getMajorVersion()));
    }
}

