/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.logging.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gradle.testkit.jarjar.org.gradle.internal.TimeProvider;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.Console;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.DefaultStatusBarFormatter;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.FlushToOutputsEvent;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.Label;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.OutputEvent;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.OutputEventListener;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.ProgressEvent;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.ProgressStartEvent;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.progress.ProgressOperation;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.progress.ProgressOperations;

public class ConsoleBackedProgressRenderer
implements OutputEventListener {
    private final OutputEventListener listener;
    private final Console console;
    private final ProgressOperations operations = new ProgressOperations();
    private final DefaultStatusBarFormatter statusBarFormatter;
    private final ScheduledExecutorService executor;
    private final TimeProvider timeProvider;
    private final int throttleMs;
    private final Object lock = new Object();
    private long lastUpdate;
    private final List<OutputEvent> queue = new ArrayList<OutputEvent>();
    private ProgressOperation mostRecentOperation;
    private Label statusBar;

    public ConsoleBackedProgressRenderer(OutputEventListener listener, Console console, DefaultStatusBarFormatter statusBarFormatter, TimeProvider timeProvider) {
        this(listener, console, statusBarFormatter, Integer.getInteger("org.gradle.testkit.jarjar.org.gradle.console.throttle", 85), Executors.newSingleThreadScheduledExecutor(), timeProvider);
    }

    ConsoleBackedProgressRenderer(OutputEventListener listener, Console console, DefaultStatusBarFormatter statusBarFormatter, int throttleMs, ScheduledExecutorService executor, TimeProvider timeProvider) {
        this.throttleMs = throttleMs;
        this.listener = listener;
        this.console = console;
        this.statusBarFormatter = statusBarFormatter;
        this.executor = executor;
        this.timeProvider = timeProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutput(OutputEvent newEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(newEvent);
            if (newEvent instanceof FlushToOutputsEvent) {
                this.renderNow(this.timeProvider.getCurrentTime());
                return;
            }
            if (this.queue.size() > 1) {
                return;
            }
            long now = this.timeProvider.getCurrentTime();
            if (now - this.lastUpdate >= (long)this.throttleMs) {
                this.renderNow(now);
                return;
            }
            this.executor.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = ConsoleBackedProgressRenderer.this.lock;
                    synchronized (object) {
                        ConsoleBackedProgressRenderer.this.renderNow(ConsoleBackedProgressRenderer.this.timeProvider.getCurrentTime());
                    }
                }
            }, (long)this.throttleMs, TimeUnit.MILLISECONDS);
        }
    }

    private void renderNow(long now) {
        if (this.queue.isEmpty()) {
            return;
        }
        ProgressOperation lastOp = this.mostRecentOperation;
        for (OutputEvent event : this.queue) {
            try {
                if (event instanceof ProgressStartEvent) {
                    ProgressStartEvent startEvent = (ProgressStartEvent)event;
                    lastOp = this.operations.start(startEvent.getShortDescription(), startEvent.getStatus(), startEvent.getOperationId(), startEvent.getParentId());
                } else if (event instanceof ProgressCompleteEvent) {
                    ProgressOperation op = this.operations.complete(((ProgressCompleteEvent)event).getOperationId());
                    lastOp = op.getParent();
                } else if (event instanceof ProgressEvent) {
                    ProgressEvent progressEvent = (ProgressEvent)event;
                    lastOp = this.operations.progress(progressEvent.getStatus(), progressEvent.getOperationId());
                }
                this.listener.onOutput(event);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to process incoming event '" + event + "' (" + event.getClass().getSimpleName() + ")", e);
            }
        }
        if (lastOp != null) {
            this.getStatusBar().setText(this.statusBarFormatter.format(lastOp));
        } else if (this.mostRecentOperation != null) {
            this.getStatusBar().setText("");
        }
        this.console.flush();
        this.mostRecentOperation = lastOp;
        this.queue.clear();
        this.lastUpdate = now;
    }

    private Label getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = this.console.getStatusBar();
        }
        return this.statusBar;
    }
}

