/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder;

import java.io.IOException;
import org.grails.charsequences.CharSequences;
import org.grails.encoder.AbstractEncodedAppender;
import org.grails.encoder.EncodedAppender;
import org.grails.encoder.EncodingState;
import org.grails.encoder.StreamingEncoder;

public class StreamingEncoderEncodedAppender
extends AbstractEncodedAppender {
    private final StreamingEncoder encoder;
    private final EncodedAppender target;

    public StreamingEncoderEncodedAppender(StreamingEncoder encoder, EncodedAppender target) {
        this.encoder = encoder;
        this.target = target;
    }

    @Override
    public void close() throws IOException {
        this.target.close();
    }

    @Override
    public void flush() throws IOException {
        this.target.flush();
    }

    @Override
    protected void write(EncodingState encodingState, char[] b, int off, int len) throws IOException {
        if (this.shouldEncode(this.encoder, encodingState)) {
            this.encoder.encodeToStream(this.encoder, CharSequences.createCharSequence(b), off, len, this.target, this.createNewEncodingState(this.encoder, encodingState));
        } else {
            this.target.appendEncoded(null, encodingState, b, off, len);
        }
    }

    @Override
    protected void write(EncodingState encodingState, String str, int off, int len) throws IOException {
        if (this.shouldEncode(this.encoder, encodingState)) {
            this.encoder.encodeToStream(this.encoder, str, off, len, this.target, this.createNewEncodingState(this.encoder, encodingState));
        } else {
            this.target.appendEncoded(null, encodingState, str, off, len);
        }
    }

    @Override
    protected void appendCharSequence(EncodingState encodingState, CharSequence str, int start, int end) throws IOException {
        if (this.shouldEncode(this.encoder, encodingState.getPreviousEncodingState())) {
            this.encoder.encodeToStream(this.encoder, str, start, end - start, this.target, encodingState);
        } else {
            this.target.appendEncoded(null, encodingState, str, start, end - start);
        }
    }
}

