// -*- c++ -*-
// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_CONTEXT_H
#define _GSTREAMERMM_CONTEXT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2014 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <gst/gst.h>
#include <gstreamermm/miniobject.h>
#include <gstreamermm/structure.h>
 

namespace Gst
{
class Context : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Context CppObjectType;
  typedef GstContext BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstContext*       gobj();

  ///Provides access to the underlying C instance.
  const GstContext* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstContext* gobj_copy() const;

protected:
  // Do not derive this.  Gst::Context can neither be constructed nor deleted.
  Context();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  Context(const Context&);
  Context& operator=(const Context&);


public:
  static Glib::RefPtr<Context> create(const Glib::ustring& context_type, bool persistent);

  
  /** Creates a copy of the context. Returns a copy of the context.
   * 
   * @return A new copy of @a context.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Context> copy();
  
  /** Creates a copy of the context. Returns a copy of the context.
   * 
   * @return A new copy of @a context.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Context> copy() const;

  
  /** Get the type of @a context.
   * 
   * @return The type of the context.
   */
  Glib::ustring get_context_type() const;

  
  /** Checks if @a context has @a context_type.
   * 
   * @param context_type Context type to check.
   * @return <tt>true</tt> if @a context has @a context_type.
   */
  bool has_context_type(const Glib::ustring& context_type) const;

  
  /** Check if @a context is persistent.
   * 
   * @return <tt>true</tt> if the context is persistent.
   */
  bool is_persistent() const;

  
  /** Get a writable version of the structure.
   * 
   * @return The structure of the context. The structure is still
   * owned by the event, which means that you should not free it and
   * that the pointer becomes invalid when you free the event.
   * This function checks if @a context is writable.
   */
  Gst::Structure writable_structure() const;


};
}


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Context
   */
  Glib::RefPtr<Gst::Context> wrap(GstContext* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_CONTEXT_H */

