/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.Interface;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.util.Logger;

public class XmlChem3dReader
extends XmlReader {
    private Lst<Map<String, Object>> orbitals = new Lst();
    private Map<String, Object> moData;

    @Override
    protected void processXml(XmlReader xmlReader, Object object) throws Exception {
        this.processXml2(xmlReader, object);
        this.finalizeMOData(this.moData);
    }

    @Override
    public void processStartElement(String string, String string2) {
        int n;
        String[] stringArray;
        if ("model".equals(string)) {
            this.asc.newAtomSet();
            return;
        }
        if ("atom".equals(string)) {
            this.atom = new Atom();
            this.atom.atomName = (String)this.atts.get("id");
            this.atom.elementSymbol = (String)this.atts.get("symbol");
            if (this.atts.containsKey("cartcoords")) {
                String string3 = (String)this.atts.get("cartcoords");
                String[] stringArray2 = PT.getTokens(string3);
                this.atom.set(this.parseFloatStr(stringArray2[0]), this.parseFloatStr(stringArray2[1]), this.parseFloatStr(stringArray2[2]));
            }
            return;
        }
        if ("bond".equals(string)) {
            String string4 = (String)this.atts.get("bondatom1");
            String string5 = (String)this.atts.get("bondatom2");
            int n2 = 1;
            if (this.atts.containsKey("bondorder")) {
                n2 = this.parseIntStr((String)this.atts.get("bondorder"));
            }
            this.asc.addNewBondFromNames(string4, string5, n2);
            return;
        }
        if ("electronicstructurecalculation".equals(string)) {
            stringArray = PT.getTokens((String)this.atts.get("calcpartialcharges"));
            String[] stringArray3 = PT.getTokens((String)this.atts.get("calcatoms"));
            n = this.parseIntStr(stringArray[0]);
            while (--n >= 0) {
                this.asc.mapPartialCharge(stringArray3[n + 1], this.parseFloatStr(stringArray[n + 1]));
            }
        }
        if ("griddata".equals(string)) {
            int n3;
            int n4;
            int n5;
            int n6 = this.parseIntStr((String)this.atts.get("griddatxdim"));
            n = this.parseIntStr((String)this.atts.get("griddatydim"));
            int n7 = this.parseIntStr((String)this.atts.get("griddatzdim"));
            float f = this.parseFloatStr((String)this.atts.get("griddatxsize")) / (float)n6;
            float f2 = this.parseFloatStr((String)this.atts.get("griddatysize")) / (float)n;
            float f3 = this.parseFloatStr((String)this.atts.get("griddatzsize")) / (float)n7;
            stringArray = PT.getTokens((String)this.atts.get("griddatorigin"));
            float f4 = this.parseFloatStr(stringArray[0]);
            float f5 = this.parseFloatStr(stringArray[1]);
            float f6 = this.parseFloatStr(stringArray[2]);
            stringArray = PT.getTokens((String)this.atts.get("griddatdata"));
            int n8 = 1;
            float[][][] fArray = new float[n6][n][n7];
            float f7 = 0.0f;
            for (n5 = 0; n5 < n7; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        float f8;
                        fArray[n3][n4][n5] = f8 = this.parseFloatStr(stringArray[n8++]);
                        f7 += f8 * f8;
                    }
                }
            }
            f7 = (float)(1.0 / Math.sqrt(f7));
            for (n5 = 0; n5 < n7; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        float[] fArray2 = fArray[n3][n4];
                        int n9 = n5;
                        fArray2[n9] = fArray2[n9] * f7;
                    }
                }
            }
            VolumeData volumeData = (VolumeData)Interface.getOption("jvxl.data.VolumeData", this.vwr, "file");
            volumeData.setVoxelCounts(n6, n, n7);
            volumeData.setVolumetricVector(0, f, 0.0f, 0.0f);
            volumeData.setVolumetricVector(1, 0.0f, f2, 0.0f);
            volumeData.setVolumetricVector(2, 0.0f, 0.0f, f3);
            volumeData.setVolumetricOrigin(f4, f5, f6);
            volumeData.setVoxelDataAsArray(fArray);
            if (this.moData == null) {
                this.moData = new Hashtable<String, Object>();
                this.moData.put("defaultCutoff", Float.valueOf(0.01f));
                this.moData.put("haveVolumeData", Boolean.TRUE);
                this.moData.put("calculationType", "Chem3D");
                this.orbitals = new Lst();
                this.moData.put("mos", this.orbitals);
            }
            Hashtable<String, VolumeData> hashtable = new Hashtable<String, VolumeData>();
            hashtable.put("volumeData", volumeData);
            this.orbitals.addLast((Map<String, Object>)hashtable);
            Logger.info("Chem3D molecular orbital data displayable using ISOSURFACE MO " + this.orbitals.size());
            return;
        }
    }

    @Override
    void processEndElement(String string) {
        if ("atom".equals(string)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.parent.setAtomCoord(this.atom);
                this.asc.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.setKeepChars(false);
    }
}

