/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import javajs.api.GenericFileInterface;

class AwtFile
extends File
implements GenericFileInterface {
    AwtFile(String name) {
        super(name);
    }

    @Override
    public GenericFileInterface getParentAsFile() {
        AwtFile f = null;
        try {
            File file = this.getParentFile();
            f = new AwtFile(file.getAbsolutePath());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return f;
    }

    static Object getBufferedFileInputStream(String name) {
        File file = new File(name);
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    static Object getURLContents(URL url, byte[] outputBytes, String post) {
        try {
            URLConnection conn = url.openConnection();
            String type = null;
            if (outputBytes != null) {
                type = "application/octet-stream;";
            } else if (post != null) {
                type = "application/x-www-form-urlencoded";
            }
            if (type != null) {
                conn.setRequestProperty("Content-Type", type);
                conn.setDoOutput(true);
                if (outputBytes == null) {
                    OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                    wr.write(post);
                    wr.flush();
                } else {
                    conn.getOutputStream().write(outputBytes);
                    conn.getOutputStream().flush();
                }
            }
            return new BufferedInputStream(conn.getInputStream());
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    @Override
    public String getFullPath() {
        try {
            return this.getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
    }
}

