/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.messages.events;

import com.sparshui.common.Event;
import com.sparshui.common.Location;
import com.sparshui.common.utils.Converter;

public class RotateEvent
implements Event {
    private static final long serialVersionUID = -5467788080845086125L;
    private float _rotation;
    private Location _center;
    private long _time;

    public RotateEvent() {
        this._rotation = 0.0f;
        this._center = new Location();
    }

    public RotateEvent(float f, Location location, long l) {
        this._rotation = f;
        this._center = location;
        this._time = l;
    }

    public RotateEvent(byte[] byArray) {
        if (byArray.length < 12) {
            System.err.println("Error constructing Rotate Event.");
            this._rotation = 0.0f;
            this._center = new Location(0.0f, 0.0f);
        } else {
            this._rotation = Converter.byteArrayToFloat(byArray, 0);
            this._center = new Location(Converter.byteArrayToFloat(byArray, 4), Converter.byteArrayToFloat(byArray, 8));
        }
    }

    @Override
    public int getEventType() {
        return 1;
    }

    @Override
    public byte[] serialize() {
        byte[] byArray = new byte[16];
        Converter.intToByteArray(byArray, 0, this.getEventType());
        Converter.floatToByteArray(byArray, 4, this._rotation);
        Converter.floatToByteArray(byArray, 8, this._center.getX());
        Converter.floatToByteArray(byArray, 12, this._center.getY());
        return byArray;
    }

    public String toString() {
        return "Rotate Event - Rotation: " + this._rotation + ", Center: " + this._center.toString();
    }

    public float getRotation() {
        return this._rotation;
    }

    public long getTime() {
        return this._time;
    }

    public Location getCenter() {
        return this._center;
    }

    public void setCenter(Location location) {
        this._center = location;
    }

    public float getX() {
        return this._center.getX();
    }

    public float getY() {
        return this._center.getY();
    }
}

