/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M34;
import javajs.util.M4;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Group;
import org.jmol.script.ContextToken;
import org.jmol.script.SV;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptError;
import org.jmol.script.ScriptFlowContext;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptManager;
import org.jmol.script.ScriptParam;
import org.jmol.script.ScriptTokenParser;
import org.jmol.script.T;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class ScriptCompiler
extends ScriptTokenParser {
    private String filename;
    private boolean isSilent;
    private Map<String, SV> contextVariables;
    private T[][] aatokenCompiled;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private int lnLength = 8;
    private boolean preDefining;
    private boolean isShowScriptOutput;
    private boolean isCheckOnly;
    private boolean haveComments;
    String scriptExtensions;
    private ScriptFunction thisFunction;
    private ScriptFlowContext flowContext;
    private Lst<T> ltoken;
    private Lst<T[]> lltoken;
    private Lst<T> vBraces;
    private int ichBrace;
    private int cchToken;
    private int cchScript;
    private int nSemiSkip;
    private int parenCount;
    private int braceCount;
    private int setBraceCount;
    private int bracketCount;
    private int ptSemi;
    private int forPoint3;
    private int setEqualPt;
    private int iBrace;
    private boolean iHaveQuotedString;
    private boolean isEndOfCommand;
    private boolean needRightParen;
    private boolean endOfLine;
    private String comment;
    private static final int OK = 0;
    private static final int OK2 = 1;
    private static final int CONTINUE = 2;
    private static final int EOL = 3;
    private static final int ERROR = 4;
    private static final int RESTART = 5;
    private int tokLastMath;
    private boolean checkImpliedScriptCmd;
    private Lst<ScriptFunction> vFunctionStack;
    private boolean allowMissingEnd;
    private boolean isShowCommand;
    private boolean isComment;
    private boolean isUserToken;
    private boolean implicitString;
    private int tokInitialPlusPlus;
    private int afterWhite;
    private boolean isDotDot;
    private String ident;
    private String identLC;
    private Lst<T> vPush = new Lst();
    private int pushCount;
    private ScriptFlowContext forceFlowContext;
    private boolean haveENDIF;
    private char chFirst = '\u0000';
    private int afterMath;

    public ScriptCompiler(Viewer viewer) {
        this.vwr = viewer;
    }

    synchronized ScriptContext compile(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.isCheckOnly = bl4;
        this.filename = string;
        this.isSilent = bl2;
        this.script = string2;
        this.logMessages = !bl2 && !bl && bl3;
        this.preDefining = string == "#predefine";
        boolean bl5 = true;
        boolean bl6 = this.compile0(bl5);
        this.atokenInfix = null;
        if (!bl6) {
            this.handleError();
        }
        ScriptContext scriptContext = new ScriptContext();
        scriptContext.isComplete = bl6 = this.iBrace == 0 && this.parenCount == 0 && this.braceCount == 0 && this.bracketCount == 0;
        scriptContext.script = string2;
        scriptContext.scriptExtensions = this.scriptExtensions;
        scriptContext.errorType = this.errorType;
        if (this.errorType != null) {
            scriptContext.iCommandError = this.iCommand;
            this.setAaTokenCompiled();
        }
        scriptContext.saveTokens(this.aatokenCompiled);
        scriptContext.errorMessage = this.errorMessage;
        String string3 = scriptContext.errorMessageUntranslated = this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
        if (this.allowMissingEnd && scriptContext.errorMessage != null && scriptContext.errorMessageUntranslated.indexOf("missing END") >= 0) {
            scriptContext.errorMessage = scriptContext.errorMessageUntranslated;
        }
        scriptContext.lineIndices = this.lineIndices;
        scriptContext.lineNumbers = this.lineNumbers;
        scriptContext.vars = this.contextVariables;
        return scriptContext;
    }

    private void newContextVariable(String string) {
        this.theToken = T.o(0x40000000, string);
        if (this.pushCount > 0) {
            ContextToken contextToken = (ContextToken)this.vPush.get(this.pushCount - 1);
            contextToken.addName(string);
            if (contextToken.tok != 364558) {
                return;
            }
        }
        if (this.thisFunction == null) {
            if (this.contextVariables == null) {
                this.contextVariables = new Hashtable<String, SV>();
            }
            ScriptCompiler.addContextVariable(this.contextVariables, string);
        } else {
            this.thisFunction.addVariable(string, false);
        }
    }

    static void addContextVariable(Map<String, SV> map, String string) {
        map.put(string, SV.newS("").setName(string));
    }

    private boolean isContextVariable(String string) {
        int n = this.vPush.size();
        while (--n >= 0) {
            ContextToken contextToken = (ContextToken)this.vPush.get(n);
            if (contextToken.contextVariables == null || !contextToken.contextVariables.containsKey(string)) continue;
            return true;
        }
        return this.thisFunction != null ? this.thisFunction.isVariable(string) : this.contextVariables != null && this.contextVariables.containsKey(string);
    }

    private String cleanScriptComments(String string) {
        int n;
        if (string.indexOf(8220) >= 0) {
            string = string.replace('\u201c', '\"');
        }
        if (string.indexOf(8221) >= 0) {
            string = string.replace('\u201d', '\"');
        }
        if (string.indexOf(65279) >= 0) {
            string = string.replace('\ufeff', ' ');
        }
        if ((n = string.indexOf("\u0001##")) >= 0) {
            this.scriptExtensions = string.substring(n + 1);
            string = string.substring(0, n);
            this.allowMissingEnd = this.scriptExtensions.indexOf("##noendcheck") >= 0;
        }
        this.haveComments = string.indexOf("#") >= 0;
        return FileManager.getEmbeddedScript(string);
    }

    private void addTokenToPrefix(T t) {
        if (this.logMessages) {
            Logger.info("addTokenToPrefix" + this.lineCurrent + " " + this.iCommand + " " + t);
        }
        this.ltoken.addLast(t);
        if (t.tok != 0) {
            this.lastToken = t;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean compile0(boolean var1_1) {
        this.haveENDIF = false;
        this.script = this.cleanScriptComments(this.script);
        this.ichToken = this.script.indexOf("# Jmol state version ");
        v0 = this.isStateScript = this.ichToken >= 0;
        if (this.isStateScript) {
            this.ptSemi = this.script.indexOf(";", this.ichToken);
            if (this.ptSemi >= this.ichToken) {
                ScriptManager.setStateScriptVersion(this.vwr, this.script.substring(this.ichToken + "# Jmol state version ".length(), this.ptSemi).trim());
            }
        }
        this.cchScript = this.script.length();
        block23: while (true) {
            this.vFunctionStack = new Lst<V>();
            this.htUserFunctions = new Hashtable<K, V>();
            this.contextVariables = null;
            this.lineNumbers = null;
            this.lineIndices = null;
            this.aatokenCompiled = null;
            this.thisFunction = null;
            this.flowContext = null;
            this.errorType = null;
            this.errorMessage = null;
            this.errorMessageUntranslated = null;
            this.errorLine = null;
            this.nSemiSkip = 0;
            this.ichToken = 0;
            this.ichCurrentCommand = 0;
            this.ichComment = 0;
            this.ichBrace = 0;
            this.lineCurrent = 1;
            this.iCommand = 0;
            this.tokLastMath = 0;
            this.lastToken = T.tokenOff;
            this.vBraces = new Lst<V>();
            this.vPush = new Lst<V>();
            this.pushCount = 0;
            this.iBrace = 0;
            this.braceCount = 0;
            this.parenCount = 0;
            this.isDotDot = false;
            this.ptSemi = -10;
            this.cchToken = 0;
            this.lnLength = 8;
            this.lineNumbers = new short[this.lnLength];
            this.lineIndices = new int[this.lnLength][2];
            this.isSetBrace = false;
            this.isNewSet = false;
            this.ptNewSetModifier = 1;
            this.isShowScriptOutput = false;
            this.iHaveQuotedString = false;
            this.checkImpliedScriptCmd = false;
            this.lltoken = new Lst<V>();
            this.ltoken = new Lst<V>();
            this.tokCommand = 0;
            this.lastFlowCommand = null;
            this.tokenAndEquals = null;
            this.tokInitialPlusPlus = 0;
            this.setBraceCount = 0;
            this.bracketCount = 0;
            this.forPoint3 = -1;
            this.setEqualPt = 0x7FFFFFFF;
            this.endOfLine = false;
            this.comment = null;
            this.isEndOfCommand = false;
            this.needRightParen = false;
            this.lastFlowCommand = null;
            this.forceFlowContext = null;
            this.theTok = 0;
            var2_2 = 1;
            while (true) {
                block38: {
                    block40: {
                        block39: {
                            if ((this.nTokens = this.ltoken.size()) == 0) {
                                if (this.thisFunction != null && this.thisFunction.chpt0 == 0) {
                                    this.thisFunction.chpt0 = this.ichToken;
                                }
                                this.ichCurrentCommand = this.ichToken;
                                var2_2 = this.lineCurrent;
                            }
                            if (this.lookingAtLeadingWhitespace()) break block38;
                            this.endOfLine = false;
                            if (this.isEndOfCommand) break block39;
                            this.endOfLine = this.lookingAtEndOfLine();
                            switch (this.endOfLine != false ? 0 : this.lookingAtComment()) {
                                case 2: {
                                    break block38;
                                }
                                case 3: {
                                    this.isEndOfCommand = true;
                                    break block38;
                                }
                                case 1: {
                                    this.isEndOfCommand = true;
                                    this.comment = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                                }
                                default: {
                                    v1 = this.isEndOfCommand = this.isEndOfCommand != false || this.endOfLine != false || this.lookingAtTerminator() != false;
                                }
                            }
                        }
                        if (!this.isEndOfCommand) break block40;
                        this.isEndOfCommand = false;
                        switch (this.processTokenList(var2_2, var1_1)) {
                            case 2: {
                                break block38;
                            }
                            case 4: {
                                return false;
                            }
                            default: {
                                this.checkImpliedScriptCmd = false;
                                if (this.ichToken >= this.cchScript) {
                                    if (this.flowContext != null) {
                                        this.ichCurrentCommand = this.ichToken = this.cchScript;
                                        while (this.flowContext != null) {
                                            this.fixFlowAddLine(this.flowContext);
                                            if (!this.haveENDIF && this.flowContext.checkForceEndIf(0)) {
                                                this.forceFlowEnd(this.flowContext.token);
                                                this.processTokenList(var2_2, var1_1);
                                                continue;
                                            }
                                            this.lineCurrent = (short)this.flowContext.lineStart;
                                            this.iCommand = this.flowContext.pt0;
                                            this.ichCurrentCommand = this.lineIndices[this.iCommand][0];
                                            this.ichToken = this.ichEnd = this.lineIndices[this.iCommand][1];
                                            return this.errorStr(11, this.flowContext.function == null ? T.nameOf(this.flowContext.token.tok) : this.flowContext.function.getSignature());
                                        }
                                        this.lltoken.addLast(new T[]{T.o(0, "// end of script")});
                                    }
                                    this.setAaTokenCompiled();
                                    return true;
                                }
                                break block38;
                            }
                        }
                    }
                    if (this.nTokens <= 0 || this.isDotDot) ** GOTO lbl-1000
                    block9 : switch (this.checkSpecialParameterSyntax()) {
                        case 2: {
                            break;
                        }
                        case 4: {
                            return false;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            if (this.lookingAtLookupToken(this.ichToken)) {
                                switch (this.parseKnownToken()) {
                                    case 2: {
                                        break block9;
                                    }
                                    case 4: {
                                        return false;
                                    }
                                    case 5: {
                                        this.haveENDIF = true;
                                        continue block23;
                                    }
                                }
                                switch (this.parseCommandParameter(var2_2, var1_1)) {
                                    case 2: {
                                        break block9;
                                    }
                                    case 4: {
                                        return false;
                                    }
                                    case 5: {
                                        this.haveENDIF = true;
                                        continue block23;
                                    }
                                }
                                this.addTokenToPrefix(this.theToken);
                                break;
                            }
                            if (this.nTokens == 0 || (this.isNewSet || this.isSetBrace) && this.nTokens == this.ptNewSetModifier) {
                                if (this.nTokens == 0) {
                                    if (this.lookingAtString(true)) {
                                        this.addTokenToPrefix(this.setCommand(T.tokenScript));
                                        this.cchToken = 0;
                                        break;
                                    }
                                    if (this.lookingAtImpliedString(true, true, true)) {
                                        this.ichEnd = this.ichToken + this.cchToken;
                                    }
                                }
                                return this.commandExpected();
                            }
                            return this.errorStr(19, this.script.substring(this.ichToken, this.ichToken + 1));
                        }
                    }
                }
                this.ichToken += this.cchToken;
            }
            break;
        }
    }

    private void setAaTokenCompiled() {
        this.aatokenCompiled = (T[][])this.lltoken.toArray((T[])new T[this.lltoken.size()][]);
    }

    private boolean lookingAtLeadingWhitespace() {
        int n = this.ichToken;
        while (ScriptCompiler.isSpaceOrTab(this.charAt(n))) {
            ++n;
        }
        if (this.isLineContinuation(n, true)) {
            n += 1 + this.nCharNewLine(n + 1);
        }
        this.cchToken = n - this.ichToken;
        if (this.cchToken == 0) {
            return false;
        }
        this.afterWhite = n;
        return true;
    }

    private boolean isLineContinuation(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = n + 2 < this.cchScript && this.script.charAt(n) == '\\' && this.nCharNewLine(n + 1) > 0 || !this.isShowScriptOutput && bl && this.lookingAtMathContinuation(n);
        if (bl2) {
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        return bl2;
    }

    private boolean lookingAtMathContinuation(int n) {
        int n2 = this.nCharNewLine(n);
        if (n2 == 0 || this.lastToken.tok == 1073742332) {
            return false;
        }
        if (this.parenCount > 0 || this.bracketCount > 0) {
            return true;
        }
        switch (this.tokCommand) {
            case 102436: 
            case 134320141: {
                this.flowContext.forceEndIf = false;
                return false;
            }
            case 102402: 
            case 102406: 
            case 364547: 
            case 134320648: 
            case 134320649: {
                if (!this.haveENDIF) {
                    this.flowContext.addLine = 1;
                    this.flowContext.forceEndIf = true;
                }
                return false;
            }
            case 36867: {
                if (this.nTokens > 1 && ((T)this.ltoken.get((int)1)).tok == 537022465) {
                    return false;
                }
            }
            case 36865: 
            case 36869: {
                break;
            }
            default: {
                return false;
            }
        }
        if (this.lastToken.tok == this.tokLastMath) {
            return true;
        }
        n += n2;
        while (ScriptCompiler.isSpaceOrTab(this.charAt(n))) {
            ++n;
        }
        return this.lookingAtLookupToken(n) && this.tokLastMath == 1;
    }

    private boolean lookingAtEndOfLine() {
        if (this.ichToken >= this.cchScript) {
            this.ichEnd = this.cchScript;
            return true;
        }
        this.ichEnd = this.ichToken;
        this.cchToken = this.nCharNewLine(this.ichEnd);
        return this.cchToken > 0;
    }

    private int nCharNewLine(int n) {
        char c = this.charAt(n);
        return c != '\r' ? (c == '\n' ? 1 : 0) : (this.charAt(++n) == '\n' ? 2 : 1);
    }

    private boolean lookingAtTerminator() {
        boolean bl;
        boolean bl2 = bl = this.script.charAt(this.ichToken) == ';';
        if (bl && this.nTokens > 0) {
            this.ptSemi = this.nTokens;
        }
        if (!bl || this.nSemiSkip-- > 0) {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    private int lookingAtComment() {
        boolean bl;
        char c = this.script.charAt(this.ichToken);
        int n = this.ichToken;
        int n2 = -1;
        if (this.ichToken == this.ichCurrentCommand && c == '$' && (this.isShowScriptOutput || this.ichToken == 0)) {
            this.isShowScriptOutput = true;
            this.isShowCommand = true;
            if (this.charAt(++n) == '[') {
                while (c != ']' && !this.eol(c = this.charAt(n))) {
                    ++n;
                }
            }
            this.cchToken = n - this.ichToken;
            return 2;
        }
        if (this.isShowScriptOutput && !this.isShowCommand) {
            n2 = n;
        }
        if (c == '/' && n + 1 < this.cchScript) {
            switch (this.script.charAt(++n)) {
                case '/': {
                    n2 = this.ichToken;
                    this.ichEnd = n - 1;
                    break;
                }
                case '*': {
                    this.ichEnd = n - 1;
                    c = this.charAt(++n);
                    String string = c == '*' ? "**/" : "*/";
                    n = this.script.indexOf(string, this.ichToken + 2);
                    if (n < 0) {
                        this.ichToken = this.cchScript;
                        return 3;
                    }
                    this.incrementLineCount(this.script.substring(this.ichToken, n));
                    this.cchToken = n + (c == '*' ? 3 : 2) - this.ichToken;
                    return 2;
                }
                default: {
                    return 0;
                }
            }
        }
        boolean bl2 = bl = n2 < 0;
        if (bl && !this.haveComments) {
            return 0;
        }
        if (this.ichComment > n) {
            n = this.ichComment;
        }
        while (n < this.cchScript) {
            c = this.script.charAt(n);
            if (this.eol(c)) {
                this.ichEnd = n;
                if (n > 0 && this.isLineContinuation(n - 1, false)) {
                    n += this.nCharNewLine(n);
                } else if (bl || c != ';') break;
            } else if (n2 < 0 && c == '#') {
                n2 = n;
            }
            ++n;
        }
        if (n2 < 0) {
            return 0;
        }
        this.ichComment = n2;
        if (bl && this.nTokens == 0 && this.cchScript - n2 >= 3 && this.script.charAt(n2 + 1) == 'j' && this.script.charAt(n2 + 2) == 'c') {
            this.cchToken = n - this.ichToken;
            return 2;
        }
        if (n2 != this.ichToken) {
            return 0;
        }
        if (bl && this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && ScriptCompiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return 2;
        }
        if (n == this.ichToken) {
            return 0;
        }
        this.cchToken = n - this.ichToken;
        return this.nTokens == 0 ? 1 : 2;
    }

    private char charAt(int n) {
        return n < this.cchScript ? this.script.charAt(n) : (char)'\u0000';
    }

    private int processTokenList(short s, boolean bl) {
        boolean bl2;
        int n = this.ltoken.size();
        if (n > 0 || this.comment != null) {
            T t;
            if (n == 0) {
                this.ichCurrentCommand = this.ichToken;
                if (this.comment != null) {
                    this.isComment = true;
                    this.addTokenToPrefix(T.o(0, this.comment));
                }
            } else if (this.setBraceCount > 0 && this.endOfLine && this.ichToken < this.cchScript) {
                return 2;
            }
            if (this.wasImpliedScript()) {
                return 2;
            }
            if (this.isNewSet && n > 2 && this.tokAt(2) == 0x40000200 && (this.tokAt(3) == 1275068444 || this.tokAt(3) == 0x44000005 || this.tokAt(3) == 1275335685 || this.tokAt(3) == 1275334681)) {
                this.ltoken.set(0, T.tokenSet);
                this.ltoken.add(1, this.tokAt(3) == 1275334681 ? T.tokenAll : (T)this.ltoken.get(1));
            } else if (this.tokInitialPlusPlus != 0) {
                if (!this.isNewSet) {
                    this.checkNewSetCommand();
                }
                this.tokenizePlusPlus(this.tokInitialPlusPlus, true);
                this.ichCurrentCommand -= 2;
            }
            this.iCommand = this.lltoken.size();
            if (this.thisFunction != null && this.thisFunction.cmdpt0 < 0) {
                this.thisFunction.cmdpt0 = this.iCommand;
            }
            if (n == 1 && this.braceCount == 1) {
                if (this.lastFlowCommand == null) {
                    this.braceCount = 0;
                    this.setBraceCount = 0;
                    this.parenCount = 0;
                    this.ltoken.remove(0);
                    t = ContextToken.newContext(true);
                    this.addTokenToPrefix(this.setCommand(t));
                    this.pushContext(t);
                    this.addBrace(this.tokenCommand);
                } else {
                    this.setBraceCount = 0;
                    this.parenCount = 0;
                    this.setCommand(this.lastFlowCommand);
                    if (this.lastFlowCommand.tok != 102439 && this.tokAt(0) == 1073742332) {
                        this.ltoken.remove(0);
                    }
                    this.lastFlowCommand = null;
                    this.forceFlowContext = this.flowContext;
                }
            }
            if (this.bracketCount > 0 || this.setBraceCount > 0 || this.parenCount > 0 || this.braceCount == 1 && !this.checkFlowStartBrace(true)) {
                this.error(n == 1 ? 2 : 4);
                return 4;
            }
            if (this.needRightParen) {
                this.addTokenToPrefix(T.tokenRightParen);
                this.needRightParen = false;
            }
            if (this.tokAt(1) == 1073741974 && T.tokAttr(this.tokCommand, 135168)) {
                switch (this.tokAt(2)) {
                    case 0: 
                    case 4: 
                    case 12290: {
                        break;
                    }
                    default: {
                        t = (T)this.ltoken.remove(2);
                        this.ltoken.add(2, T.o(4, t.tok == 2 ? "" + t.intValue : t.value.toString()));
                    }
                }
            }
            if (this.ltoken.size() > 0) {
                if (bl && !this.compileCommand()) {
                    return 4;
                }
                if (this.logMessages) {
                    Logger.info("-------------------------------------");
                }
                boolean bl3 = true;
                switch (this.tokCommand) {
                    case 102409: 
                    case 102436: 
                    case 364558: 
                    case 134320141: {
                        boolean bl4 = bl3 = this.atokenInfix.length > 0 && this.atokenInfix[0].intValue != Integer.MAX_VALUE;
                    }
                }
                if (bl3) {
                    if (this.iCommand == this.lnLength) {
                        this.lineNumbers = AU.doubleLengthShort(this.lineNumbers);
                        int[][] nArray = new int[this.lnLength * 2][2];
                        System.arraycopy(this.lineIndices, 0, nArray, 0, this.lnLength);
                        this.lineIndices = nArray;
                        this.lnLength *= 2;
                    }
                    short s2 = s;
                    this.lineNumbers[this.lineNumbers.length - 1] = s2;
                    this.lineNumbers[this.iCommand] = s2;
                    this.lineIndices[this.iCommand][0] = this.ichCurrentCommand;
                    this.lineIndices[this.iCommand][1] = Math.max(this.ichCurrentCommand, Math.min(this.cchScript, this.ichEnd == this.ichCurrentCommand ? this.ichToken : this.ichEnd));
                    this.lltoken.addLast(this.atokenInfix);
                    this.iCommand = this.lltoken.size();
                }
                if (this.tokCommand == 36867) {
                    this.lastFlowCommand = null;
                }
            }
            this.setCommand(null);
            this.comment = null;
            this.needRightParen = false;
            this.isSetBrace = false;
            this.isNewSet = false;
            this.iHaveQuotedString = false;
            this.ptNewSetModifier = 1;
            this.ltoken.clear();
            this.nSemiSkip = 0;
            this.nTokens = 0;
            this.tokInitialPlusPlus = 0;
            this.tokenAndEquals = null;
            this.ptSemi = -10;
            this.forPoint3 = -1;
            this.setEqualPt = Integer.MAX_VALUE;
        }
        boolean bl5 = this.flowContext != null && this.flowContext.addLine == 0;
        boolean bl6 = bl2 = (this.endOfLine || !bl5) && !this.haveENDIF && this.flowContext != null && this.flowContext.checkForceEndIf(-1);
        if (this.endOfLine) {
            if (bl2) {
                if (this.isComment) {
                    if (!bl5) {
                        ++this.flowContext.addLine;
                        this.flowContext.forceEndIf = true;
                    }
                } else if (n > 0 && !this.haveENDIF || bl5) {
                    this.forceFlowEnd(this.flowContext.token);
                    if (!bl5) {
                        this.forceFlowContext.forceEndIf = true;
                    }
                }
                this.isEndOfCommand = true;
                this.cchToken = 0;
                this.ichCurrentCommand = this.ichToken;
                return 2;
            }
            this.isComment = false;
            this.isShowCommand = false;
            this.lineCurrent = (short)(this.lineCurrent + 1);
        } else if (bl2) {
            this.forceFlowEnd(this.flowContext.token);
            this.forceFlowContext.forceEndIf = true;
        }
        if (this.ichToken >= this.cchScript) {
            this.setCommand(T.tokenAll);
            this.theTok = 0;
            switch (this.checkFlowEndBrace()) {
                case 4: {
                    return 4;
                }
                case 2: {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
            }
            this.ichToken = this.cchScript;
            return 0;
        }
        return 0;
    }

    private void addBrace(T t) {
        this.vBraces.addLast(t);
        ++this.iBrace;
    }

    private void pushContext(T t) {
        ++this.pushCount;
        this.vPush.addLast(t);
    }

    private boolean wasImpliedScript() {
        if (this.checkImpliedScriptCmd && this.nTokens >= 2 && (this.tokCommand == 134222850 || this.tokCommand == 4124)) {
            String string;
            String string2 = string = this.nTokens == 2 ? this.lastToken.value.toString().toUpperCase() : null;
            if (this.nTokens > 2 ? this.tokAt(2) != 0x10000010 || !((T)this.ltoken.get((int)1)).value.toString().endsWith(".spt") : string.endsWith(".SORT") || string.endsWith(".REVERSE") || string.endsWith(".POP") || string.indexOf(".SORT(") >= 0 || string.indexOf(".REVERSE(") >= 0 || string.indexOf(".POP(") >= 0 || string.indexOf(".PUSH(") >= 0 || string.endsWith("++") || string.endsWith("--") || string.endsWith("=") || this.tokInitialPlusPlus != 0) {
                this.ichToken = this.ichCurrentCommand;
                this.nTokens = 0;
                this.ltoken.clear();
                this.cchToken = 0;
                this.tokCommand = 0;
                return true;
            }
        }
        return false;
    }

    private boolean compileCommand() {
        switch (this.ltoken.size()) {
            case 0: {
                this.atokenInfix = new T[0];
                return true;
            }
            case 4: {
                if (!this.isNewSet || !this.tokenAt((int)2).value.equals(".") || !this.tokenAt((int)3).value.equals("spt")) break;
                String string = this.tokenAt((int)1).value + "." + this.tokenAt((int)3).value;
                this.ltoken.clear();
                this.addTokenToPrefix(T.tokenScript);
                this.addTokenToPrefix(T.o(4, string));
                this.isNewSet = false;
            }
        }
        this.setCommand(this.tokenAt(0));
        int n = this.ltoken.size();
        if (n == 1 && T.tokAttr(this.tokCommand, 524288)) {
            this.addTokenToPrefix(T.tokenOn);
        }
        if (this.tokenAndEquals != null) {
            int n2;
            int n3 = 0;
            for (n3 = 1; n3 < n && (n2 = this.tokAt(n3)) != 268435666; ++n3) {
            }
            n = n3++;
            if (this.ltoken.size() < n3) {
                Logger.error("COMPILER ERROR! - andEquals ");
            } else {
                n2 = 1;
                while (n2 < n) {
                    this.ltoken.add(n3, this.tokenAt(n2));
                    ++n2;
                    ++n3;
                }
                this.ltoken.set(n, T.tokenEquals);
                this.ltoken.add(n3, this.tokenAndEquals);
                this.ltoken.add(++n3, T.tokenLeftParen);
                this.addTokenToPrefix(T.tokenRightParen);
            }
        }
        n = this.ltoken.size();
        this.atokenInfix = this.ltoken.toArray(new T[n]);
        return this.compileExpressions();
    }

    private T tokenAt(int n) {
        return (T)this.ltoken.get(n);
    }

    @Override
    protected int tokAt(int n) {
        return n < this.ltoken.size() ? this.tokenAt((int)n).tok : 0;
    }

    private T setCommand(T t) {
        this.tokenCommand = t;
        if (t == null) {
            this.tokCommand = 0;
        } else {
            this.tokCommand = this.tokenCommand.tok;
            this.isMathExpressionCommand = this.tokCommand == 0x40000000 || T.tokAttr(this.tokCommand, 36864);
            this.isSetOrDefine = this.tokCommand == 36867 || this.tokCommand == 12290;
            this.isCommaAsOrAllowed = T.tokAttr(this.tokCommand, 12288);
            this.implicitString = T.tokAttr(this.tokCommand, 20480);
        }
        return t;
    }

    private void replaceCommand(T t) {
        this.ltoken.remove(0);
        this.ltoken.add(0, this.setCommand(t));
    }

    private int getPrefixToken() {
        this.ident = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
        this.identLC = this.ident.toLowerCase();
        boolean bl = this.lastToken.tok != 0x40000200 && !this.isDotDot && this.isContextVariable(this.identLC);
        String string = this.ident;
        String string2 = null;
        if (this.nTokens == 0) {
            this.isUserToken = bl;
        }
        if (this.nTokens == 1 && (this.tokCommand == 134320141 || this.tokCommand == 102436 || this.tokCommand == 36868) || this.nTokens != 0 && bl || !this.isDotDot && this.isUserFunction(this.identLC) && (string2 = this.ident) != null && (this.thisFunction == null || !this.thisFunction.name.equals(this.identLC))) {
            this.ident = string2 == null ? this.identLC : string2;
            this.theToken = null;
        } else if (this.ident.length() == 1 || this.lastToken.tok == 0x10000022) {
            this.theToken = T.getTokenFromName(this.ident);
            if (this.theToken == null && (this.theToken = T.getTokenFromName(this.identLC)) != null) {
                this.theToken = T.tv(this.theToken.tok, this.theToken.intValue, this.ident);
            }
        } else {
            this.theToken = T.getTokenFromName(this.identLC);
            if (this.theToken != null) {
                switch (this.lastToken.tok) {
                    case 0x10000030: 
                    case 0x10000040: 
                    case 0x40000200: {
                        this.theToken = T.o(this.theToken.tok, this.ident);
                    }
                }
            }
        }
        if (this.theToken == null) {
            this.theToken = SV.newSV(this.identLC.indexOf("property_") == 0 ? 1715472409 : 0x40000000, Integer.MAX_VALUE, this.ident).setName(string);
        }
        this.theTok = this.theToken.tok;
        return this.theTok;
    }

    private int checkSpecialParameterSyntax() {
        char c;
        int n;
        boolean bl;
        char c2;
        if (this.lookingAtString(!this.implicitString)) {
            if (this.cchToken < 0) {
                return this.ERROR(4);
            }
            String string = this.getUnescapedStringLiteral(this.lastToken != null && !this.iHaveQuotedString && this.lastToken.tok != 1073741983 && (this.tokCommand == 36867 && this.nTokens == 2 && this.lastToken.tok == 545259546 || this.tokCommand == 134222849 || this.tokCommand == 1610616835 || this.tokCommand == 134222850 || this.tokCommand == 4124));
            this.iHaveQuotedString = true;
            if ((this.tokCommand == 134222849 || this.tokCommand == 135174) && this.lastToken.tok == 134221834 || this.tokCommand == 134221834 && string.indexOf("@") < 0) {
                if (!this.getData(string)) {
                    return this.ERROR(11, "data");
                }
            } else {
                this.addTokenToPrefix(T.o(4, string));
                if (this.implicitString) {
                    this.ichEnd = this.ichToken + this.cchToken;
                    this.isEndOfCommand = true;
                }
            }
            return 2;
        }
        if (this.nTokens == this.ptNewSetModifier) {
            c2 = this.script.charAt(this.ichToken);
            bl = "+-\\*/&|=".indexOf(c2) >= 0;
            n = bl || c2 == '.' || c2 == '[' ? 1 : 0;
            c = this.charAt(this.ichToken + 1);
            if (!this.isNewSet && this.isUserToken && n != 0 && (c2 == '=' || c == c2 || c == '=')) {
                this.isNewSet = true;
            }
            if (this.isNewSet || this.tokCommand == 36867 || T.tokAttr(this.tokCommand, 0x20000000)) {
                if (c2 == '=') {
                    this.setEqualPt = this.ichToken;
                }
                if (T.tokAttr(this.tokCommand, 0x20000000) && c2 == '=' || (this.isNewSet || this.isSetBrace) && n != 0) {
                    this.setCommand(bl ? T.tokenSet : (c2 == '[' && !this.isSetBrace || c2 == '.' && c == '.' ? T.tokenSetArray : T.tokenSetProperty));
                    this.ltoken.add(0, this.tokenCommand);
                    this.cchToken = 1;
                    switch (c2) {
                        case '[': {
                            this.tokLastMath = 1;
                            this.addTokenToPrefix(T.tokenArrayOpen);
                            ++this.bracketCount;
                            return 2;
                        }
                        case '.': {
                            if (c == '.') {
                                this.addTokenToPrefix(T.tokenArrayOpen);
                                this.cchToken = 2;
                                this.isDotDot = true;
                                return 2;
                            }
                            this.addTokenToPrefix(T.o(0x40000200, "."));
                            return 2;
                        }
                        case '&': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '/': 
                        case '\\': 
                        case '|': {
                            if (c == '\u0000') {
                                return this.ERROR(4);
                            }
                            if (c == c2 || c == '=') break;
                            return this.ERROR(1, "\"" + c2 + "\"");
                        }
                        default: {
                            this.lastToken = T.tokenMinus;
                            return 2;
                        }
                    }
                }
            }
        }
        switch (this.tokCommand) {
            case 134222350: {
                switch (this.lastToken.tok) {
                    case 4120: 
                    case 1073877010: 
                    case 1296041474: 
                    case 1715472409: {
                        if (this.nTokens != 2) break;
                        this.iHaveQuotedString = true;
                        break;
                    }
                    case 1073741925: 
                    case 1073742189: {
                        break;
                    }
                    default: {
                        if (this.iHaveQuotedString || this.nTokens == 2) break;
                        return 0;
                    }
                }
            }
            case 4124: 
            case 134222849: 
            case 134222850: 
            case 1275072526: {
                if (this.script.charAt(this.ichToken) == '@') {
                    this.iHaveQuotedString = true;
                    return 0;
                }
                switch (this.tokCommand) {
                    case 4124: {
                        this.haveMacro = true;
                        break;
                    }
                    case 134222849: {
                        BS bS;
                        if (this.nTokens == 1 || this.nTokens == 2 && this.tokAt(1) == 0x4000000F) {
                            bl = Viewer.isDatabaseCode(this.charAt(this.ichToken));
                            if (!this.lookingAtLoadFormat(bl)) break;
                            String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                            T t = T.getTokenFromName(string.toLowerCase());
                            switch (t == null ? 0 : t.tok) {
                                case 4130: 
                                case 36868: 
                                case 0x4000000F: 
                                case 1073742015: 
                                case 1073742077: 
                                case 1073877011: 
                                case 1610616855: {
                                    if (this.nTokens != 1) {
                                        return 4;
                                    }
                                }
                                case 134218757: 
                                case 134221834: 
                                case 0x2000000E: 
                                case 1073741849: 
                                case 1073741983: 
                                case 1094717454: 
                                case 1228935687: {
                                    this.addTokenToPrefix(t);
                                    break;
                                }
                                default: {
                                    int n2;
                                    int n3 = bl ? 4 : (n2 = PT.isOneOf(string = string.toLowerCase(), ";xyz;vxyz;vibration;temperature;occupancy;partialcharge;") ? 0x40000000 : 0);
                                    if (n2 == 0) break;
                                    this.addTokenToPrefix(T.o(n2, string));
                                    this.iHaveQuotedString = n2 == 4;
                                }
                            }
                            return 2;
                        }
                        if (this.script.charAt(this.ichToken) == '{' || this.parenCount > 0 || (bS = this.lookingAtBitset()) == null) break;
                        this.addTokenToPrefix(T.o(10, bS));
                        return 2;
                    }
                }
                if (this.iHaveQuotedString || !this.lookingAtImpliedString(this.tokCommand == 134222350, this.tokCommand == 134222849, this.nTokens > 1 || this.tokCommand != 134222850 && this.tokCommand != 4124)) break;
                String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                if (this.tokCommand == 134222850) {
                    if (string.startsWith("javascript:")) {
                        this.lookingAtImpliedString(true, true, true);
                        string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    } else if (string.toUpperCase().indexOf(".PUSH(") >= 0) {
                        this.cchToken = 0;
                        this.iHaveQuotedString = true;
                        return 2;
                    }
                }
                this.iHaveQuotedString = true;
                this.addTokenToPrefix(T.o(4, string));
                return 2;
            }
            case 4156: {
                if (this.nTokens != 1 || !this.lookForSyncID()) break;
                String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                n = PT.parseInt(string);
                if (n == Integer.MIN_VALUE || Math.abs(n) < 1000) {
                    this.addTokenToPrefix(T.o(0x40000000, string));
                } else {
                    this.addTokenToPrefix(T.i(n));
                }
                return 2;
            }
            case 134221856: {
                if (this.nTokens == 2 && this.lastToken.tok == 4115) {
                    this.iHaveQuotedString = true;
                }
                if (this.iHaveQuotedString) break;
                if (this.script.charAt(this.ichToken) == '@') {
                    this.iHaveQuotedString = true;
                    return 0;
                }
                if (!this.lookingAtImpliedString(true, true, true)) break;
                String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                n = string.indexOf(" as ");
                if (n > 0) {
                    this.cchToken = n;
                    string = string.substring(0, this.cchToken);
                }
                if (string.indexOf(" ") >= 0 || string.indexOf(".") < 0) break;
                this.addTokenToPrefix(T.o(4, string));
                this.iHaveQuotedString = true;
                return 2;
            }
        }
        this.implicitString &= this.nTokens == 1;
        if (this.implicitString && (this.tokCommand != 134222850 && this.tokCommand != 4124 || !this.iHaveQuotedString) && this.lookingAtImpliedString(true, true, true)) {
            String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            if (this.tokCommand == 1825200146 && PT.isOneOf(string.toLowerCase(), ";on;off;hide;display;")) {
                this.addTokenToPrefix(T.getTokenFromName(string.toLowerCase()));
            } else {
                this.addTokenToPrefix(T.o(4, string));
            }
            return 2;
        }
        if (this.lookingAtObjectID()) {
            this.addTokenToPrefix(T.getTokenFromName("$"));
            this.addTokenToPrefix(T.o(0x40000000, this.script.substring(this.ichToken, this.ichToken + this.cchToken)));
            return 2;
        }
        float f = this.lookingAtExponential();
        if (!Float.isNaN(f)) {
            this.addNumber(3, Integer.MAX_VALUE, Float.valueOf(f));
            return 2;
        }
        if (this.lookingAtDecimal()) {
            f = PT.fVal(this.script.substring(this.ichToken, this.ichToken + this.cchToken));
            n = ScriptParam.getFloatEncodedInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken));
            this.addNumber(3, n, Float.valueOf(f));
            return 2;
        }
        if (this.lookingAtSeqcode()) {
            c2 = this.script.charAt(this.ichToken);
            try {
                n = c2 == '*' || c2 == '^' ? Integer.MAX_VALUE : Integer.parseInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken - 2));
                c = this.script.charAt(this.ichToken + this.cchToken - 1);
                if (c == '^') {
                    c = ' ';
                }
                if (n < 0) {
                    n = -n;
                    this.addTokenToPrefix(T.tokenMinus);
                }
                int n4 = Group.getSeqcodeFor(n, c);
                this.addTokenToPrefix(T.tv(5, n4, "seqcode"));
            }
            catch (NumberFormatException numberFormatException) {
                return this.ERROR(9, "" + c2);
            }
            return 2;
        }
        n = this.lookingAtInteger();
        if (n != Integer.MAX_VALUE) {
            String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            if (this.tokCommand == 102407 || this.tokCommand == 102408) {
                ScriptFlowContext scriptFlowContext;
                ScriptFlowContext scriptFlowContext2;
                if (this.nTokens != 1) {
                    return this.ERROR(0);
                }
                if (this.flowContext == null) {
                    scriptFlowContext2 = null;
                } else {
                    n = Math.abs(n);
                    scriptFlowContext2 = scriptFlowContext = this.flowContext.getBreakableContext(n);
                }
                if (scriptFlowContext == null) {
                    return this.ERROR(1, (String)this.tokenCommand.value);
                }
                this.tokenAt((int)0).intValue = scriptFlowContext.pt0;
            }
            if (n == 0 && string.equals("-0")) {
                this.addTokenToPrefix(T.tokenMinus);
            }
            this.addNumber(2, n, string);
            return 2;
        }
        if (!this.isMathExpressionCommand && this.parenCount == 0 || this.lastToken.tok != 0x40000000 && !ScriptCompiler.tokenAttr(this.lastToken, 0x8000000)) {
            Object object;
            c = this.script.charAt(this.ichToken) == '[' ? (char)'\u0001' : '\u0000';
            BS bS = this.lookingAtBitset();
            if (bS != null) {
                this.addTokenToPrefix(T.o(10, c != '\u0000' ? BondSet.newBS(bS, null) : bS));
                return 2;
            }
            if (c != '\u0000' && (object = this.lookingAtMatrix()) instanceof M34) {
                this.addTokenToPrefix(T.o(object instanceof M4 ? 12 : 11, object));
                return 2;
            }
        }
        return 0;
    }

    private void addNumber(int n, int n2, Object object) {
        this.addTokenToPrefix(this.afterWhite == this.ichToken ? SV.newSV(n, n2, object) : T.tv(n, n2, object));
    }

    private Object lookingAtMatrix() {
        Object object;
        int n;
        if (this.ichToken + 4 >= this.cchScript || this.script.charAt(this.ichToken) != '[' || this.script.charAt(this.ichToken + 1) != '[' || (n = this.script.indexOf("]]", this.ichToken)) < 0 || (object = Escape.unescapeMatrix(this.script.substring(this.ichToken, n + 2))) == null) {
            return null;
        }
        this.cchToken = n + 2 - this.ichToken;
        return object;
    }

    private int parseKnownToken() {
        int n = this.getPrefixToken();
        if (this.isDotDot) {
            if (n == 0x10000040) {
                ++this.bracketCount;
            } else {
                this.addTokenToPrefix(T.o(4, this.ident));
                this.addTokenToPrefix(T.tokenArrayClose);
            }
            this.isDotDot = false;
            return 2;
        }
        if (this.tokLastMath != 0) {
            this.tokLastMath = n;
        }
        if (this.flowContext != null && this.flowContext.token.tok == 102410 && this.flowContext.var != null && n != 102411 && n != 102413 && this.lastToken.tok != 102410) {
            return this.ERROR(1, this.ident);
        }
        if (this.lastToken.tok == 12290 && n != 1073742332 && this.nTokens != 1) {
            this.addTokenToPrefix(n == 12290 ? this.lastToken : T.o(4, this.ident));
            return 2;
        }
        switch (n) {
            case 0x40000000: {
                if (this.nTokens != 0 || this.checkImpliedScriptCmd) break;
                if (this.ident.charAt(0) == '\'') {
                    this.addTokenToPrefix(this.setCommand(T.tokenScript));
                    this.cchToken = 0;
                    return 2;
                }
                if (this.charAt(this.ichToken + this.cchToken) != '.') break;
                this.addTokenToPrefix(this.setCommand(T.tokenScript));
                this.nTokens = 1;
                this.cchToken = 0;
                this.checkImpliedScriptCmd = true;
                return 2;
            }
            case 268435666: {
                if (this.nSemiSkip == this.forPoint3 && this.nTokens == this.ptSemi + 2) {
                    T t = this.lastToken;
                    this.addTokenToPrefix(T.tokenEquals);
                    this.addTokenToPrefix(t);
                    t = T.getTokenFromName(this.ident.substring(0, 1));
                    this.addTokenToPrefix(t);
                    this.addTokenToPrefix(T.tokenLeftParen);
                    this.needRightParen = true;
                    return 2;
                }
                this.checkNewSetCommand();
                if (this.tokCommand == 36867) {
                    this.tokenAndEquals = T.getTokenFromName(this.ident.substring(0, 1));
                    this.setEqualPt = this.ichToken;
                    return 0;
                }
                if (this.tokCommand == 554176565 || this.tokCommand == 554176526) {
                    this.addTokenToPrefix(this.tokenCommand);
                    this.replaceCommand(T.tokenSet);
                    this.tokenAndEquals = T.getTokenFromName(this.ident.substring(0, 1));
                    this.setEqualPt = this.ichToken;
                    return 0;
                }
                return 2;
            }
            case 0x100000C1: 
            case 268435650: {
                if (this.afterWhite == this.ichToken || this.afterMath == this.ichToken) {
                    this.theToken = T.tv(this.theToken.tok, -1, this.theToken.value);
                }
                if (!this.isNewSet && this.nTokens == 1) {
                    this.checkNewSetCommand();
                }
                if (this.isNewSet && this.parenCount == 0 && this.bracketCount == 0 && this.ichToken <= this.setEqualPt) {
                    this.tokenizePlusPlus(n, false);
                    return 2;
                }
                if (this.nSemiSkip != this.forPoint3 || this.nTokens != this.ptSemi + 2) break;
                T t = this.lastToken;
                this.addTokenToPrefix(T.tokenEquals);
                this.addTokenToPrefix(t);
                this.addTokenToPrefix(n == 0x100000C1 ? T.tokenMinus : T.tokenPlus);
                this.addTokenToPrefix(T.i(1));
                return 2;
            }
            case 268435860: {
                if (this.parenCount != 0 || this.bracketCount != 0) break;
                this.setEqualPt = this.ichToken;
                break;
            }
            case 0x40000200: {
                if (this.tokCommand != 36867 || this.parenCount != 0 || this.bracketCount != 0 || this.ichToken >= this.setEqualPt || this.ltoken.size() <= 1 || ((T)this.ltoken.get((int)1)).tok != 1073742332) break;
                this.ltoken.set(0, T.tokenSetProperty);
                this.ltoken.add(1, T.tokenExpressionBegin);
                this.addTokenToPrefix(T.tokenExpressionEnd);
                this.setEqualPt = 0;
                break;
            }
            case 1073742332: {
                if (++this.braceCount == 1 && this.parenCount == 0 && this.checkFlowStartBrace(false)) {
                    ScriptFlowContext scriptFlowContext;
                    this.isEndOfCommand = true;
                    ScriptFlowContext scriptFlowContext2 = scriptFlowContext = this.flowContext != null && this.flowContext.addLine == 0 || this.forceFlowContext == null ? this.flowContext : this.forceFlowContext;
                    if (scriptFlowContext != null) {
                        scriptFlowContext.addLine = 0;
                        scriptFlowContext.forceEndIf = false;
                        this.lastToken = T.tokenLeftBrace;
                        this.forceFlowContext = scriptFlowContext;
                    }
                    return 2;
                }
                ++this.parenCount;
                break;
            }
            case 0x10000010: {
                ++this.parenCount;
                if (this.nTokens <= 1 || this.lastToken.tok != 1275082245 && this.lastToken.tok != 134320648 && this.lastToken.tok != 134320649) break;
                this.nSemiSkip += 2;
                break;
            }
            case 0x40000202: {
                if (this.iBrace > 0 && this.parenCount == 0 && this.braceCount == 0) {
                    this.ichBrace = this.ichToken;
                    if (this.nTokens == 0) {
                        this.parenCount = 1;
                        this.braceCount = 1;
                    } else {
                        if (!this.wasImpliedScript()) {
                            this.nSemiSkip = 0;
                            this.parenCount = 0;
                            this.braceCount = 0;
                            this.addBrace(this.theToken);
                            this.isEndOfCommand = true;
                            this.ichEnd = this.ichToken;
                        }
                        return 2;
                    }
                }
                --this.braceCount;
            }
            case 0x10000011: {
                if (--this.parenCount < 0) {
                    return this.ERROR(16, this.ident);
                }
                if (this.parenCount == 0) {
                    this.nSemiSkip = 0;
                }
                if (!this.needRightParen) break;
                this.addTokenToPrefix(T.tokenRightParen);
                this.needRightParen = false;
                break;
            }
            case 0x10000040: {
                if (this.ichToken > 0 && PT.isWhitespace(this.script.charAt(this.ichToken - 1))) {
                    this.addTokenToPrefix(T.tokenSpaceBeforeSquare);
                }
                ++this.bracketCount;
                break;
            }
            case 0x10000041: {
                --this.bracketCount;
                if (this.bracketCount >= 0) break;
                return this.ERROR(16, "]");
            }
            case 1073742337: {
                this.isDotDot = true;
                this.addTokenToPrefix(T.tokenArrayOpen);
                return 2;
            }
        }
        switch (this.lastToken.tok) {
            case 0x10000030: 
            case 0x10000040: 
            case 0x40000200: 
            case 1073742337: {
                return 0;
            }
        }
        switch (n) {
            case 102409: {
                if (this.tokCommand == 135174 || this.tokCommand == 4103 && this.nTokens == 1) {
                    return 0;
                }
                if (!this.haveENDIF) {
                    return 5;
                }
            }
            case 364548: {
                if (this.flowContext != null) {
                    this.flowContext.forceEndIf = false;
                }
            }
            case 364547: {
                if (this.nTokens <= 0) break;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 102402: 
            case 102406: 
            case 102410: 
            case 102411: 
            case 102412: 
            case 102413: 
            case 134320648: 
            case 134320649: {
                if (this.nTokens <= 1 || this.tokCommand == 36867 || this.nSemiSkip != 0) break;
                this.isEndOfCommand = true;
                if (this.flowContext != null) {
                    this.flowContext.forceEndIf = true;
                }
                this.cchToken = 0;
                return 2;
            }
        }
        return 0;
    }

    private void tokenizePlusPlus(int n, boolean bl) {
        if (bl) {
            this.setCommand(T.tokenSet);
            if (this.nTokens == 1) {
                this.ltoken.add(0, this.tokenCommand);
            }
        }
        this.nTokens = this.ltoken.size();
        this.addTokenToPrefix(T.tokenEquals);
        this.setEqualPt = 0;
        for (int i = 1; i < this.nTokens; ++i) {
            this.addTokenToPrefix((T)this.ltoken.get(i));
        }
        this.addTokenToPrefix(n == 0x100000C1 ? T.tokenMinus : T.tokenPlus);
        this.addTokenToPrefix(T.i(1));
    }

    private boolean checkNewSetCommand() {
        String string = ((T)this.ltoken.get((int)0)).value.toString();
        if (!this.isContextVariable(string.toLowerCase())) {
            return false;
        }
        T t = this.setNewSetCommand(false, string);
        this.setCommand(T.tokenSet);
        this.ltoken.add(0, this.tokenCommand);
        this.ltoken.set(1, t);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private int parseCommandParameter(short var1_1, boolean var2_2) {
        this.nTokens = this.ltoken.size();
        block0 : switch (this.tokCommand) {
            case 0: {
                this.lastToken = T.tokenOff;
                this.ichCurrentCommand = this.ichEnd = this.ichToken;
                this.setCommand(this.theToken);
                if (this.logMessages) {
                    Logger.info("compiling " + this.theToken);
                }
                if (var3_3 = T.tokAttr(this.tokCommand, 102400)) {
                    this.lastFlowCommand = this.tokenCommand;
                }
                if ((var4_4 = this.checkFlowEndBrace()) == 4) {
                    return 4;
                }
                if (var4_4 == 2) {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
                switch (this.theTok) {
                    case 1073742332: {
                        break;
                    }
                    case 0x10000022: {
                        ++this.braceCount;
                        this.isEndOfCommand = true;
                        return 0;
                    }
                    case 102409: {
                        return 0;
                    }
                    case 102402: 
                    case 364547: {
                        this.fixFlowAddLine(this.flowContext);
                        if (((T[])this.lltoken.get((int)(this.iCommand - 1)))[0].tok != 102409 || this.forceFlowContext == null || !this.forceFlowContext.forceEndIf || this.forceFlowContext.addLine <= 0 || !this.isFlowIfContextOK(this.forceFlowContext)) ** GOTO lbl35
                        this.flowContext = this.forceFlowContext;
                        this.flowContext.forceEndIf = true;
                        this.lltoken.remove(--this.iCommand);
                        ** GOTO lbl46
lbl35:
                        // 1 sources

                        if (this.flowContext != null && this.flowContext.addLine > 0) {
                            while (this.flowContext != null && !this.isFlowIfContextOK(this.flowContext) && this.flowContext.checkForceEndIf(0)) {
                                this.forceFlowEnd(this.flowContext.token);
                                this.processTokenList(var1_1, var2_2);
                                this.fixFlowAddLine(this.flowContext);
                                this.setCommand(this.theToken);
                                this.theTok = this.theToken.tok;
                            }
                        }
                    }
lbl46:
                    // 5 sources

                    default: {
                        if (var3_3) {
                            switch (this.checkFlowCommand((String)this.tokenCommand.value)) {
                                case 4: {
                                    return 4;
                                }
                                case 2: {
                                    return 2;
                                }
                                case 5: {
                                    return 5;
                                }
                                case 0: {
                                    this.theToken = this.tokenCommand;
                                    if (this.theTok == 102411) {
                                        this.addTokenToPrefix(this.tokenCommand);
                                        this.theToken = T.tokenLeftParen;
                                    }
                                    return 0;
                                }
                            }
                        }
                        if (this.flowContext != null && !this.haveENDIF && this.flowContext.addLine > 0) {
                            this.fixFlowAddLine(this.flowContext);
                            while (this.flowContext != null && this.flowContext.checkForceEndIf(0)) {
                                this.forceFlowEnd(this.flowContext.token);
                                this.processTokenList(var1_1, var2_2);
                                this.setCommand(this.theToken);
                                this.theTok = this.theToken.tok;
                            }
                        }
                        if (this.theTok == 0x40000202) {
                            this.forceFlowContext = null;
                            this.addBrace(this.tokenCommand);
                            this.tokCommand = 0;
                            return 2;
                        }
                        this.lastFlowCommand = null;
                    }
                }
                if (this.theTok == 0x10000060) {
                    this.theToken = T.o(4143, "resume");
                    this.setCommand(this.theToken);
                    this.addTokenToPrefix(this.theToken);
                    this.theToken = T.o(14, "context");
                    return 0;
                }
                if (T.tokAttr(this.tokCommand, 4096)) break;
                v0 = this.isSetBrace = this.theTok == 1073742332;
                if (this.isSetBrace) {
                    if (!this.lookingAtSetBraceSyntax()) {
                        this.isEndOfCommand = true;
                        if (this.flowContext != null) {
                            this.flowContext.forceEndIf = false;
                        }
                    }
                } else {
                    switch (this.theTok) {
                        case 0x100000C1: 
                        case 268435650: {
                            this.tokInitialPlusPlus = this.theTok;
                            this.tokCommand = 0;
                            return 2;
                        }
                        case 12290: 
                        case 36868: 
                        case 0x10000010: 
                        case 0x40000000: {
                            break;
                        }
                        default: {
                            if (T.tokAttr(this.theTok, 0x40000000) || T.tokAttr(this.theTok, 0x20000000) || this.isContextVariable(this.identLC)) break;
                            this.commandExpected();
                            return 4;
                        }
                    }
                }
                this.theToken = this.setNewSetCommand(this.isSetBrace, this.ident);
                break;
            }
            case 102412: {
                switch (this.nTokens) {
                    case 1: {
                        if (this.theTok == 0x10000010) break block0;
                        return this.ERROR(15, "(");
                    }
                    case 2: {
                        if (this.theTok != 0x10000011) {
                            ((ContextToken)this.tokenCommand).name0 = this.ident;
                        }
                        this.newContextVariable(this.ident);
                        break block0;
                    }
                    case 3: {
                        if (this.theTok != 0x10000011) {
                            return this.ERROR(15, ")");
                        }
                        this.isEndOfCommand = true;
                        this.ichEnd = this.ichToken + 1;
                        this.flowContext.setLine();
                        break block0;
                    }
                }
                return this.ERROR(0);
            }
            case 102436: 
            case 134320141: {
                if (this.tokenCommand.intValue == 0) {
                    if (this.nTokens != 1) break;
                    this.tokenCommand.value = this.ident;
                    return 2;
                }
                if (this.nTokens == 1) {
                    if (this.thisFunction != null) {
                        this.vFunctionStack.add(0, this.thisFunction);
                    }
                    this.thisFunction = this.tokCommand == 102436 ? (ScriptFunction)Interface.getInterface("org.jmol.script.ScriptParallelProcessor", null, null) : new ScriptFunction(this.ident, this.tokCommand);
                    this.thisFunction.set(this.ident, this.tokCommand);
                    this.htUserFunctions.put(this.ident, Boolean.TRUE);
                    this.flowContext.setFunction(this.thisFunction);
                    break;
                }
                if (this.nTokens == 2) {
                    if (this.theTok == 0x10000010) break;
                    return this.ERROR(15, "(");
                }
                if (this.nTokens == 3 && this.theTok == 0x10000011) break;
                if (this.nTokens % 2 == 0) {
                    if (this.theTok == 0x10000030 || this.theTok == 0x10000011) break;
                    return this.ERROR(15, ")");
                }
                this.thisFunction.addVariable(this.ident, true);
                break;
            }
            case 102411: {
                if (this.nTokens <= 1 || this.parenCount != 0 || this.braceCount != 0 || this.theTok != 0x10000022) break;
                this.addTokenToPrefix(T.tokenRightParen);
                this.braceCount = 1;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 102413: {
                if (this.nTokens <= 1) break;
                this.braceCount = 1;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 364547: {
                if (this.nTokens == 1 && this.theTok != 134320649) {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
                if (this.nTokens != 1 || this.theTok != 134320649 && this.theTok != 1073742332) {
                    return this.ERROR(0);
                }
                this.flowContext.token = ContextToken.newCmd(102402, "elseif");
                this.replaceCommand(this.flowContext.token);
                this.tokCommand = 102402;
                return 2;
            }
            case 102409: {
                if (this.nTokens != 1) {
                    return this.ERROR(0);
                }
                if (!this.checkFlowEnd(this.theTok, this.ident, this.ichCurrentCommand, true)) {
                    return 4;
                }
                if (this.theTok != 134320141 && this.theTok != 102436) break;
                return 2;
            }
            case 134320648: {
                if (this.nTokens == 1) {
                    if (this.theTok != 0x10000010) {
                        return this.ERROR(19, this.ident);
                    }
                    this.nSemiSkip = 0;
                    this.forPoint3 = 0;
                    this.nSemiSkip += 2;
                    break;
                }
                if (this.nTokens == 3 && this.tokAt(2) == 36868) {
                    this.newContextVariable(this.ident);
                    break;
                }
                if ((this.nTokens == 3 || this.nTokens == 4) && this.theTok == 1275068432) {
                    this.nSemiSkip -= 2;
                    this.forPoint3 = 2;
                    this.addTokenToPrefix(this.theToken);
                    this.theToken = T.tokenLeftParen;
                    break;
                }
            }
            case 102402: 
            case 102406: 
            case 102410: 
            case 134320649: {
                if (this.nTokens <= 2 || this.braceCount != 0 || this.parenCount != 0) break;
            }
            case 102439: {
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 36868: {
                if (this.nTokens == 1) {
                    this.replaceCommand(T.tokenSetVar);
                    this.newContextVariable(this.ident);
                    break;
                }
                if (this.ident.equals(",")) {
                    return 2;
                }
                if (!PT.isLetter(this.ident.charAt(0))) {
                    if (this.nTokens != 2 || this.ident.equals("[")) {
                        return this.ERROR(0);
                    }
                    this.replaceCommand(T.tokenSet);
                } else {
                    this.newContextVariable(this.ident);
                    break;
                }
            }
            case 36867: {
                if (this.theTok == 1073742332) {
                    ++this.setBraceCount;
                } else if (this.theTok == 0x40000202) {
                    --this.setBraceCount;
                    if (this.isSetBrace && this.setBraceCount == 0 && this.ptNewSetModifier == 0x7FFFFFFF) {
                        this.ptNewSetModifier = this.nTokens + 1;
                    }
                }
                if (this.nTokens != this.ptNewSetModifier) break;
                var5_5 = this.tokenAt(0);
                if (this.theTok == 0x10000010 || this.isUserFunction(var5_5.value.toString())) {
                    this.ltoken.set(0, this.setCommand(T.tv(0x40000000, 0, var5_5.value)));
                    this.setBraceCount = 0;
                    break;
                }
                if (this.theTok != 0x40000000 && this.theTok != 268435666 && this.theTok != 12290 && !T.tokAttr(this.theTok, 0x20000000)) {
                    if (this.isNewSet) {
                        this.commandExpected();
                    } else {
                        this.errorIntStr2(18, "SET", ": " + this.ident);
                    }
                    return 4;
                }
                if (this.nTokens != 1 || this.lastToken.tok != 268435650 && this.lastToken.tok != 0x100000C1) break;
                this.replaceCommand(T.tokenSet);
                this.addTokenToPrefix(this.lastToken);
                break;
            }
            case 134222849: {
                if (this.theTok == 12290 && (this.nTokens == 1 || this.lastToken.tok == 0x40000074 || this.lastToken.tok == 1073742152)) {
                    this.addTokenToPrefix(T.tokenDefineString);
                    return 2;
                }
                if (this.theTok != 1073741848) break;
                this.iHaveQuotedString = false;
                break;
            }
            case 12290: {
                if (this.nTokens == 1) {
                    if (this.theTok != 0x40000000) {
                        if (this.preDefining) {
                            if (!T.tokAttr(this.theTok, 0x200000)) {
                                this.errorStr2("ERROR IN Token.java or JmolConstants.java -- the following term was used in JmolConstants.java but not listed as predefinedset in Token.java: " + this.ident, null);
                                return 4;
                            }
                        } else if (T.tokAttr(this.theTok, 0x200000)) {
                            Logger.warn("WARNING: predefined term '" + this.ident + "' has been redefined by the user until the next file load.");
                        } else if (!this.isCheckOnly && this.ident.length() > 1) {
                            Logger.warn("WARNING: redefining " + this.ident + "; was " + this.theToken + "not all commands may continue to be functional for the life of the applet!");
                            this.theToken.tok = 0x40000000;
                            this.theTok = 0x40000000;
                            T.addToken(this.ident, this.theToken);
                        }
                    }
                    this.addTokenToPrefix(this.theToken);
                    this.lastToken = T.tokenComma;
                    return 2;
                }
                if (this.nTokens != 2 || this.theTok != 268435860) break;
                this.ltoken.add(0, T.tokenSet);
                return 2;
            }
            case 135180: 
            case 135188: 
            case 135190: {
                var5_6 = this.charAt(this.ichToken + this.cchToken);
                if (this.parenCount != 0 || this.bracketCount != 0 || ".:/\\+-!?".indexOf(var5_6) < 0 || var5_6 == '-' && this.ident.equals("=")) break;
                this.checkUnquotedFileName();
            }
        }
        return 0;
    }

    private T setNewSetCommand(boolean bl, String string) {
        this.tokCommand = 36867;
        this.isNewSet = !bl && !this.isUserFunction(string);
        this.setBraceCount = bl ? 1 : 0;
        this.bracketCount = 0;
        this.setEqualPt = Integer.MAX_VALUE;
        this.ptNewSetModifier = this.isNewSet ? (string.equals("(") ? 2 : 1) : Integer.MAX_VALUE;
        return bl || this.theToken.tok == 0x10000010 || this.theToken.tok == 0x20000006 || this.theToken.tok == 268435650 || this.theToken.tok == 0x100000C1 ? this.theToken : T.o(0x40000000, string);
    }

    private void checkUnquotedFileName() {
        char c;
        int n = this.ichToken;
        while (++n < this.cchScript && !PT.isWhitespace(c = this.script.charAt(n)) && c != '#' && c != ';' && c != '}') {
        }
        String string = this.script.substring(this.ichToken, n).replace('\\', '/');
        this.cchToken = n - this.ichToken;
        this.theToken = T.o(4, string);
    }

    private boolean checkFlowStartBrace(boolean bl) {
        int n = this.tokCommand;
        switch (n) {
            default: {
                if (!T.tokAttr(n, 102400)) break;
                if (bl) {
                    switch (n) {
                        case 102411: 
                        case 102413: {
                            break;
                        }
                        default: {
                            this.flowContext.addLine = 0;
                            this.addBrace(this.tokenCommand);
                            this.lastFlowCommand = null;
                        }
                    }
                    this.braceCount = 0;
                    this.parenCount = 0;
                }
                return true;
            }
            case 102407: 
            case 102408: 
        }
        return false;
    }

    private int checkFlowEndBrace() {
        if (this.iBrace <= 0 || ((T)this.vBraces.get((int)(this.iBrace - 1))).tok != 0x40000202) {
            return 0;
        }
        this.vBraces.remove(--this.iBrace);
        T t = (T)this.vBraces.remove(--this.iBrace);
        if (this.theTok == 1073742332) {
            --this.braceCount;
            --this.parenCount;
        }
        if (t.tok == 1275335685) {
            this.vPush.remove(--this.pushCount);
            this.addTokenToPrefix(this.setCommand(ContextToken.newContext(false)));
            this.isEndOfCommand = true;
            return 2;
        }
        switch (this.flowContext == null ? 0 : this.flowContext.token.tok) {
            case 102402: 
            case 364547: 
            case 134320649: {
                if (this.tokCommand != 364547 && this.tokCommand != 102402) break;
                return 0;
            }
            case 102410: 
            case 102411: 
            case 102413: {
                if (this.tokCommand != 102411 && this.tokCommand != 102413) break;
                return 0;
            }
        }
        return this.forceFlowEnd(t);
    }

    private int forceFlowEnd(T t) {
        T t2 = this.tokenCommand;
        this.forceFlowContext = this.flowContext;
        t = this.flowStart(t);
        if (!this.checkFlowEnd(t.tok, (String)t.value, this.ichBrace, false)) {
            return 4;
        }
        switch (t.tok) {
            case 102436: 
            case 364558: 
            case 134320141: {
                break;
            }
            default: {
                this.addTokenToPrefix(t);
            }
        }
        this.setCommand(t2);
        return 2;
    }

    private T flowStart(T t) {
        switch (t.tok) {
            case 102402: 
            case 364547: 
            case 134320649: {
                return T.tokenIf;
            }
            case 102411: 
            case 102413: {
                return T.tokenSwitch;
            }
        }
        return T.getTokenFromName((String)t.value);
    }

    static boolean isBreakableContext(int n) {
        return n == 134320648 || n == 102439 || n == 102406 || n == 102411 || n == 102413;
    }

    private int checkFlowCommand(String string) {
        int n = this.lltoken.size();
        switch (this.tokCommand) {
            case 364548: {
                if (!this.isFlowIfContextOK(this.flowContext)) {
                    if (!this.haveENDIF) {
                        return 5;
                    }
                    this.errorStr(1, string);
                    return 4;
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n, false);
                this.setFlowEnd(this.tokCommand, string);
                this.flowContext = this.flowContext.parent;
                return 0;
            }
            case 102407: 
            case 102408: {
                ScriptFlowContext scriptFlowContext;
                ScriptFlowContext scriptFlowContext2 = scriptFlowContext = this.flowContext == null ? null : this.flowContext.getBreakableContext(0);
                if (this.tokCommand == 102408) {
                    while (scriptFlowContext != null && scriptFlowContext.token.tok != 134320648 && scriptFlowContext.token.tok != 102406) {
                        scriptFlowContext = scriptFlowContext.parent;
                    }
                }
                if (scriptFlowContext == null) {
                    this.errorStr(1, string);
                    return 4;
                }
                this.setCommand(T.tv(this.tokCommand, scriptFlowContext.pt0, string));
                this.theToken = this.tokenCommand;
                return 1;
            }
            case 102436: 
            case 134320141: {
                if (this.flowContext == null) break;
                this.errorStr(1, T.nameOf(this.tokCommand));
                return 4;
            }
            case 102406: 
            case 102410: 
            case 102412: 
            case 102439: 
            case 364558: 
            case 134320648: 
            case 134320649: {
                break;
            }
            case 102402: 
            case 364547: {
                if (this.flowContext != null && !this.isFlowIfContextOK(this.flowContext)) {
                    this.flowContext = this.flowContext.parent;
                }
                if (!this.isFlowIfContextOK(this.flowContext)) {
                    if (!this.haveENDIF) {
                        return 5;
                    }
                    this.errorStr(1, string);
                    return 4;
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n, false);
                break;
            }
            case 102411: 
            case 102413: {
                if (this.flowContext == null || this.flowContext.token.tok != 102410 && this.flowContext.token.tok != 102411 && (this.tokCommand == 102413 ? this.flowContext.ptDefault > 0 : this.flowContext.token.tok != 102413)) {
                    this.errorStr(1, string);
                    return 4;
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n, this.tokCommand == 102413);
            }
        }
        ContextToken contextToken = ContextToken.newCmd(this.tokCommand, this.tokenCommand.value);
        if (this.tokCommand == 102410) {
            contextToken.addName("_var");
        }
        this.setCommand(contextToken);
        switch (this.tokCommand) {
            case 364558: {
                this.flowContext = new ScriptFlowContext(this, contextToken, n, this.flowContext, this.ichCurrentCommand, this.lineCurrent);
                if (this.thisFunction != null) {
                    this.vFunctionStack.add(0, this.thisFunction);
                }
                this.thisFunction = new ScriptFunction("", 364558);
                this.flowContext.setFunction(this.thisFunction);
                this.pushContext(contextToken);
                break;
            }
            case 102411: 
            case 102413: {
                contextToken.contextVariables = this.flowContext.token.contextVariables;
            }
            case 102402: 
            case 364547: {
                this.flowContext.token = contextToken;
                break;
            }
            case 102406: 
            case 102412: 
            case 102439: 
            case 134320648: {
                this.pushContext(contextToken);
            }
            default: {
                this.flowContext = new ScriptFlowContext(this, contextToken, n, this.flowContext, this.ichCurrentCommand, this.lineCurrent);
            }
        }
        return 0;
    }

    private void setFlowEnd(int n, String string) {
        this.setCommand(T.tv(n, this.flowContext.ptDefault > 0 ? this.flowContext.ptDefault : -this.flowContext.pt0, string));
    }

    private boolean isFlowIfContextOK(ScriptFlowContext scriptFlowContext) {
        switch (scriptFlowContext == null ? 0 : scriptFlowContext.token.tok) {
            case 102402: 
            case 134320649: {
                return true;
            }
            case 364547: {
                return this.tokCommand != 364547;
            }
        }
        return false;
    }

    private boolean checkFlowEnd(int n, String string, int n2, boolean bl) {
        if (bl) {
            if (this.flowContext == null) {
                return this.errorStr(1, "end " + string);
            }
            this.flowContext.addLine = 0;
            this.flowContext.forceEndIf = false;
            switch (this.flowContext.token.tok) {
                case 102436: 
                case 364558: 
                case 134320141: {
                    break;
                }
                default: {
                    this.setFlowEnd(102409, "end");
                    this.ltoken.set(0, this.tokenCommand);
                    break;
                }
            }
        } else {
            this.setFlowEnd(102409, "end");
            this.addTokenToPrefix(this.tokenCommand);
        }
        if (this.flowContext == null || n != this.flowContext.tok0) {
            return this.errorStr(1, "end " + string);
        }
        int n3 = this.lltoken.size();
        this.flowContext.token.intValue = this.tokCommand == 102412 ? -n3 : n3;
        switch (n) {
            case 102410: 
            case 134320649: {
                break;
            }
            case 102406: 
            case 102412: 
            case 102439: 
            case 134320648: {
                if (bl) break;
                this.vPush.remove(--this.pushCount);
                break;
            }
            case 102436: 
            case 364558: 
            case 134320141: {
                if (!this.isCheckOnly) {
                    this.addTokenToPrefix(T.o(n, this.thisFunction));
                    ScriptFunction.setFunction(this.thisFunction, this.script, n2, this.lltoken.size(), this.lineNumbers, this.lineIndices, this.lltoken);
                }
                this.thisFunction = this.vFunctionStack.size() == 0 ? null : (ScriptFunction)this.vFunctionStack.remove(0);
                this.tokenCommand.intValue = 0;
                if (n != 364558) break;
                this.vPush.remove(--this.pushCount);
                break;
            }
            default: {
                return this.errorStr(19, "end " + string);
            }
        }
        this.flowContext = this.flowContext.parent;
        this.fixFlowAddLine(this.flowContext);
        return true;
    }

    private void fixFlowAddLine(ScriptFlowContext scriptFlowContext) {
        while (scriptFlowContext != null) {
            if (scriptFlowContext.addLine > 0 || scriptFlowContext.forceEndIf) {
                scriptFlowContext.addLine = this.lineCurrent - scriptFlowContext.ptLine;
                scriptFlowContext.forceEndIf = true;
            }
            scriptFlowContext = scriptFlowContext.parent;
        }
    }

    private boolean getData(String string) {
        int n;
        this.addTokenToPrefix(T.o(4, string));
        this.ichToken += string.length() + 2;
        if (this.charAt(this.ichToken) == '\r') {
            this.lineCurrent = (short)(this.lineCurrent + 1);
            ++this.ichToken;
        }
        if (this.charAt(this.ichToken) == '\n') {
            this.lineCurrent = (short)(this.lineCurrent + 1);
            ++this.ichToken;
        }
        if ((n = this.script.indexOf(this.chFirst + string + this.chFirst, this.ichToken) - 4) < 0 || !this.script.substring(n, n + 4).equalsIgnoreCase("END ")) {
            return false;
        }
        String string2 = this.script.substring(this.ichToken, n);
        this.incrementLineCount(string2);
        this.addTokenToPrefix(T.o(134221834, string2));
        this.addTokenToPrefix(T.o(0x40000000, "end"));
        this.addTokenToPrefix(T.o(4, string));
        this.cchToken = n - this.ichToken + string.length() + 6;
        return true;
    }

    private int incrementLineCount(String string) {
        int n = string.indexOf(13);
        int n2 = string.indexOf(10);
        if (n < 0 && n2 < 0) {
            return 0;
        }
        short s = this.lineCurrent;
        if (n < 0 || n2 < n) {
            n = n2;
        }
        int n3 = string.length();
        while (--n3 >= n) {
            char c = string.charAt(n3);
            if (c != '\n' && c != '\r') continue;
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        return this.lineCurrent - s;
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private boolean eol(char c) {
        return c == '\u0000' || c == '\r' || c == '\n' || c == ';' && this.nSemiSkip <= 0;
    }

    private boolean lookingAtSetBraceSyntax() {
        int n = this.ichToken;
        int n2 = 1;
        while (++n < this.cchScript && n2 > 0) {
            switch (this.script.charAt(n)) {
                case '{': {
                    ++n2;
                    break;
                }
                case '}': {
                    --n2;
                }
            }
        }
        if (this.charAt(n) == '[' && ++n2 == 1) {
            while (++n < this.cchScript && n2 > 0) {
                switch (this.script.charAt(n)) {
                    case '[': {
                        ++n2;
                        break;
                    }
                    case ']': {
                        if (this.charAt(n + 1) == '[') {
                            ++n;
                            break;
                        }
                        --n2;
                    }
                }
            }
        }
        return this.charAt(n) == '.' && n2 == 0;
    }

    private boolean lookingAtString(boolean bl) {
        char c;
        if (this.ichToken + 2 > this.cchScript) {
            return false;
        }
        this.chFirst = this.script.charAt(this.ichToken);
        if (!(this.chFirst == '\"' || bl && this.chFirst == '\'')) {
            return false;
        }
        int n = this.ichToken;
        boolean bl2 = false;
        while (++n < this.cchScript && ((c = this.script.charAt(n)) != this.chFirst || bl2)) {
            bl2 = c == '\\' ? !bl2 : false;
        }
        if (n == this.cchScript) {
            this.cchToken = -1;
            this.ichEnd = this.cchScript;
        } else {
            this.cchToken = ++n - this.ichToken;
        }
        return true;
    }

    private String getUnescapedStringLiteral(boolean bl) {
        Object object;
        if (bl) {
            object = this.script.substring(this.ichToken + 1, this.ichToken + this.cchToken - 1);
            if (((String)object).indexOf("\\u") >= 0) {
                object = Escape.unescapeUnicode((String)object);
            }
            if (((String)object).indexOf(";base64,") != 0) {
                return object;
            }
        }
        object = SB.newN(this.cchToken - 2);
        int n = this.ichToken + this.cchToken - 1;
        int n2 = this.ichToken + 1;
        while (n2 < n) {
            int n3;
            if ((n3 = this.script.charAt(n2++)) == 92 && n2 < n) {
                n3 = this.script.charAt(n2++);
                switch (n3) {
                    case 110: {
                        n3 = 10;
                        break;
                    }
                    case 116: {
                        n3 = 9;
                        break;
                    }
                    case 114: {
                        n3 = 13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 117: 
                    case 120: {
                        char c;
                        int n4;
                        int n5;
                        int n6 = n5 = n3 == 120 ? 2 : 4;
                        if (n2 >= n) break;
                        int n7 = 0;
                        int n8 = n5;
                        while (--n8 >= 0 && n2 < n && (n4 = Escape.getHexitValue(c = this.script.charAt(n2))) >= 0) {
                            n7 <<= 4;
                            n7 += n4;
                            ++n2;
                        }
                        n3 = (char)n7;
                    }
                }
            }
            ((SB)object).appendC((char)n3);
        }
        return ((SB)object).toString();
    }

    private boolean lookingAtLoadFormat(boolean bl) {
        char c;
        int n = this.ichToken;
        while (PT.isLetterOrDigit(c = this.charAt(n)) && (bl || PT.isLetter(c)) || bl && !this.eol(c) && !PT.isWhitespace(c)) {
            ++n;
        }
        if (!bl && n == this.ichToken || !ScriptCompiler.isSpaceOrTab(c)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtImpliedString(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        int n = this.ichToken;
        char c = this.script.charAt(n);
        boolean bl5 = this.lastToken.tok == 1073741974;
        boolean bl6 = T.tokAttr(this.tokCommand, 20480) && (this.tokCommand & 1) == 1;
        boolean bl7 = c == '@';
        boolean bl8 = bl4 = bl7 && n + 3 < this.cchScript && this.script.charAt(n + 1) == '{';
        if (bl4 && (bl5 || !bl6)) {
            return false;
        }
        int n2 = -1;
        int n3 = -1;
        boolean bl9 = true;
        int n4 = 0;
        block6: while (bl9 && !this.eol(c = this.charAt(n))) {
            switch (c) {
                case '(': {
                    if (bl3 || this.tokCommand != 4124 && (n < 5 || !this.script.substring(n - 4, n).equals(".spt") && !this.script.substring(n - 4, n).equals(".png") && !this.script.substring(n - 5, n).equals(".pngj"))) break;
                    bl9 = false;
                    continue block6;
                }
                case '=': {
                    if (bl2) break;
                    bl9 = false;
                    continue block6;
                }
                case '{': {
                    ++n4;
                    break;
                }
                case '}': {
                    if (--n4 < 0 && (this.braceCount > 0 || this.iBrace > 0)) {
                        bl9 = false;
                        continue block6;
                    }
                }
                default: {
                    if (PT.isWhitespace(c)) {
                        if (n2 >= 0) break;
                        n2 = n;
                        break;
                    }
                    n3 = n;
                }
            }
            ++n;
        }
        if (bl) {
            n = n3 + 1;
        } else if (n2 > 0) {
            n = n2;
        }
        if (bl7 && (!bl || n2 < 0 && n4 <= 0 && n - this.ichToken > 1)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return this.cchToken > 0;
    }

    private float lookingAtExponential() {
        int n;
        if (this.ichToken == this.cchScript) {
            return Float.NaN;
        }
        int n2 = n = this.ichToken;
        if (this.script.charAt(n) == '-') {
            ++n;
        }
        boolean bl = false;
        int n3 = 88;
        while (true) {
            char c = this.charAt(n);
            n3 = c;
            if (!PT.isDigit(c)) break;
            ++n;
            bl = true;
        }
        if (n < this.cchScript && n3 == 46) {
            ++n;
        }
        while (true) {
            char c = this.charAt(n);
            n3 = c;
            if (!PT.isDigit(c)) break;
            ++n;
            bl = true;
        }
        if (n == this.cchScript || !bl) {
            return Float.NaN;
        }
        boolean bl2 = bl = n3 != 69 && n3 != 101;
        if (bl || ++n == this.cchScript) {
            return Float.NaN;
        }
        n3 = this.script.charAt(n);
        if (n3 == 45 || n3 == 43) {
            ++n;
        }
        while (PT.isDigit(this.charAt(n))) {
            ++n;
            bl = true;
        }
        if (!bl) {
            return Float.NaN;
        }
        this.cchToken = n - this.ichToken;
        return (float)PT.dVal(this.script.substring(n2, n));
    }

    private boolean lookingAtDecimal() {
        char c;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        if (this.script.charAt(n) == '-') {
            // empty if block
        }
        boolean bl = false;
        while (true) {
            int n2 = ++n;
            ++n;
            c = this.charAt(n2);
            if (!PT.isDigit(c)) break;
            bl = true;
        }
        if (c != '.') {
            return false;
        }
        char c2 = this.charAt(n);
        if (!this.eol(c2)) {
            if (PT.isLetter(c2) || c2 == '?' || c2 == '*' || c2 == '_') {
                return false;
            }
            c2 = this.charAt(n + 1);
            if (PT.isLetter(c2) || c2 == '?') {
                return false;
            }
        }
        while (PT.isDigit(this.charAt(n))) {
            ++n;
            bl = true;
        }
        this.cchToken = n - this.ichToken;
        return bl;
    }

    private boolean lookingAtSeqcode() {
        char c;
        int n = this.ichToken;
        if (this.charAt(n + 1) == '^' && this.script.charAt(n) == '*') {
            c = '^';
            ++n;
        } else {
            if (this.script.charAt(n) == '-') {
                ++n;
            }
            while (true) {
                char c2 = this.charAt(n);
                c = c2;
                if (!PT.isDigit(c2)) break;
                ++n;
            }
        }
        if (c != '^') {
            return false;
        }
        if ((c = ++n == this.cchScript ? (char)' ' : (char)this.script.charAt(n++)) != ' ' && c != '*' && c != '?' && !PT.isLetter(c)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private int lookingAtInteger() {
        if (this.ichToken == this.cchScript) {
            return Integer.MAX_VALUE;
        }
        int n = this.ichToken;
        if (this.script.charAt(this.ichToken) == '-') {
            ++n;
        }
        int n2 = n;
        while (PT.isDigit(this.charAt(n))) {
            ++n;
        }
        if (n2 == n) {
            return Integer.MAX_VALUE;
        }
        this.cchToken = n - this.ichToken;
        try {
            this.ident = this.script.substring(this.ichToken, n);
            int n3 = Integer.parseInt(this.ident);
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    BS lookingAtBitset() {
        int n;
        if (this.script.indexOf("({null})", this.ichToken) == this.ichToken) {
            this.cchToken = 8;
            return new BS();
        }
        if (this.ichToken + 4 > this.cchScript || this.script.charAt(this.ichToken + 1) != '{' || (n = this.script.indexOf("}", this.ichToken)) < 0 || n + 1 == this.cchScript) {
            return null;
        }
        BS bS = BS.unescape(this.script.substring(this.ichToken, n + 2));
        if (bS != null) {
            this.cchToken = n + 2 - this.ichToken;
        }
        return bS;
    }

    private boolean lookingAtObjectID() {
        boolean bl = this.nTokens == 1;
        int n = this.ichToken;
        if (this.charAt(n) != '$') {
            return false;
        }
        if (this.charAt(++n) == '\"') {
            return false;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            if (PT.isWhitespace(c)) {
                if (n != this.ichToken + 1) break;
                return false;
            }
            if (!PT.isLetterOrDigit(c)) {
                switch (c) {
                    default: {
                        return false;
                    }
                    case '*': {
                        if (bl) break;
                        return false;
                    }
                    case '_': 
                    case '~': 
                }
            }
            ++n;
        }
        this.cchToken = n - ++this.ichToken;
        return true;
    }

    private boolean lookingAtLookupToken(int n) {
        if (n == this.cchScript) {
            return false;
        }
        int n2 = n;
        this.afterMath = this.tokLastMath != 0 ? n : 0;
        this.tokLastMath = 0;
        char c = this.script.charAt(n++);
        switch (c) {
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '|': {
                if (n < this.cchScript) {
                    if (this.script.charAt(n) == c) {
                        ++n;
                        if (c == '-' || c == '+') break;
                        if (c == '&' && this.charAt(n) == c) {
                            ++n;
                        }
                    } else if (this.script.charAt(n) == '=') {
                        ++n;
                    }
                }
                this.tokLastMath = 1;
                break;
            }
            case '/': {
                if (this.charAt(n) == '/') break;
            }
            case '!': 
            case '\\': {
                if (this.charAt(n) == '=') {
                    ++n;
                }
                this.tokLastMath = 1;
                break;
            }
            case ')': 
            case ']': 
            case '}': {
                break;
            }
            case '.': {
                if (this.charAt(n) == '.') {
                    ++n;
                }
                this.tokLastMath = 1;
                break;
            }
            case '@': 
            case '{': {
                this.tokLastMath = 2;
                break;
            }
            case ':': {
                this.tokLastMath = 1;
                break;
            }
            case '$': 
            case '%': 
            case '(': 
            case ',': 
            case ';': 
            case '[': {
                this.tokLastMath = 1;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                c = this.charAt(n);
                if (c == '<' || c == '=' || c == '>') {
                    ++n;
                }
                this.tokLastMath = 1;
                break;
            }
            default: {
                if (!PT.isLetter(c) && !this.isDotDot) {
                    return false;
                }
            }
            case '\'': 
            case '?': 
            case '_': 
            case '~': {
                if (c == '?') {
                    this.tokLastMath = 1;
                }
                while (PT.isLetterOrDigit(c = this.charAt(n)) || c == '_' || c == '*' && this.charAt(n - 1) == '?' || c == '?' || c == '~' || c == '\'' || c == '\\' && this.charAt(n + 1) == '?' || c == '^' && n > n2 && PT.isDigit(this.charAt(n - 1))) {
                    ++n;
                }
                break block0;
            }
        }
        this.cchToken = n - n2;
        return true;
    }

    private boolean lookForSyncID() {
        char c = this.charAt(this.ichToken);
        if (c == '\"' || c == '@' || c == '\u0000') {
            return false;
        }
        int n = this.ichToken;
        while (!ScriptCompiler.isSpaceOrTab(c = this.charAt(n)) && c != '#' && c != '}' && !this.eol(c)) {
            ++n;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private int ERROR(int n) {
        this.errorIntStr2(n, null, null);
        return 4;
    }

    private int ERROR(int n, String string) {
        this.errorStr(n, string);
        return 4;
    }

    private boolean handleError() {
        this.errorType = this.errorMessage;
        this.errorLine = this.script.substring(this.ichCurrentCommand, this.ichEnd <= this.ichCurrentCommand ? this.ichToken + this.cchToken : this.ichEnd);
        String string = (this.ichToken < this.ichEnd ? this.errorLine.substring(0, this.ichToken - this.ichCurrentCommand) + " >>>> " + this.errorLine.substring(this.ichToken - this.ichCurrentCommand) : this.errorLine) + " <<<<";
        this.errorMessage = GT._("script compiler ERROR: ") + this.errorMessage + ScriptError.getErrorLineMessage(null, this.filename, this.lineCurrent, this.iCommand, string);
        if (!this.isSilent) {
            this.ichToken = Math.max(this.ichEnd, this.ichToken);
            while (!this.lookingAtEndOfLine() && !this.lookingAtTerminator()) {
                ++this.ichToken;
            }
            this.errorLine = this.script.substring(this.ichCurrentCommand, this.ichToken);
            this.vwr.addCommand(this.errorLine + "#??");
            Logger.error(this.errorMessage);
        }
        return false;
    }
}

