/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.awt.Font;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.modelset.TickInfo;
import org.jmol.render.ShapeRenderer;

public abstract class FontLineShapeRenderer
extends ShapeRenderer {
    protected float imageFontScaling;
    protected P3 tickA;
    protected P3 tickB;
    protected P3 tickAs;
    protected P3 tickBs;
    protected Font font3d;
    protected final P3i pt0i = new P3i();
    protected final P3i pt2i = new P3i();
    protected final P3i s1 = new P3i();
    protected final P3i s2 = new P3i();
    protected final P3 pointT = new P3();
    protected final P3 pointT2 = new P3();
    protected final P3 pointT3 = new P3();
    protected final V3 vectorT = new V3();
    protected final V3 vectorT2 = new V3();
    protected final V3 vectorT3 = new V3();
    protected TickInfo tickInfo;
    protected boolean draw000 = true;
    protected int width;
    protected byte endcap = (byte)3;
    protected P3 pt0 = new P3();
    protected P3 pt1 = new P3();
    protected static final int[] dashes = new int[]{12, 0, 0, 2, 5, 7, 10};
    protected static final int[] hDashes = new int[]{10, 7, 6, 1, 3, 4, 6, 7, 9};
    protected static final int[] ndots = new int[]{0, 3, 1000};
    protected static final int[] sixdots = new int[]{12, 3, 6, 1, 3, 5, 7, 9, 11};
    protected static final int[] fourdots = new int[]{13, 3, 5, 2, 5, 8, 11};
    protected static final int[] twodots = new int[]{12, 3, 4, 3, 9};
    protected short colixA;
    protected short colixB;
    protected boolean dotsOrDashes;
    protected int[] dashDots;
    protected boolean asLineOnly;

    protected int getDiameter(int n, int n2) {
        int n3;
        boolean bl = n2 > 20;
        switch (this.exportType) {
            case 1: {
                n3 = bl ? n2 : (int)Math.floor(this.vwr.tm.unscaleToScreen(n, (float)(n2 * 2) / 10.0f) * 1000.0f);
                break;
            }
            default: {
                if (bl) {
                    n3 = (int)this.vwr.tm.scaleToScreen(n, n2 / 10);
                    break;
                }
                if (this.g3d.isAntialiased()) {
                    n2 += n2;
                }
                n3 = n2;
            }
        }
        return n3;
    }

    protected void renderLine(P3 p3, P3 p32, int n, boolean bl) {
        if (n < 0) {
            this.g3d.drawDottedLineBits(p3, p32);
        } else {
            this.g3d.fillCylinderBits(this.endcap, n, p3, p32);
        }
        if (!bl || this.tickInfo == null) {
            return;
        }
        this.checkTickTemps();
        this.tickAs.setT(p3);
        this.tickBs.setT(p32);
        this.drawTicks(n, true);
    }

    protected void checkTickTemps() {
        if (this.tickA == null) {
            this.tickA = new P3();
            this.tickB = new P3();
            this.tickAs = new P3();
            this.tickBs = new P3();
        }
    }

    protected void drawTicks(int n, boolean bl) {
        String[] stringArray;
        if (Float.isNaN(this.tickInfo.first)) {
            this.tickInfo.first = 0.0f;
        }
        float f = this.tickInfo.ticks.x;
        if (!bl) {
            stringArray = null;
        } else if (this.tickInfo.tickLabelFormats == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "%0.2f";
        } else {
            stringArray = this.tickInfo.tickLabelFormats;
        }
        this.drawTicks2(f, 8, n, stringArray);
        this.drawTicks2(this.tickInfo.ticks.y, 4, n, null);
        this.drawTicks2(this.tickInfo.ticks.z, 2, n, null);
    }

    private void drawTicks2(float f, int n, int n2, String[] stringArray) {
        int n3;
        boolean bl;
        float f2;
        if (f == 0.0f) {
            return;
        }
        if (this.g3d.isAntialiased()) {
            n *= 2;
        }
        this.vectorT2.set(this.tickBs.x, this.tickBs.y, 0.0f);
        this.vectorT.set(this.tickAs.x, this.tickAs.y, 0.0f);
        this.vectorT2.sub(this.vectorT);
        if (this.vectorT2.length() < 50.0f) {
            return;
        }
        float f3 = this.tickInfo.signFactor;
        this.vectorT.sub2(this.tickB, this.tickA);
        float f4 = this.vectorT.length();
        if (this.tickInfo.scale != null) {
            if (Float.isNaN(this.tickInfo.scale.x)) {
                f2 = this.vwr.getUnitCellInfo(0);
                if (!Float.isNaN(f2)) {
                    this.vectorT.set(this.vectorT.x / f2, this.vectorT.y / this.vwr.getUnitCellInfo(1), this.vectorT.z / this.vwr.getUnitCellInfo(2));
                }
            } else {
                this.vectorT.set(this.vectorT.x * this.tickInfo.scale.x, this.vectorT.y * this.tickInfo.scale.y, this.vectorT.z * this.tickInfo.scale.z);
            }
        }
        if ((f2 = this.vectorT.length() + 1.0E-4f * f) < f) {
            return;
        }
        float f5 = f / f2 * f4 / f2;
        this.vectorT.scale(f5);
        float f6 = (this.tickBs.z - this.tickAs.z) / (f2 / f);
        f2 += this.tickInfo.first;
        float f7 = (float)((int)Math.floor(this.tickInfo.first / f)) * f - this.tickInfo.first;
        this.pointT.scaleAdd2(f7 / f, this.vectorT, this.tickA);
        f7 += this.tickInfo.first;
        float f8 = this.tickAs.z;
        if (n2 < 0) {
            n2 = 1;
        }
        this.vectorT2.set(-this.vectorT2.y, this.vectorT2.x, 0.0f);
        this.vectorT2.scale((float)n / this.vectorT2.length());
        P3 p3 = this.tickInfo.reference;
        if (p3 == null) {
            this.pointT3.setT(this.vwr.getBoundBoxCenter());
            if (this.vwr.g.axesMode == 0x24000022) {
                this.pointT3.add3(1.0f, 1.0f, 1.0f);
            }
        } else {
            this.pointT3.setT(p3);
        }
        this.tm.transformPtScr(this.pointT3, this.pt2i);
        boolean bl2 = bl = (double)Math.abs(this.vectorT2.x / this.vectorT2.y) < 0.2;
        boolean bl3 = !bl;
        boolean bl4 = !bl2 && this.vectorT2.x < 0.0f;
        boolean bl5 = stringArray != null && stringArray.length > 0;
        Object[] objectArray = new Object[1];
        int n4 = n3 = this.draw000 ? 0 : -1;
        while (f7 < f2) {
            if (f7 >= this.tickInfo.first) {
                this.pointT2.setT(this.pointT);
                this.tm.transformPt3f(this.pointT2, this.pointT2);
                int n5 = (int)Math.floor(this.pointT2.x + this.vectorT2.x);
                int n6 = (int)Math.floor(this.pointT2.y + this.vectorT2.y);
                this.drawLine((int)Math.floor(this.pointT2.x), (int)Math.floor(this.pointT2.y), (int)f8, n5, n6, (int)f8, n2);
                if (bl5 && (this.draw000 || f7 != 0.0f)) {
                    objectArray[0] = Float.valueOf(f7 == 0.0f ? 0.0f : f7 * f3);
                    String string = PT.sprintf(stringArray[n3 % stringArray.length], "f", objectArray);
                    this.drawString(n5, n6, (int)f8, 4, bl4, bl2, bl3, (int)Math.floor(this.pointT2.y), string);
                }
            }
            this.pointT.add(this.vectorT);
            f7 += f;
            f8 += f6;
            ++n3;
        }
    }

    protected int drawLine(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.drawLine2(n, n2, n3, n4, n5, n6, n7);
    }

    protected int drawLine2(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.pt0.set(n, n2, n3);
        this.pt1.set(n4, n5, n6);
        if (this.dotsOrDashes) {
            if (this.dashDots != null) {
                this.drawDashed(n, n2, n3, n4, n5, n6, this.dashDots);
            }
        } else {
            if (n7 < 0) {
                this.g3d.drawDashedLineBits(8, 4, this.pt0, this.pt1);
                return 1;
            }
            this.g3d.fillCylinderBits((byte)2, n7, this.pt0, this.pt1);
        }
        return (n7 + 1) / 2;
    }

    protected void drawString(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, int n5, String string) {
        if (string == null) {
            return;
        }
        int n6 = this.font3d.stringWidth(string);
        int n7 = this.font3d.getAscent();
        int n8 = n;
        n8 = bl ? (n8 -= n4 / 2 + 2 + n6) : (bl2 ? (n8 -= n4 / 2 + 2 + n6 / 2) : (n8 += n4 / 2 + 2));
        int n9 = n2;
        n9 = bl3 ? (n9 += n7 / 2) : (n5 == 0 || n5 < n2 ? (n9 += n7) : (n9 -= n4 / 2));
        int n10 = n3 - n4 - 2;
        if (n10 < 1) {
            n10 = 1;
        }
        this.g3d.drawString(string, this.font3d, n8, n9, n10, n10, (short)0);
    }

    protected void drawDashed(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        short s;
        boolean bl;
        if (nArray == null || this.width < 0) {
            return;
        }
        float f = nArray[0];
        float f2 = n4 - n;
        float f3 = n5 - n2;
        float f4 = n6 - n3;
        int n7 = 0;
        boolean bl2 = nArray == ndots;
        boolean bl3 = bl = bl2 || nArray == sixdots;
        if (bl) {
            float f5 = (f2 * f2 + f3 * f3) / (float)(this.width * this.width);
            if (bl2) {
                f = (float)(Math.sqrt(f5) / 1.5);
                n7 = (int)f + 3;
            } else if (f5 < 8.0f) {
                nArray = twodots;
            } else if (f5 < 32.0f) {
                nArray = fourdots;
            }
        }
        int n8 = nArray[1];
        int n9 = nArray[2];
        short s2 = this.colixA;
        short s3 = s = n9 == 0 ? this.colixB : this.colixA;
        if (n7 == 0) {
            n7 = nArray.length;
        }
        int n10 = 0;
        for (int i = 3; i < n7; ++i) {
            n10 = bl2 ? n10 + 1 : nArray[i];
            int n11 = (int)Math.floor((float)n + f2 * (float)n10 / f);
            int n12 = (int)Math.floor((float)n2 + f3 * (float)n10 / f);
            int n13 = (int)Math.floor((float)n3 + f4 * (float)n10 / f);
            if (bl) {
                this.s1.set(n11, n12, n13);
                if (i == n8) {
                    this.g3d.setC(this.colixA);
                } else if (i == n9) {
                    this.g3d.setC(this.colixB);
                }
                this.g3d.fillSphereI(this.width, this.s1);
                continue;
            }
            if (i == n8) {
                s2 = this.colixB;
            }
            n10 = nArray[++i];
            if (i == n9) {
                s = this.colixB;
            }
            int n14 = (int)Math.floor((float)n + f2 * (float)n10 / f);
            int n15 = (int)Math.floor((float)n2 + f3 * (float)n10 / f);
            int n16 = (int)Math.floor((float)n3 + f4 * (float)n10 / f);
            this.fillCylinder(s2, s, (byte)2, this.width, n11, n12, n13, n14, n15, n16);
        }
    }

    protected void fillCylinder(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.asLineOnly) {
            this.g3d.drawLine(s, s2, n2, n3, n4, n5, n6, n7);
        } else {
            this.g3d.fillCylinderXYZ(s, s2, by, !this.isExport || this.mad == 1 ? n : (int)this.mad, n2, n3, n4, n5, n6, n7);
        }
    }
}

