/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class PsiReader
extends MOReader {
    Lst<String> atomNames = new Lst();
    Lst<Lst<int[]>> shellsByUniqueAtom = new Lst();
    Map<String, Integer> uniqueAtomMap = new Hashtable<String, Integer>();

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("-Geometry after Center-of-Mass shift and reorientation (a.u.):") >= 0) {
            this.readAtoms(true);
            this.doProcessLines = true;
            return true;
        }
        if (this.line.indexOf("-Unique atoms in the canonical coordinate system (a.u.):") >= 0) {
            this.readUniqueAtoms();
            this.doProcessLines = true;
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("New Cartesian Geometry in a.u.") >= 0) {
            this.readAtoms(false);
            return true;
        }
        if (this.line.startsWith("  label        = ")) {
            this.calculationType = this.line.substring(17).trim();
            this.moData.put("calculationType", this.calculationType);
            return true;
        }
        if (this.line.startsWith("molecular orbitals for ")) {
            this.moData.put("energyUnits", "");
            return true;
        }
        if (this.line.startsWith("  -BASIS SETS:")) {
            this.readBasis();
            return true;
        }
        if (this.line.indexOf("Molecular Orbital Coefficients") >= 0) {
            if (this.filterMO()) {
                this.readPsiMolecularOrbitals();
            }
            return true;
        }
        if (this.line.indexOf("SCF total energy   =") >= 0) {
            this.readSCFDone();
            return true;
        }
        if (this.line.indexOf("Normal Modes") >= 0) {
            this.readFrequencies();
            return true;
        }
        return this.checkNboLine();
    }

    private void readSCFDone() throws Exception {
        this.asc.setAtomSetName(this.line);
    }

    private void readAtoms(boolean bl) throws Exception {
        if (bl) {
            this.asc.newAtomSet();
            this.asc.setAtomSetName("");
            this.discardLinesUntilContains("----");
        }
        int n = 0;
        while (this.rd() != null && this.line.length() > 0) {
            Atom atom;
            String[] stringArray = this.getTokens();
            Atom atom2 = atom = bl ? this.asc.addNewAtom() : this.asc.atoms[n++];
            if (bl) {
                this.atomNames.addLast(stringArray[0]);
                if (stringArray[0].length() <= 2) {
                    atom.elementNumber = (short)JmolAdapter.getElementNumber(stringArray[0]);
                }
            } else {
                atom.elementNumber = (short)this.parseIntStr(stringArray[0]);
            }
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            this.setAtomCoordScaled(atom, stringArray, 1, 0.5291772f);
        }
    }

    void readBasis() throws Exception {
        int n;
        String[] stringArray;
        Lst<String[]> lst = new Lst<String[]>();
        this.gaussianCount = 0;
        this.shellCount = 0;
        int[] nArray = null;
        Lst<int[]> lst2 = null;
        this.rd();
        while (this.rd() != null && this.line.startsWith("   -Basis set on")) {
            lst2 = new Lst<int[]>();
            int n2 = 0;
            while (this.rd() != null && !this.line.startsWith("       )")) {
                this.line = this.line.replace('(', ' ').replace(')', ' ');
                stringArray = this.getTokens();
                n = 0;
                switch (stringArray.length) {
                    case 3: {
                        if (nArray != null) {
                            lst2.addLast(nArray);
                        }
                        n = 1;
                        nArray = new int[3];
                        nArray[0] = BasisFunctionReader.getQuantumShellTagID(stringArray[0]);
                        nArray[1] = this.gaussianCount;
                        ++this.shellCount;
                        break;
                    }
                }
                lst.addLast(new String[]{stringArray[n], stringArray[n + 1]});
                nArray[2] = ++n2;
            }
            if (nArray != null) {
                lst2.addLast(nArray);
            }
            this.shellsByUniqueAtom.addLast(lst2);
            this.gaussianCount += n2;
            this.rd();
        }
        float[][] fArray = AU.newFloat2(this.gaussianCount);
        for (n = 0; n < this.gaussianCount; ++n) {
            stringArray = (String[])lst.get(n);
            fArray[n] = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[n][i] = this.parseFloatStr(stringArray[i]);
            }
        }
        this.moData.put("gaussians", fArray);
        if (this.debugging) {
            Logger.debug(this.shellCount + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
    }

    private void readUniqueAtoms() throws Exception {
        Lst<int[]> lst = new Lst<int[]>();
        this.discardLinesUntilContains("----");
        int n = 0;
        while (this.rd() != null && this.line.length() > 0) {
            String[] stringArray = this.getTokens();
            this.uniqueAtomMap.put(stringArray[0], n++);
        }
        int n2 = this.atomNames.size();
        for (int i = 0; i < n2; ++i) {
            String string = (String)this.atomNames.get(i);
            int n3 = this.uniqueAtomMap.get(string);
            Lst lst2 = (Lst)this.shellsByUniqueAtom.get(n3);
            if (lst2 == null) {
                Logger.error("slater for atom " + i + " atomType " + string + " was not found in listing. Ignoring molecular orbitals");
                return;
            }
            for (int j = 0; j < lst2.size(); ++j) {
                int[] nArray = (int[])lst2.get(j);
                lst.addLast(new int[]{i, nArray[0], nArray[1], nArray[2]});
            }
        }
        this.moData.put("shells", lst);
    }

    void readPsiMolecularOrbitals() throws Exception {
        Map<K, V>[] mapArray = AU.createArrayOfHashtable(5);
        Lst<type>[] lstArray = AU.createArrayOfArrayList(5);
        int n = 0;
        while (this.rd() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            int n2;
            int n3;
            String[] stringArray = this.getTokens();
            int n4 = n3 = this.line.charAt(5) == ' ' ? 2 : 4;
            if (this.line.indexOf("                    ") == 0) {
                this.addMOData(n, lstArray, mapArray);
                n = stringArray.length;
                stringArray = PT.getTokens(this.rd());
                for (n2 = 0; n2 < n; ++n2) {
                    mapArray[n2] = new Hashtable();
                    lstArray[n2] = new Lst();
                    mapArray[n2].put("symmetry", stringArray[n2]);
                }
                stringArray = PsiReader.getStrings(this.rd().substring(21), n, 10);
                for (n2 = 0; n2 < n; ++n2) {
                    mapArray[n2].put("energy", Float.valueOf(PT.fVal(stringArray[n2])));
                }
                continue;
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    lstArray[n2].addLast(stringArray[n2 + n3]);
                }
            }
            catch (Exception exception) {
                Logger.error("Error reading Psi3 file molecular orbitals at line: " + this.line);
                break;
            }
        }
        this.addMOData(n, lstArray, mapArray);
        this.moData.put("mos", this.orbitals);
        this.finalizeMOData(this.moData);
    }

    private void readFrequencies() throws Exception {
        this.rd();
        int n = this.asc.getLastAtomSetAtomCount();
        while (this.rd() != null && this.line.indexOf("Frequency") >= 0) {
            String[] stringArray = this.getTokens();
            int n2 = this.asc.ac;
            boolean[] blArray = new boolean[1];
            if (!this.doGetVibration(++this.vibrationNumber)) continue;
            this.asc.cloneLastAtomSet();
            this.asc.setAtomSetFrequency(null, null, stringArray[1], null);
            this.readLines(2);
            this.fillFrequencyData(n2, n, n, blArray, true, 0, 0, null, 0);
            this.rd();
        }
    }
}

