/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBODialogView;

abstract class NBODialogSearch
extends NBODialogView {
    private int operator = 1;
    protected boolean twoOps = false;
    protected JPanel comboBox;
    protected JTextField opTxt;
    protected JComboBox<String> bas2;
    protected JComboBox<String> orb;
    protected JComboBox<String> nbo1;
    protected JComboBox<String> nbo2;
    protected JComboBox<String> unit;
    protected JComboBox<String> at1;
    protected JComboBox<String> at2;
    protected JComboBox<String> row;
    protected JComboBox<String> col;
    protected JComboBox<String> keyWord;
    protected String keyProp;
    protected JCheckBox viewAll;
    protected JList<String> opList;
    private DefaultListModel<String> listM;
    private static final int KEYWD_NPA = 1;
    private static final int KEYWD_NBO = 2;
    private static final int KEYWD_BEND = 3;
    private static final int KEYWD_E2PERT = 4;
    private static final int KEYWD_NLMO = 5;
    private static final int KEYWD_NRT = 6;
    private static final int KEYWD_STERIC = 7;
    private static final int KEYWD_CMO = 8;
    private static final int KEYWD_DIPOLE = 9;
    private static final int KEYWD_OPBAS = 10;
    private static final int KEYWD_BAS1BAS2 = 11;
    private static final int NPA_VIS = 11;
    private static final int NBO_VIS = 7;
    private static final int BEND_VIS = 8;
    private static final int E2_VIS = 7;
    private static final int NLMO_VIS = 7;
    private static final int STERIC_VIS = 8;
    private static final int MO_VIS = 8;
    static final int CMO_VIS = 9;
    private String[] keyW = new String[]{"-Select Keyword Property-", "NPA        Atomic and NAO properties", "NBO        Natural Lewis Structure and NBO properties", "BEND       NHO directionality and bond-bending", "E2PERT     2nd-order energtics of NBO donor-acceptor interactions", "NLMO       NLMO properties", "NRT        Natural Resonance Theory weightings and bond orders", "STERIC     Total and pairwise contributions to steric exchange energy", "CMO        NBO-based character of canonical molecular orbitals", "DIPOLE     L/NL contributions to electric dipole moment", "<OPBAS>    Matrix elements of chosen operator in chosen basis set", "<BAS1BAS2> Transformation matrix between chosen basis sets"};
    protected String[] npa = new String[]{"NPA Atomic Properties:", "  (1) NPA atomic charge", "  (2) NPA atomic spin density", "  (3) NEC atomic electron configuration", "NPA Molecular Uit Properties:", "  (4) NPA molecular unit charge", "  (5) NPA molecular unit spin density", "NAO Orbital Properties:", "  (6) NAO label", "  (7) NAO orbital population", "  (8) NAO orbital energy", "  (9) NAO orbital spin density", "  (10) NMB minimal basis %-accuracy", "Display Options:", "  (11) Display (P)NAO visualization", "  (12) Display atomic charges"};
    protected String[] nbo = new String[]{"NBO Orbital Properties:", "  (1) NBO orbital label", "  (2) NBO orbital population", "  (3) NBO orbital energy", "  (4) NBO ionicity", "Natural Lew Structure Properties:", "  (5) NLS rho(NL)", "  (6) NLS %-rho(L)", "Display Options:", "  (7) Display (P)NAO visualization", "  (8) Display NLS diagram"};
    protected String[] bend = new String[]{"NHO Orbital Prperties:", "  (1) NHO orbital label", "  (2) NHO orbital population", "  (3) NHO orbital energy", "  (4) NHO hybrid composition", "  (5) NHO direction angles", "  (6) NHO bending deviation from line of centers", "  (7) Strongest bending deviation for any NHO", "Display Option", "  (8) Display (P)NHO visualiztion"};
    protected String[] e2 = new String[]{"E2 Values for Selected Donor-Acceptor NBOs:", "  (1) E(2) interaction for current d/a NBOs", "  (2) Strongest E(2) interaction for current d-NBO", "  (3) Strongest E(2) interaction for current a-NBO", "  (4) Strongest E(2) interaction for any d/a NBOs", "Intermolecular E2 Options:", "  (5) Strongest intermolecular E(2) for current unit", "  (6) Strongest intermolecular E(2) for any units", "Display Option:", "  (7) Display (P)NBO visualization for current d/a NBOs", "back"};
    protected String[] nlmo = new String[]{"NLMO Orbital Properties:", "  (1) NLMO orbital label", "  (2) NLMO population", "  (3) NLMO orbital energy", "  (4) NLMO %-NBO parentage", "NLMO Delocalization Tail Properties:", "  (5) NLMO delocalization tail population", "  (6) NLMO delocalization tail NBO components", "Display Option:", "  (7) Display (P)NLMO visualization"};
    protected String[] nrt = new String[]{"Atom (A) Properties:", "  (1) atomic valency (total)", "  (2) atomic covalency", "  (3) atomic electrovalency", "Bond [A-A'] Properties:", "  (4) bond order (total)", "  (5) covalent bond order", "  (6) electrovalent bond order", "Resonance Structure Properties:", "  (7) RS weighting", "  (8) RS rho(NL) (reference structures only)", "Display Options:", "  (9) Display NRT atomic valencies", "  (10) Display NRT bond orders", "  (11) Display RS diagram"};
    protected String[] steric = new String[]{"Total Steric Exchange Energy (SXE) Estimates:", "  (1) Total SXE", "  (2) Sum of pairwise (PW-SXE) contributions", "Selected PW-SXE contributions:", "  (3) PW-SXE for current d-d' NLMOs", "  (4) Strongest PW-SXE for current d NLMO", "Intra- and intermolecular options:", "  (5) Strongest PW-SXE within current unit", "  (6) Strongest PW-SXE within any unit", "  (7) Strongest PW-SXE between any units", "Display Option:", "  (8) Display (P)NLMO diagram for current PW-SXE"};
    protected String[] mo = new String[]{"Character of current MO (c):", "  (1) Current MO energy and type", "  (2) Bonding character of current MO", "  (3) Nonbonding character of current MO", "  (4) Antibonding character of current MO", "NBO (n) %-contribution to selected MO (c):", "  (5) %-contribution of current NBO to current MO", "  (6) Largest %-contribution to current MO from any NBO", "  (7) Largest %-contribution of current NBO to any MO", "Display Options:", "  (8) Display current MO", "  (9) Display current NBO"};
    protected String[] dip = new String[]{"Total Dipole Properties:", "  (1) Total dipole moment", "  (2) Total L-type dipole", "  (3) Total NL-type (resonance) dipole", "Bond [NBO/NLMO] Dipole Properties:", "  (4) Dipole moment of current NLMO", "  (5) L-type (NBO bond dipole) contribution", "  (6) NL-type (resonance dipole) contribution", "Molecular Unit Dipole Properties:", "  (7) Dipole moment of current molecular unit", "  (8) L-type contribution to unit dipole", "  (9) NL-type contribution to unit dipole"};
    protected String[] op = new String[]{"***** Select OP *****", "  (1) S   overlap (unit) operator", "  (2) F   1e Hamiltonian (Fock/Kohn-Sham) operator", "  (3) K   kinetic energy operator", "  (4) V   1e potential (nuclear-electron attraction) operator", "  (5) DM  1e density matrix operator", "  (6) DIx dipole moment operator (x component)", "  (7) DIy dipole moment operator (y component)", "  (8) DIz dipole moment operator (z component)"};
    private boolean secondPick = true;

    protected NBODialogSearch(JFrame jFrame) {
        super(jFrame);
        this.lists = new Hashtable();
    }

    protected void buildSearch(Container container) {
        this.opList = null;
        this.keyProp = "";
        this.reqInfo = "";
        Properties properties = JmolPanel.historyFile.getProperties();
        this.workingPath = properties.getProperty("workingPath", System.getProperty("user.home"));
        container.removeAll();
        container.setLayout(new BorderLayout());
        if (this.topPanel == null) {
            this.topPanel = this.buildTopPanel();
        }
        container.add((Component)this.topPanel, "First");
        JPanel jPanel = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, this.searchP(true), this.searchS());
        jSplitPane.setDividerLocation(430);
        jPanel.add((Component)jSplitPane, "Center");
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("JobFile")).setFont(new Font("Arial", 1, 25));
        box.add(this.folderBox());
        this.browse.setEnabled(true);
        jPanel.add((Component)box, "North");
        container.add((Component)jPanel, "Center");
        this.statusLab.setText("");
        container.add((Component)this.statusPanel, "Last");
        if (this.isJmolNBO) {
            this.setInputFile(this.inputFile, "47", null);
            this.keyWord.setSelectedIndex(1);
        }
    }

    private JPanel searchP(boolean bl) {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.listM = new DefaultListModel();
        this.opList = new JList<String>(this.listM);
        this.opList.setFont(new Font("Arial", 0, 18));
        this.opList.setSelectedIndex(1);
        this.opList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (NBODialogSearch.this.opList.getSelectedIndex() != -1) {
                    NBODialogSearch.this.goSearchClicked();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.opList);
        jPanel.add((Component)jScrollPane, "Center");
        this.keyWord = new JComboBox<String>(this.keyW);
        this.keyWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogSearch.this.keywordNumber = NBODialogSearch.this.keyWord.getSelectedIndex();
                NBODialogSearch.this.listClicked(NBODialogSearch.this.keyWord.getSelectedIndex());
            }
        });
        this.keyWord.setEnabled(this.isJmolNBO);
        jPanel.add(this.keyWord, "North");
        this.jCheckAtomNum = new JCheckBox("Show Atom #'s");
        this.jCheckAtomNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!NBODialogSearch.this.jCheckAtomNum.isSelected()) {
                    NBODialogSearch.this.nboService.runScriptQueued("select {*};label off");
                } else {
                    NBODialogSearch.this.nboService.runScriptQueued("select {*};label %a");
                }
                NBODialogSearch.this.nboService.runScriptQueued("color labels white;select remove {*}");
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(this.jCheckAtomNum);
        if (bl) {
            this.viewAll = new JCheckBox("View all");
            box.add(this.viewAll);
        } else {
            this.viewAll = null;
        }
        jPanel.add((Component)box, "South");
        return jPanel;
    }

    private JPanel searchS() {
        this.keyProp = "";
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.setLayout(new BorderLayout());
        this.basis = new JComboBox<String>(basSet);
        this.comboBox = new JPanel(new BorderLayout());
        jPanel.add((Component)this.comboBox, "First");
        jPanel.add((Component)this.modelOut(), "Center");
        return jPanel;
    }

    protected void getList1(final String string) {
        final SB sB = new SB();
        this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sB);
        this.appendToFile("GLOBAL I_KEYWORD " + this.keywordNumber + sep, sB);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sB);
        this.appendToFile("GLOBAL I_BAS_1 " + this.keywordNumber + sep, sB);
        String string2 = string.split(" ")[0];
        this.appendToFile("CMD " + string2, sB);
        this.nboService.queueJob("getSearchList", "Getting search list " + string.substring(string.indexOf("-") + 1), new Runnable(){

            @Override
            public void run() {
                NBODialogSearch.this.reqInfo = "";
                NBODialogSearch.this.nboService.rawCmdNew("s", sB, true, 33);
                String[] stringArray = new String[NBODialogSearch.this.reqInfo.length() / 20];
                int n = 0;
                while ((n + 1) * 20 <= NBODialogSearch.this.reqInfo.length()) {
                    stringArray[n] = NBODialogSearch.this.reqInfo.substring(n * 20, (n + 1) * 20);
                    ++n;
                }
                NBODialogSearch.this.lists.put(string, stringArray);
                System.out.println("created list " + string + " len=" + stringArray.length + " " + NBODialogSearch.this.reqInfo);
                NBODialogSearch.this.reqInfo = null;
            }
        });
    }

    protected void setLists(final String[] stringArray, final String[] stringArray2) {
        this.comboBox.removeAll();
        this.nboService.queueJob("setLists", null, new Runnable(){

            @Override
            public void run() {
                JPanel jPanel = new JPanel(new GridLayout(stringArray2.length, 1));
                JPanel jPanel2 = new JPanel(new GridLayout(stringArray2.length, 1));
                for (int i = 0; i < stringArray2.length; ++i) {
                    final String string = stringArray[i].split(" ")[0];
                    jPanel.add(new JLabel(stringArray2[i]));
                    if (string.equals("b")) {
                        jPanel2.add(new JLabel(NBODialogSearch.this.basis.getSelectedItem().toString()));
                        continue;
                    }
                    if (string.equals("o")) {
                        NBODialogSearch.this.orb = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get(stringArray[i]));
                        NBODialogSearch.this.orb.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                NBODialogSearch.this.showOrbJmol(NBODialogSearch.this.basis.getSelectedItem().toString(), NBODialogSearch.this.orb.getSelectedIndex() + 1);
                            }
                        });
                        NBODialogSearch.this.orb.setSelectedIndex(0);
                        jPanel2.add(NBODialogSearch.this.orb);
                        continue;
                    }
                    if (string.equals("d") || stringArray[i].equals("c cmo")) {
                        NBODialogSearch.this.nbo1 = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get(stringArray[i]));
                        NBODialogSearch.this.nbo1.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                NBODialogSearch.this.showOrbJmol(NBODialogSearch.this.basis.getSelectedItem().toString(), NBODialogSearch.this.nbo1.getSelectedIndex() + 1);
                            }
                        });
                        NBODialogSearch.this.nbo1.setSelectedIndex(0);
                        jPanel2.add(NBODialogSearch.this.nbo1);
                        continue;
                    }
                    if (string.equals("d'") || string.equals("n") || stringArray[i].equals("a nbo")) {
                        NBODialogSearch.this.nbo2 = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get(stringArray[i]));
                        NBODialogSearch.this.nbo2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (string.equals("n")) {
                                    NBODialogSearch.this.showOrbJmol("NBO", NBODialogSearch.this.nbo2.getSelectedIndex() + 1);
                                } else if (string.equals("a")) {
                                    NBODialogSearch.this.showOrbJmol("NBO", ((String[])NBODialogSearch.this.lists.get("d nbo")).length + 1 + NBODialogSearch.this.nbo2.getSelectedIndex());
                                } else {
                                    NBODialogSearch.this.showOrbJmol(NBODialogSearch.this.basis.getSelectedItem().toString(), NBODialogSearch.this.nbo2.getSelectedIndex() + 1);
                                }
                            }
                        });
                        NBODialogSearch.this.nbo2.setSelectedIndex(0);
                        jPanel2.add(NBODialogSearch.this.nbo2);
                        continue;
                    }
                    if (string.equals("u") || string.equals("rs")) {
                        NBODialogSearch.this.unit = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get(stringArray[i]));
                        jPanel2.add(NBODialogSearch.this.unit);
                        continue;
                    }
                    if (string.equals("a")) {
                        NBODialogSearch.this.at1 = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get(stringArray[i]));
                        NBODialogSearch.this.at1.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (NBODialogSearch.this.at2 == null) {
                                    NBODialogSearch.this.nboService.runScriptQueued("select on; select {*}[" + (NBODialogSearch.this.at1.getSelectedIndex() + 1) + "]");
                                } else {
                                    NBODialogSearch.this.nboService.runScriptQueued("select on; select remove{*}; select add {*}[" + (NBODialogSearch.this.at1.getSelectedIndex() + 1) + "]; select add {*}[" + (NBODialogSearch.this.at2.getSelectedIndex() + 1) + "]");
                                }
                            }
                        });
                        NBODialogSearch.this.at1.setSelectedIndex(0);
                        jPanel2.add(NBODialogSearch.this.at1);
                        continue;
                    }
                    if (string.equals("a'")) {
                        NBODialogSearch.this.at2 = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get("a"));
                        NBODialogSearch.this.at2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                NBODialogSearch.this.nboService.runScriptQueued("select on; select remove{*}; select add {*}[" + (NBODialogSearch.this.at1.getSelectedIndex() + 1) + "]; select add {*}[" + (NBODialogSearch.this.at2.getSelectedIndex() + 1) + "]");
                            }
                        });
                        NBODialogSearch.this.at2.setSelectedIndex(1);
                        jPanel2.add(NBODialogSearch.this.at2);
                        continue;
                    }
                    if (string.equals("b1")) {
                        jPanel2.add(NBODialogSearch.this.basis);
                        NBODialogSearch.this.basis.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                NBODialogSearch.this.basChange();
                            }
                        });
                        continue;
                    }
                    if (string.equals("b2")) {
                        NBODialogSearch.this.bas2 = new JComboBox<String>(NBODialogView.basSet);
                        NBODialogSearch.this.bas2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                NBODialogSearch.this.basChange();
                            }
                        });
                        NBODialogSearch.this.bas2.setSelectedIndex(1);
                        jPanel2.add(NBODialogSearch.this.bas2);
                        continue;
                    }
                    if (string.equals("b12")) {
                        NBODialogSearch.this.basis = new JComboBox<String>(NBODialogView.basSet);
                        jPanel2.add(NBODialogSearch.this.basis);
                        continue;
                    }
                    if (string.equals("r")) {
                        NBODialogSearch.this.row = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get("r"));
                        jPanel2.add(NBODialogSearch.this.row);
                        continue;
                    }
                    if (!string.equals("c")) continue;
                    NBODialogSearch.this.col = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get("c"));
                    jPanel2.add(NBODialogSearch.this.col);
                }
                NBODialogSearch.this.appendOutputWithCaret((NBODialogSearch.this.jpNboOutput.getText().equals("") ? "" : "\n") + NBODialogSearch.this.keyProp + " Search Results:");
                NBODialogSearch.this.comboBox.add((Component)jPanel, "West");
                NBODialogSearch.this.comboBox.add((Component)jPanel2, "Center");
            }
        });
    }

    protected void basChange() {
        String[] stringArray = new String[]{"Current (r,c) matrix element:", "  (1) current <" + this.basis.getSelectedItem().toString() + "(r)|" + this.bas2.getSelectedItem().toString() + "(c)> value", "Extremal off-diagonal values for current r(ow) orbital:", "  (2) max <" + this.basis.getSelectedItem().toString() + "(r)|" + this.bas2.getSelectedItem().toString() + "(*c)> value for current r", "  (3) min <" + this.basis.getSelectedItem().toString() + "(r)|" + this.bas2.getSelectedItem().toString() + "(*c)> value for current r", "Extremal off-diagonal values for current c(ol) orbital:", "  (4) max <" + this.basis.getSelectedItem().toString() + "(*r)|" + this.bas2.getSelectedItem().toString() + "(c)> value for current c", "  (5) min <" + this.basis.getSelectedItem().toString() + "(*r)|" + this.bas2.getSelectedItem().toString() + "(c)> value for current c", "Extremal off-diagonal values for any (*r,*c) orbitals:", "  (6) max <" + this.basis.getSelectedItem().toString() + "(*r)|" + this.bas2.getSelectedItem().toString() + "(*c)> value for any *r,*c", "  (7) min <" + this.basis.getSelectedItem().toString() + "(*r)|" + this.bas2.getSelectedItem().toString() + "(*c)> value for any *r,*c", "back"};
        this.changeKey(stringArray);
    }

    private void changeKey(String[] stringArray) {
        this.listM.removeAllElements();
        for (String string : stringArray) {
            this.listM.addElement(string);
        }
    }

    protected void listLogic() {
        if (this.twoOps) {
            if (this.opList.getSelectedIndex() != 0) {
                if (this.keyProp.equals("")) {
                    this.operator = this.opList.getSelectedIndex();
                    if (this.lists.get("r") == null) {
                        this.getList1("r");
                    }
                    if (this.lists.get("c") == null) {
                        this.getList1("c");
                    }
                    this.setLists("b12 r c".split(" "), new String[]{"Basis:", "Row: ", "Collumn: "});
                    this.keyProp = "OPBAS";
                } else {
                    this.goSearchClicked();
                }
            }
            return;
        }
        if (this.keyProp.equals("")) {
            this.keywordNumber = this.opList.getSelectedIndex();
            if (this.keywordNumber != 10) {
                this.basis.setEnabled(this.keywordNumber == 10 || this.keywordNumber == 11);
            }
            this.listClicked(this.keywordNumber);
            return;
        }
        if (this.opList.getSelectedIndex() != 0) {
            this.goSearchClicked();
        }
    }

    private String[] opBas(String string) {
        return new String[]{"Current [r,c] matrix element", "  (1) current <r\\" + string + "\\c> value", "Extremal off-diagonal values for current r[ow] orbital:", "  (2) max <r\\" + string + "\\*c> value for current r", "  (3) min <r\\" + string + "\\*c> value for current r", "Extremal off-diagonal values for current c[ol] orbital:", "  (4) max <*r\\" + string + "\\c> value for current c", "  (5) min <*r\\" + string + "\\c> value for current c", "Extremal off-diagonal values for any [*r,*c] orbitals:", "  (6) max <*r\\" + string + "\\*c> value for any *r,*c", "  (7) min <*r\\" + string + "\\*c> value for any *r,*c", "back"};
    }

    protected void listClicked(int n) {
        switch (n) {
            case 1: {
                this.at2 = null;
                this.basis.setSelectedIndex(1);
                this.keyProp = "NPA";
                if (this.lists.get("a") == null) {
                    this.getList1("a");
                }
                if (this.lists.get("o PNAO") == null) {
                    this.getList1("o PNAO");
                }
                if (this.lists.get("u") == null) {
                    this.getList1("u");
                }
                this.setLists(new String[]{"b", "a", "o PNAO", "u"}, new String[]{"Basis: ", "Atom: ", "Orbital: ", "Unit: "});
                this.changeKey(this.npa);
                break;
            }
            case 2: {
                this.basis.setSelectedIndex(5);
                this.keyProp = "NBO";
                if (this.lists.get("o PNBO") == null) {
                    this.getList1("o PNBO");
                }
                this.setLists(new String[]{"b", "o PNBO"}, new String[]{"Basis: ", "Orbital: "});
                this.changeKey(this.nbo);
                break;
            }
            case 5: {
                this.basis.setSelectedIndex(7);
                this.keyProp = "NLMO";
                if (this.lists.get("o PNLMO") == null) {
                    this.getList1("o PNLMO");
                }
                this.setLists(new String[]{"b", "o PNLMO"}, new String[]{"Basis: ", "Orbital: "});
                this.changeKey(this.nlmo);
                break;
            }
            case 3: {
                this.basis.setSelectedIndex(3);
                this.keyProp = "BEND";
                if (this.lists.get("o PNHO") == null) {
                    this.getList1("o PNHO");
                }
                this.setLists(new String[]{"b", "o PNHO"}, new String[]{"Basis: ", "Orbital: "});
                this.changeKey(this.bend);
                break;
            }
            case 6: {
                this.keyProp = "NRT";
                if (this.lists.get("a") == null) {
                    this.getList1("a");
                }
                if (this.lists.get("rs") == null) {
                    this.getRs();
                }
                this.setLists("a a' rs".split(" "), new String[]{"Atom 1: ", "Atom 2: ", "Res Struct: "});
                this.changeKey(this.nrt);
                break;
            }
            case 4: {
                this.basis.setSelectedIndex(6);
                this.keyProp = "E2";
                if (this.lists.get("d nbo") == null) {
                    this.getList1("d nbo");
                }
                if (this.lists.get("a nbo") == null) {
                    this.getList1("a nbo");
                }
                if (this.lists.get("u") == null) {
                    this.getList1("u");
                }
                this.setLists(new String[]{"b", "d nbo", "a nbo", "u"}, new String[]{"Basis: ", "d-NBO: ", "a-NBO:", "Unit: "});
                this.changeKey(this.e2);
                break;
            }
            case 7: {
                this.basis.setSelectedIndex(8);
                this.keyProp = "STERIC";
                if (this.lists.get("d nlmo") == null) {
                    this.getList1("d nlmo");
                }
                if (this.lists.get("d' nlmo") == null) {
                    this.getList1("d' nlmo");
                }
                if (this.lists.get("u") == null) {
                    this.getList1("u");
                }
                this.setLists(new String[]{"b", "d nlmo", "d' nlmo", "u"}, new String[]{"Basis: ", "d-NLMO: ", "d'-NLMO:", "Unit: "});
                this.changeKey(this.steric);
                break;
            }
            case 8: {
                this.basis.setSelectedIndex(9);
                this.keyProp = "CMO";
                if (this.lists.get("c cmo") == null) {
                    this.getList1("c cmo");
                }
                if (this.lists.get("n") == null) {
                    this.getList1("n");
                }
                this.setLists(new String[]{"b", "c cmo", "n"}, new String[]{"Basis: ", "c-CMO: ", "n-NBO:"});
                this.changeKey(this.mo);
                break;
            }
            case 9: {
                this.basis.setSelectedIndex(8);
                this.keyProp = "DIPOLE";
                if (this.lists.get("u") == null) {
                    this.getList1("u");
                }
                this.setLists("b u".split(" "), new String[]{"Basis: ", "Unit:"});
                this.changeKey(this.dip);
                break;
            }
            case 10: {
                this.comboBox.removeAll();
                this.basis = new JComboBox<String>(basSet);
                this.basis.setEditable(false);
                this.changeKey(this.opBas("s"));
                break;
            }
            case 11: {
                this.keyProp = "B1B2";
                if (this.lists.get("r") == null) {
                    this.getList1("r");
                }
                if (this.lists.get("c") == null) {
                    this.getList1("c");
                }
                this.setLists("b1 b2 r c".split(" "), new String[]{"Basis 1:", "Basis 2:", "Row:", "Collumn:"});
            }
        }
    }

    protected void labelAt() {
        int n;
        Logger.info(this.reqInfo);
        String[] stringArray = this.reqInfo.trim().split(" |\\n");
        String[] stringArray2 = new String[this.jmolAtomCount];
        for (n = 0; n < this.jmolAtomCount - 1; ++n) {
            stringArray2[n] = stringArray[n + 1];
            System.out.println("___" + stringArray2[n] + "    =    " + stringArray[n + 1]);
        }
        stringArray2[this.jmolAtomCount - 1] = stringArray[0];
        for (n = 0; n < this.jmolAtomCount; ++n) {
            this.nboService.runScriptQueued("select{*}[" + (n + 1) + "];label " + stringArray2[n]);
        }
    }

    @Override
    protected void showWorkpathDialogS(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileNameExtensionFilter("NBO", "nbo"));
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setSelectedFile(new File(this.workingPath));
        int n = jFileChooser.showDialog(this, GT._("Select"));
        if (n != 0) {
            return;
        }
        this.nboResetV();
        this.setInputFile(this.newNBOFile(jFileChooser.getSelectedFile(), "47"), "nbo", this.showWorkPathDone);
        this.keyWord.setEnabled(true);
        this.keyWord.setSelectedIndex(this.keywordNumber);
    }

    private void getRs() {
        final SB sB = new SB();
        this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sB);
        this.appendToFile("GLOBAL I_KEYWORD " + this.keywordNumber + sep, sB);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sB);
        this.appendToFile("GLOBAL I_BAS_1 " + this.keywordNumber + sep, sB);
        this.appendToFile("CMD  r", sB);
        this.nboService.queueJob("search", "getting resonance structures", new Runnable(){

            @Override
            public void run() {
                NBODialogSearch.this.reqInfo = "";
                NBODialogSearch.this.nboService.rawCmdNew("s", sB, true, 47);
                int n = Integer.parseInt(NBODialogSearch.this.reqInfo.substring(NBODialogSearch.this.reqInfo.indexOf("-") + 1, NBODialogSearch.this.reqInfo.indexOf(")")));
                System.out.println("...." + n);
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = i + 1 + ". R.S. " + (i + 1);
                }
                NBODialogSearch.this.lists.put("rs", stringArray);
            }
        });
    }

    protected void goSearchClicked() {
        final SB sB = new SB();
        this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sB);
        this.appendToFile("GLOBAL I_KEYWORD " + this.keywordNumber + sep, sB);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sB);
        String string = this.opList.getSelectedValue();
        if (string.indexOf("(") < 0 || this.keyProp.equals("E2") && this.opList.getSelectedIndex() == 2) {
            return;
        }
        int n = Integer.parseInt(string.substring(string.indexOf("(") + 1, string.indexOf(")")));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (this.keywordNumber) {
            case 1: {
                this.appendToFile("GLOBAL I_ATOM_1 " + (this.at1.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_UNIT " + (this.unit.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_ORB_1 " + (this.orb.getSelectedIndex() + 1) + sep, sB);
                bl = n == 11;
                bl2 = n == 12;
                break;
            }
            case 2: {
                bl3 = n == 8;
                bl = n == 7;
                this.appendToFile("GLOBAL I_ORB_1 " + (this.orb.getSelectedIndex() + 1) + sep, sB);
                break;
            }
            case 3: {
                bl = n == 8;
                this.appendToFile("GLOBAL I_ORB_1 " + (this.orb.getSelectedIndex() + 1) + sep, sB);
                break;
            }
            case 4: {
                bl = n == 7;
                this.appendToFile("GLOBAL I_d_NBO_1 " + (this.nbo1.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_a_NBO " + (this.nbo2.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_UNIT " + (this.unit.getSelectedIndex() + 1) + sep, sB);
                break;
            }
            case 5: {
                bl = n == 7;
                this.appendToFile("GLOBAL I_ORB_1 " + (this.orb.getSelectedIndex() + 1) + sep, sB);
                break;
            }
            case 6: {
                this.appendToFile("GLOBAL I_ATOM_1 " + (this.at1.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_ATOM_2 " + (this.at2.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_RES_STR " + (this.unit.getSelectedIndex() + 1) + sep, sB);
                bl2 = n == 9 || n == 10;
                break;
            }
            case 7: {
                bl = n == 8;
                this.appendToFile("GLOBAL I_d_NBO_1 " + (this.nbo1.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_d_NBO_2 " + (this.nbo2.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_UNIT " + (this.unit.getSelectedIndex() + 1) + sep, sB);
                break;
            }
            case 8: {
                bl = n == 9 || n == 8;
                this.appendToFile("GLOBAL I_CMO " + (this.nbo1.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_NBO " + (this.nbo2.getSelectedIndex() + 1) + sep, sB);
                break;
            }
            case 9: {
                this.appendToFile("GLOBAL I_UNIT " + (this.unit.getSelectedIndex() + 1) + sep, sB);
                break;
            }
            case 10: {
                this.appendToFile("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_OPERATOR " + this.operator + sep, sB);
                this.appendToFile("GLOBAL I_ROW " + (this.row.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_COLUMN " + (this.col.getSelectedIndex() + 1) + sep, sB);
                break;
            }
            case 11: {
                this.appendToFile("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_BAS_2 " + (this.bas2.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_ROW " + (this.row.getSelectedIndex() + 1) + sep, sB);
                this.appendToFile("GLOBAL I_COLUMN " + (this.col.getSelectedIndex() + 1) + sep, sB);
            }
        }
        if (this.viewAll != null) {
            if (this.viewAll.isSelected()) {
                if (this.keyProp.equals("NPA") && n <= 9 || n <= 4) {
                    this.appendToFile("GLOBAL I_OPT_" + this.keyProp + " " + n + "*", sB);
                } else {
                    this.appendToFile("GLOBAL I_OPT_" + this.keyProp + " " + n, sB);
                }
            } else {
                this.appendToFile("GLOBAL I_OPT_" + this.keyProp + " " + n, sB);
            }
        } else {
            this.appendToFile("GLOBAL I_OPT_" + this.keyProp + " " + n, sB);
        }
        if (bl) {
            this.nboService.queueJob("search", "Raytracing, please be patient...", new Runnable(){

                @Override
                public void run() {
                    File file = new File(new File(NBODialogSearch.this.nboService.serverPath).getParent() + "\\pic.bmp");
                    if (file.exists()) {
                        file.delete();
                    }
                    System.out.println("-----" + file.toString());
                    NBODialogSearch.this.nboService.rawCmdNew("s", sB, false, 88);
                    while (!file.exists()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                    try {
                        NBODialogSearch.this.nboService.runScriptQueued("image id pic close; image id pic \"" + file.toString().replaceAll("\\\\", "\\\\\\\\") + "\"");
                        NBODialogSearch.this.statusLab.setText("");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        } else if (bl2) {
            this.nboService.queueJob("search", "getting list...", new Runnable(){

                @Override
                public void run() {
                    NBODialogSearch.this.reqInfo = "";
                    NBODialogSearch.this.nboService.rawCmdNew("s", sB, false, 46);
                    while (NBODialogSearch.this.reqInfo.trim().split(" |\\n").length < NBODialogSearch.this.jmolAtomCount) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                    try {
                        NBODialogSearch.this.labelAt();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        } else if (bl3) {
            this.nboService.runScriptQueued("select {*}; show drawing");
        } else {
            this.nboService.queueJob("search", "getting value...", new Runnable(){

                @Override
                public void run() {
                    NBODialogSearch.this.reqInfo = "";
                    NBODialogSearch.this.nboService.rawCmdNew("s", sB, false, 45);
                    NBODialogSearch.this.appendOutputWithCaret("  " + NBODialogSearch.this.reqInfo);
                }
            });
        }
    }

    protected void notifyCallbackS(int n) {
        if (this.at1 != null && this.at2 == null) {
            this.at1.setSelectedIndex(n);
        } else if (this.at1 != null && this.at2 != null) {
            if (this.secondPick) {
                this.at1.setSelectedIndex(n);
                this.secondPick = false;
            } else {
                this.at2.setSelectedIndex(n);
                this.secondPick = true;
            }
        }
    }

    protected void rawInputS(String string) {
        if (string.startsWith("O ")) {
            try {
                int n = Integer.parseInt(string.split(" ")[1]);
                this.orb.setSelectedIndex(n - 1);
            }
            catch (Exception exception) {
                this.appendOutputWithCaret("Invalid command");
            }
        } else if (string.startsWith("A ")) {
            try {
                int n = Integer.parseInt(string.split(" ")[1]);
                this.at1.setSelectedIndex(n - 1);
            }
            catch (Exception exception) {
                this.appendOutputWithCaret("Invalid command");
            }
        }
    }
}

