/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapecgo;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.java.BS;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapecgo.CGOMesh;

public class CGO
extends MeshCollection {
    CGOMesh[] cmeshes = new CGOMesh[4];
    private CGOMesh cgoMesh;
    private boolean useColix;
    private float newScale;
    private int indicatedModelIndex = Integer.MIN_VALUE;

    public CGO() {
        this.myType = "CGO";
        this.htObjects = new Hashtable();
    }

    private void initCGO() {
        this.indicatedModelIndex = Integer.MIN_VALUE;
    }

    @Override
    public void allocMesh(String string, Mesh mesh) {
        int n = this.meshCount++;
        this.cmeshes = (CGOMesh[])AU.ensureLength(this.cmeshes, this.meshCount * 2);
        this.meshes = this.cmeshes;
        this.cmeshes[n] = mesh == null ? new CGOMesh(this.vwr, string, this.colix, n) : (CGOMesh)mesh;
        this.cgoMesh = this.cmeshes[n];
        this.currentMesh = this.cmeshes[n];
        this.currentMesh.color = this.color;
        this.currentMesh.index = n;
        this.currentMesh.useColix = this.useColix;
        this.currentMesh.modelIndex = this.indicatedModelIndex;
        if (string != null && string != "+PREVIOUS_MESH+" && this.htObjects != null) {
            this.htObjects.put(string.toUpperCase(), this.currentMesh);
        }
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        if ("init" == string) {
            this.initCGO();
            this.setPropertySuper("init", object, bS);
            return;
        }
        if ("setCGO" == string) {
            Lst lst = (Lst)object;
            this.setProperty("init", null, null);
            int n = lst.size() - 1;
            this.setProperty("thisID", lst.get(n), null);
            string = "set";
            this.setProperty("set", object, null);
            return;
        }
        if ("modelIndex" == string) {
            this.indicatedModelIndex = Math.max((Integer)object, -1);
            return;
        }
        if ("set" == string) {
            if (this.cgoMesh == null) {
                this.allocMesh(null, null);
                this.cgoMesh.colix = this.colix;
                this.cgoMesh.color = this.color;
                this.cgoMesh.useColix = this.useColix;
            }
            this.cgoMesh.modelIndex = this.indicatedModelIndex == Integer.MIN_VALUE ? this.vwr.am.cmi : this.indicatedModelIndex;
            this.cgoMesh.isValid = this.setCGO((Lst)object);
            if (this.cgoMesh.isValid) {
                this.scale(this.cgoMesh, this.newScale);
                this.cgoMesh.initialize(1073741964, null, null);
                this.cgoMesh.title = this.title;
                this.cgoMesh.visible = true;
            }
            this.clean();
            return;
        }
        if (string == "deleteModelAtoms") {
            this.deleteModels(((int[])((Object[])object)[2])[0]);
            return;
        }
        this.setPropertySuper(string, object, bS);
    }

    protected void deleteModels(int n) {
        int n2 = this.meshCount;
        while (--n2 >= 0) {
            boolean bl;
            CGOMesh cGOMesh = (CGOMesh)this.meshes[n2];
            if (cGOMesh == null) continue;
            boolean bl2 = bl = cGOMesh.modelIndex == n;
            if (bl) {
                --this.meshCount;
                this.deleteMeshElement(n2);
                continue;
            }
            if (this.meshes[n2].modelIndex <= n) continue;
            --this.meshes[n2].modelIndex;
        }
        this.resetObjects();
    }

    @Override
    public Object getProperty(String string, int n) {
        if (string == "command") {
            return this.getCommand(this.cgoMesh);
        }
        return this.getPropMC(string, n);
    }

    @Override
    public boolean getPropertyData(String string, Object[] objectArray) {
        if (string == "data") {
            return CGOMesh.getData(objectArray);
        }
        return this.getPropDataMC(string, objectArray);
    }

    private void deleteMeshElement(int n) {
        if (this.meshes[n] == this.currentMesh) {
            this.cgoMesh = null;
            this.currentMesh = null;
        }
        this.cmeshes = (CGOMesh[])AU.deleteElements(this.meshes, n, 1);
        this.meshes = this.cmeshes;
    }

    private void setPropertySuper(String string, Object object, BS bS) {
        this.currentMesh = this.cgoMesh;
        this.setPropMC(string, object, bS);
        this.cgoMesh = (CGOMesh)this.currentMesh;
    }

    @Override
    protected void clean() {
        int n = this.meshCount;
        while (--n >= 0) {
            if (this.meshes[n] != null && this.cmeshes[n].cmds != null && this.cmeshes[n].cmds.size() != 0) continue;
            this.deleteMeshI(n);
        }
    }

    private boolean setCGO(Lst<Object> lst) {
        if (this.cgoMesh == null) {
            this.allocMesh(null, null);
        }
        this.cgoMesh.clear("cgo");
        return this.cgoMesh.set(lst);
    }

    private void scale(Mesh mesh, float f) {
    }

    @Override
    public Lst<Map<String, Object>> getShapeDetail() {
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        for (int i = 0; i < this.meshCount; ++i) {
            CGOMesh cGOMesh = this.cmeshes[i];
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("visible", cGOMesh.visible ? Boolean.TRUE : Boolean.FALSE);
            hashtable.put("ID", cGOMesh.thisID == null ? "<noid>" : cGOMesh.thisID);
            hashtable.put("command", this.getCommand(cGOMesh));
            lst.addLast((Map<String, Object>)hashtable);
        }
        return lst;
    }

    @Override
    public String getShapeState() {
        SB sB = new SB();
        int n = this.vwr.ms.mc;
        for (int i = 0; i < this.meshCount; ++i) {
            CGOMesh cGOMesh = this.cmeshes[i];
            if (cGOMesh == null || cGOMesh.cmds == null || cGOMesh.modelIndex >= n) continue;
            if (sB.length() == 0) {
                sB.append("\n");
                CGO.appendCmd(sB, this.myType + " delete");
            }
            sB.append(this.getCommand2(cGOMesh, n));
            if (cGOMesh.visible) continue;
            sB.append(" " + this.myType + " ID " + PT.esc(cGOMesh.thisID) + " off;\n");
        }
        return sB.toString();
    }

    private String getCommand(Mesh mesh) {
        if (mesh != null) {
            return this.getCommand2(mesh, mesh.modelIndex);
        }
        SB sB = new SB();
        String string = this.explicitID && this.previousMeshID != null && PT.isWild(this.previousMeshID) ? this.previousMeshID : null;
        Lst<Mesh> lst = this.getMeshList(string, false);
        int n = lst.size();
        while (--n >= 0) {
            Mesh mesh2 = (Mesh)lst.get(n);
            sB.append(this.getCommand2(mesh2, mesh2.modelIndex));
        }
        return sB.toString();
    }

    private String getCommand2(Mesh mesh, int n) {
        CGOMesh cGOMesh = (CGOMesh)mesh;
        SB sB = new SB();
        int n2 = mesh.modelIndex;
        sB.append("  CGO ID ").append(PT.esc(mesh.thisID));
        if (n2 >= -1 && n > 1) {
            sB.append(" modelIndex " + n2);
        }
        sB.append(" [");
        int n3 = cGOMesh.cmds.size();
        for (int i = 0; i < n3; ++i) {
            sB.append(" " + cGOMesh.cmds.get(i));
        }
        sB.append(" ];\n");
        CGO.appendCmd(sB, cGOMesh.getState("cgo"));
        if (cGOMesh.useColix) {
            CGO.appendCmd(sB, CGO.getColorCommandUnk("cgo", cGOMesh.colix, this.translucentAllowed));
        }
        return sB.toString();
    }

    @Override
    public void setModelVisibilityFlags(BS bS) {
        for (int i = 0; i < this.meshCount; ++i) {
            CGOMesh cGOMesh = this.cmeshes[i];
            if (cGOMesh == null) continue;
            cGOMesh.visibilityFlags = cGOMesh.isValid && cGOMesh.visible && (cGOMesh.modelIndex < 0 || bS.get(cGOMesh.modelIndex)) ? this.vf : 0;
        }
    }
}

