/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

class SymmetryOperation
extends M4 {
    String xyzOriginal;
    String xyz;
    private boolean doNormalize = true;
    boolean isFinalized;
    private int opId;
    V3 centering;
    private P3 atomTest;
    private String[] myLabels;
    int modDim;
    float[] linearRotTrans;
    Matrix rsvs;
    boolean isBio;
    private Matrix sigma;
    int index;
    String subsystemCode;
    int timeReversal;
    private static final String[] twelfths = new String[]{"0", "1/12", "1/6", "1/4", "1/3", "5/12", "1/2", "7/12", "2/3", "3/4", "5/6", "11/12"};
    static final String[] labelsXYZ = new String[]{"x", "y", "z"};
    static final String[] labelsXn = new String[]{"x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13"};
    static final String[] labelsXnSub = new String[]{"x", "y", "z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};
    private boolean unCentered;
    boolean isCenteringOp;
    private float magOp = Float.MAX_VALUE;

    void setSigma(String string, Matrix matrix) {
        this.subsystemCode = string;
        this.sigma = matrix;
    }

    SymmetryOperation(SymmetryOperation symmetryOperation, P3[] p3Array, int n, int n2, boolean bl) {
        this.doNormalize = bl;
        if (symmetryOperation == null) {
            this.opId = n2;
            return;
        }
        this.xyzOriginal = symmetryOperation.xyzOriginal;
        this.xyz = symmetryOperation.xyz;
        this.opId = symmetryOperation.opId;
        this.modDim = symmetryOperation.modDim;
        this.myLabels = symmetryOperation.myLabels;
        this.index = symmetryOperation.index;
        this.linearRotTrans = symmetryOperation.linearRotTrans;
        this.sigma = symmetryOperation.sigma;
        this.subsystemCode = symmetryOperation.subsystemCode;
        this.timeReversal = symmetryOperation.timeReversal;
        this.setMatrix(false);
        if (!symmetryOperation.isFinalized) {
            this.doFinalize();
        }
        if (bl && this.sigma == null) {
            this.setOffset(p3Array, n, n2);
        }
    }

    private void setGamma(boolean bl) {
        int n;
        int n2;
        int n3 = 3 + this.modDim;
        this.rsvs = new Matrix(null, n3 + 1, n3 + 1);
        double[][] dArray = this.rsvs.getArray();
        double[] dArray2 = new double[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray[n2][n] = this.linearRotTrans[n4++];
            }
            dArray2[n2] = (float)(bl ? -1 : 1) * this.linearRotTrans[n4++];
        }
        dArray[n3][n3] = 1.0;
        if (bl) {
            this.rsvs = this.rsvs.inverse();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2][n3] = dArray2[n2];
        }
        dArray = this.rsvs.getSubmatrix(0, 0, 3, 3).getArray();
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.setElement(n2, n, (float)(n < 3 ? dArray[n2][n] : dArray2[n2]));
            }
        }
        this.setElement(3, 3, 1.0f);
    }

    void doFinalize() {
        this.m03 /= 12.0f;
        this.m13 /= 12.0f;
        this.m23 /= 12.0f;
        if (this.modDim > 0) {
            double[][] dArray = this.rsvs.getArray();
            int n = dArray.length - 1;
            while (--n >= 0) {
                double[] dArray2 = dArray[n];
                int n2 = 3 + this.modDim;
                dArray2[n2] = dArray2[n2] / 12.0;
            }
        }
        this.isFinalized = true;
    }

    String getXyz(boolean bl) {
        return bl && this.modDim == 0 || this.xyzOriginal == null ? this.xyz : this.xyzOriginal;
    }

    void newPoint(P3 p3, P3 p32, int n, int n2, int n3) {
        this.rotTrans2(p3, p32);
        p32.add3(n, n2, n3);
    }

    String dumpInfo() {
        return "\n" + this.xyz + "\ninternal matrix representation:\n" + this.toString();
    }

    static final String dumpSeitz(M4 m4, boolean bl) {
        SB sB = new SB();
        float[] fArray = new float[4];
        for (int i = 0; i < 3; ++i) {
            m4.getRow(i, fArray);
            sB.append("[\t");
            for (int j = 0; j < 3; ++j) {
                sB.appendI((int)fArray[j]).append("\t");
            }
            float f = fArray[3];
            if (f != (float)((int)f)) {
                f = 12.0f * f;
            }
            sB.append(SymmetryOperation.twelfthsOf(bl ? (float)(((int)f + 12) % 12) : (float)((int)f))).append("\t]\n");
        }
        return sB.toString();
    }

    boolean setMatrixFromXYZ(String string, int n, boolean bl) {
        String string2;
        if (string == null) {
            return false;
        }
        this.xyzOriginal = string;
        string = string.toLowerCase();
        this.setModDim(n);
        boolean bl2 = string.startsWith("!");
        if (bl2) {
            string = string.substring(1);
        }
        if (string.indexOf("xyz matrix:") == 0) {
            this.xyz = string;
            Parser.parseStringInfestedFloatArray(string, null, this.linearRotTrans);
            return this.setFromMatrix(null, bl2);
        }
        if (string.indexOf("[[") == 0) {
            string = string.replace('[', ' ').replace(']', ' ').replace(',', ' ');
            Parser.parseStringInfestedFloatArray(string, null, this.linearRotTrans);
            int n2 = this.linearRotTrans.length;
            while (--n2 >= 0) {
                if (!Float.isNaN(this.linearRotTrans[n2])) continue;
                return false;
            }
            this.setMatrix(bl2);
            this.isFinalized = true;
            this.isBio = string.indexOf("bio") >= 0;
            this.xyz = this.isBio ? this.toString() : SymmetryOperation.getXYZFromMatrix(this, false, false, false);
            return true;
        }
        if (n == 0 && string.indexOf("x4") >= 0) {
            int n3 = 14;
            while (--n3 >= 4) {
                if (string.indexOf("x" + n3) < 0) continue;
                this.setModDim(n3 - 3);
                break;
            }
        }
        if (string.endsWith("m")) {
            this.timeReversal = string.indexOf("-m") >= 0 ? -1 : 1;
            bl = true;
        }
        if ((string2 = SymmetryOperation.getMatrixFromString(this, string, this.linearRotTrans, bl)) == null) {
            return false;
        }
        this.setMatrix(bl2);
        String string3 = this.xyz = bl2 ? SymmetryOperation.getXYZFromMatrix(this, true, false, false) : string2;
        if (this.timeReversal != 0) {
            this.xyz = this.xyz + (this.timeReversal == 1 ? ",m" : ",-m");
        }
        if (Logger.debugging) {
            Logger.debug("" + this);
        }
        return true;
    }

    private void setModDim(int n) {
        int n2 = (n + 4) * (n + 4);
        this.modDim = n;
        if (n > 0) {
            this.myLabels = labelsXn;
        }
        this.linearRotTrans = new float[n2];
    }

    private void setMatrix(boolean bl) {
        if (this.linearRotTrans.length > 16) {
            this.setGamma(bl);
        } else {
            this.setA(this.linearRotTrans);
            if (bl) {
                P3 p3 = P3.new3(this.m03, this.m13, this.m23);
                this.invert();
                this.rotate(p3);
                p3.scale(-1.0f);
                this.setTranslation(p3);
            }
        }
    }

    boolean setFromMatrix(float[] fArray, boolean bl) {
        float f = 0.0f;
        int n = 0;
        this.myLabels = this.modDim == 0 ? labelsXYZ : labelsXn;
        int n2 = 0;
        int n3 = 3 + this.modDim;
        int n4 = 0;
        while (n2 < n3) {
            boolean bl2;
            if (Float.isNaN(this.linearRotTrans[n4])) {
                return false;
            }
            f = this.linearRotTrans[n4];
            if (Math.abs(f) < 1.0E-5f) {
                f = 0.0f;
            }
            boolean bl3 = bl2 = (n4 + 1) % (n3 + 1) == 0;
            if (bl2) {
                if (fArray != null) {
                    f /= 12.0f;
                    if (n < fArray.length) {
                        f += fArray[n++];
                    }
                }
                f = SymmetryOperation.normalizeTwelfths((float)(f < 0.0f ? -1 : 1) * Math.abs(f * 12.0f) / 12.0f, this.doNormalize);
                ++n2;
            }
            this.linearRotTrans[n4] = f;
            ++n4;
        }
        this.linearRotTrans[this.linearRotTrans.length - 1] = 1.0f;
        this.setMatrix(bl);
        this.isFinalized = fArray == null;
        this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
        return true;
    }

    static String getMatrixFromString(SymmetryOperation symmetryOperation, String string, float[] fArray, boolean bl) {
        String[] stringArray;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = symmetryOperation == null ? 0 : symmetryOperation.modDim;
        int n2 = 4 + n;
        boolean bl5 = symmetryOperation != null && symmetryOperation.doNormalize;
        int n3 = n > 0 ? 3 : 0;
        fArray[fArray.length - 1] = 1.0f;
        int n4 = string.indexOf(59) + 1;
        if (n4 != 0) {
            bl = true;
            if (n4 == string.length()) {
                string = string + "0,0,0";
            }
        }
        int n5 = -1;
        String[] stringArray2 = stringArray = symmetryOperation == null || n == 0 ? null : symmetryOperation.myLabels;
        if (stringArray == null) {
            stringArray = labelsXYZ;
        }
        string = string.toLowerCase() + ",";
        if (n > 0) {
            string = SymmetryOperation.replaceXn(string, n + 3);
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        float f = 0.0f;
        float f2 = 1.0f;
        String string2 = "";
        String string3 = "";
        block11: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ';': {
                    break;
                }
                case ' ': 
                case '!': 
                case '\'': 
                case '{': 
                case '}': {
                    continue block11;
                }
                case '-': {
                    bl4 = true;
                    continue block11;
                }
                case '+': {
                    bl4 = false;
                    continue block11;
                }
                case '/': {
                    bl2 = true;
                    continue block11;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'x': 
                case 'y': 
                case 'z': {
                    int n9;
                    n7 = n8 * n2;
                    int n10 = c >= 'x' ? c - 120 : c - 97 + n3;
                    n6 = n7 + n10;
                    int n11 = n9 = bl4 ? -1 : 1;
                    if (bl && f != 0.0f) {
                        fArray[n6] = f;
                        n9 = (int)f;
                        f = 0.0f;
                    } else {
                        fArray[n6] = n9;
                    }
                    string2 = string2 + SymmetryOperation.plusMinus(string2, n9, stringArray[n10]);
                    break;
                }
                case ',': {
                    if (n4 != 0) {
                        if (n4 > 0) {
                            n5 = i;
                            i = n4 - 1;
                            n4 = -i;
                            f = 0.0f;
                            continue block11;
                        }
                        n4 = i + 1;
                        i = n5;
                    }
                    fArray[n7 + n2 - 1] = f = SymmetryOperation.normalizeTwelfths(f, bl5);
                    string2 = string2 + SymmetryOperation.xyzFraction(f, false, true);
                    string3 = string3 + (string3 == "" ? "" : ",") + string2;
                    if (n8 == n2 - 2) {
                        return string3;
                    }
                    f = 0.0f;
                    string2 = "";
                    if (n8++ <= 2 || n != 0) break;
                    Logger.warn("Symmetry Operation? " + string);
                    return null;
                }
                case '.': {
                    bl3 = true;
                    f2 = 1.0f;
                    continue block11;
                }
                case '0': {
                    if (!bl3 && (bl2 || !bl)) continue block11;
                }
                default: {
                    int n12 = c - 48;
                    if (bl3 && n12 >= 0 && n12 <= 9) {
                        f2 /= 10.0f;
                        if (f < 0.0f) {
                            bl4 = true;
                        }
                        f += f2 * (float)n12 * (float)(bl4 ? -1 : 1);
                        continue block11;
                    }
                    if (n12 >= 0 && n12 <= 9) {
                        if (bl2) {
                            if (f == 0.0f) {
                                int n13 = n6;
                                fArray[n13] = fArray[n13] / (float)n12;
                                break;
                            }
                            f /= (float)n12;
                            break;
                        }
                        f = f * 10.0f + (float)((bl4 ? -1 : 1) * n12);
                        bl4 = false;
                        break;
                    }
                    Logger.warn("symmetry character?" + c);
                }
            }
            bl4 = false;
            bl2 = false;
            bl3 = false;
        }
        return null;
    }

    static String replaceXn(String string, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            string = PT.rep(string, labelsXn[n2], labelsXnSub[n2]);
        }
        return string;
    }

    private static final String xyzFraction(float f, boolean bl, boolean bl2) {
        String string;
        float f2;
        block4: {
            block3: {
                if (!bl) break block3;
                for (f2 = f; f2 < 0.0f; f2 += 12.0f) {
                }
                break block4;
            }
            if (!bl2) break block4;
            while (f2 > 6.0f) {
                f2 -= 12.0f;
            }
            while (f2 < -6.0f) {
                f2 += 12.0f;
            }
        }
        return (string = SymmetryOperation.twelfthsOf(f2)).charAt(0) == '0' ? "" : (f2 > 0.0f ? "+" + string : string);
    }

    private static final String twelfthsOf(float f) {
        String string = "";
        if (f < 0.0f) {
            f = -f;
            string = "-";
        }
        int n = 12;
        int n2 = Math.round(f);
        if (Math.abs((float)n2 - f) > 0.01f) {
            float f2;
            float f3 = f / 12.0f;
            int n3 = 20;
            for (n = 5; n < n3 && !(Math.abs((float)(n2 = Math.round(f2 = f3 * (float)n)) - f2) < 0.01f); ++n) {
            }
            if (n == n3) {
                return string + f3;
            }
        } else {
            if (n2 == 12) {
                return string + "1";
            }
            if (n2 < 12) {
                return string + twelfths[n2 % 12];
            }
            switch (n2 % 12) {
                case 0: {
                    return "" + n2 / 12;
                }
                case 2: 
                case 10: {
                    n = 6;
                    break;
                }
                case 3: 
                case 9: {
                    n = 4;
                    break;
                }
                case 4: 
                case 8: {
                    n = 3;
                    break;
                }
                case 6: {
                    n = 2;
                    break;
                }
            }
            n2 = n2 * n / 12;
        }
        return string + n2 + "/" + n;
    }

    private static String plusMinus(String string, float f, String string2) {
        return f == 0.0f ? "" : (f < 0.0f ? "-" : (string.length() == 0 ? "" : "+")) + (f == 1.0f || f == -1.0f ? "" : "" + (int)Math.abs(f)) + string2;
    }

    private static float normalizeTwelfths(float f, boolean bl) {
        f *= 12.0f;
        if (bl) {
            while (f > 6.0f) {
                f -= 12.0f;
            }
            while (f <= -6.0f) {
                f += 12.0f;
            }
        }
        return f;
    }

    static final String getXYZFromMatrix(M4 m4, boolean bl, boolean bl2, boolean bl3) {
        SymmetryOperation symmetryOperation;
        String string = "";
        SymmetryOperation symmetryOperation2 = symmetryOperation = m4 instanceof SymmetryOperation ? (SymmetryOperation)m4 : null;
        if (symmetryOperation != null && symmetryOperation.modDim > 0) {
            return SymmetryOperation.getXYZFromRsVs(symmetryOperation.rsvs.getRotation(), symmetryOperation.rsvs.getTranslation(), bl);
        }
        float[] fArray = new float[4];
        for (int i = 0; i < 3; ++i) {
            int n = i < 3 ? 0 : 3;
            m4.getRow(i, fArray);
            String string2 = "";
            for (int j = 0; j < 3; ++j) {
                if (fArray[j] == 0.0f) continue;
                string2 = string2 + SymmetryOperation.plusMinus(string2, fArray[j], labelsXYZ[j + n]);
            }
            string2 = string2 + SymmetryOperation.xyzFraction(bl ? fArray[3] : fArray[3] * 12.0f, bl2, bl3);
            string = string + "," + string2;
        }
        return string.substring(1);
    }

    private void setOffset(P3[] p3Array, int n, int n2) {
        int n3 = n;
        int n4 = n3 + n2;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.atomTest == null) {
            this.atomTest = new P3();
        }
        for (int i = n3; i < n4; ++i) {
            this.newPoint(p3Array[i], this.atomTest, 0, 0, 0);
            f += this.atomTest.x;
            f2 += this.atomTest.y;
            f3 += this.atomTest.z;
        }
        while ((double)f < -0.001 || (double)f >= (double)n2 + 0.001) {
            this.m03 += (float)(f < 0.0f ? 1 : -1);
            f += (float)(f < 0.0f ? n2 : -n2);
        }
        while ((double)f2 < -0.001 || (double)f2 >= (double)n2 + 0.001) {
            this.m13 += (float)(f2 < 0.0f ? 1 : -1);
            f2 += (float)(f2 < 0.0f ? n2 : -n2);
        }
        while ((double)f3 < -0.001 || (double)f3 >= (double)n2 + 0.001) {
            this.m23 += (float)(f3 < 0.0f ? 1 : -1);
            f3 += (float)(f3 < 0.0f ? n2 : -n2);
        }
    }

    V3[] rotateAxes(V3[] v3Array, UnitCell unitCell, P3 p3, M3 m3) {
        V3[] v3Array2 = new V3[3];
        this.getRotationScale(m3);
        int n = v3Array.length;
        while (--n >= 0) {
            p3.setT(v3Array[n]);
            unitCell.toFractional(p3, true);
            m3.rotate(p3);
            unitCell.toCartesian(p3, true);
            v3Array2[n] = V3.newV(p3);
        }
        return v3Array2;
    }

    static String fcoord(T3 t3) {
        return SymmetryOperation.fc(t3.x) + " " + SymmetryOperation.fc(t3.y) + " " + SymmetryOperation.fc(t3.z);
    }

    private static String fc(float f) {
        String string;
        float f2 = Math.abs(f);
        int n = (int)SymmetryOperation.approxF(f2 * 24.0f);
        String string2 = string = f < 0.0f ? "-" : "";
        if (n % 8 != 0) {
            return string + SymmetryOperation.twelfthsOf(n >> 1);
        }
        return n == 0 ? "0" : (n == 24 ? string + "1" : string + n / 8 + "/3");
    }

    static float approxF(float f) {
        return PT.approx(f, 100.0f);
    }

    static String getXYZFromRsVs(Matrix matrix, Matrix matrix2, boolean bl) {
        double[][] dArray = matrix.getArray();
        double[][] dArray2 = matrix2.getArray();
        int n = dArray.length;
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + ",";
            for (int j = 0; j < n; ++j) {
                double d = dArray[i][j];
                if (d == 0.0) continue;
                string = string + (d < 0.0 ? "-" : (string.endsWith(",") ? "" : "+")) + (Math.abs(d) == 1.0 ? "" : "" + (int)Math.abs(d)) + "x" + (j + 1);
            }
            string = string + SymmetryOperation.xyzFraction((int)(dArray2[i][0] * (double)(bl ? 1 : 12)), false, true);
        }
        return PT.rep(string.substring(1), ",+", ",");
    }

    @Override
    public String toString() {
        return this.rsvs == null ? super.toString() : super.toString() + " " + this.rsvs.toString();
    }

    float getSpinOp() {
        if (this.magOp == Float.MAX_VALUE) {
            this.magOp = this.determinant3() * (float)this.timeReversal;
        }
        return this.magOp;
    }

    void setTimeReversal(int n) {
        this.timeReversal = n;
        if (this.xyz.indexOf("m") >= 0) {
            this.xyz = this.xyz.substring(0, this.xyz.indexOf("m"));
        }
        this.xyz = this.xyz + (n == 1 ? ",m" : (n == -1 ? ",-m" : ""));
    }

    static String getPrettyMatrix(SB sB, M4 m4) {
        sB.append("[ ");
        float[] fArray = new float[4];
        for (int i = 0; i < 3; ++i) {
            m4.getRow(i, fArray);
            sB.append("[ ").appendI((int)fArray[0]).appendC(' ').appendI((int)fArray[1]).appendC(' ').appendI((int)fArray[2]).appendC(' ');
            sB.append(SymmetryOperation.twelfthsOf(fArray[3] * 12.0f)).append(" ]");
        }
        return sB.append(" ]").toString();
    }

    V3 setCentering(V3 v3, boolean bl) {
        if (this.centering == null && !this.unCentered) {
            if (this.modDim == 0 && this.index > 1 && this.m00 == 1.0f && this.m11 == 1.0f && this.m22 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m12 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f) {
                this.centering = V3.new3(this.m03, this.m13, this.m23);
                if (this.centering.lengthSquared() == 0.0f) {
                    this.unCentered = true;
                    this.centering = null;
                } else if (!bl) {
                    this.centering.scale(0.083333336f);
                }
                this.isCenteringOp = true;
            } else {
                this.centering = v3;
            }
        }
        return this.centering;
    }
}

