/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.data.preferences.Setting;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTagCheckerRulesPreference;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.bugreport.BugReportSender;
import org.openstreetmap.josm.tools.bugreport.DebugTextDisplay;

public final class ShowStatusReportAction
extends JosmAction {
    public ShowStatusReportAction() {
        super(I18n.tr("Show Status Report", new Object[0]), "clock", I18n.tr("Show status report with useful information that can be attached to bugs", new Object[0]), Shortcut.registerShortcut("help:showstatusreport", I18n.tr("Help: {0}", I18n.tr("Show Status Report", new Object[0])), 65535, 5000), false);
        this.putValue("help", HelpUtil.ht("/Action/ShowStatusReport"));
        this.putValue("toolbar", "help/showstatusreport");
        Main.toolbar.register(this);
    }

    private static boolean isRunningJavaWebStart() {
        try {
            return Class.forName("javax.jnlp.ServiceManager") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static String getReportHeader() {
        String string;
        Object object;
        Object object2;
        StringBuilder stringBuilder;
        block13: {
            stringBuilder = new StringBuilder();
            String string2 = System.getProperty("java.runtime.version");
            stringBuilder.append(Version.getInstance().getReleaseAttributes()).append("\nIdentification: ").append(Version.getInstance().getAgentString()).append("\nMemory Usage: ").append(Runtime.getRuntime().totalMemory() / 1024L / 1024L).append(" MB / ").append(Runtime.getRuntime().maxMemory() / 1024L / 1024L).append(" MB (").append(Runtime.getRuntime().freeMemory() / 1024L / 1024L).append(" MB allocated, but free)\nJava version: ").append(string2 != null ? string2 : System.getProperty("java.version")).append(", ").append(System.getProperty("java.vendor")).append(", ").append(System.getProperty("java.vm.name")).append('\n');
            if (Main.platform.getClass() == PlatformHookUnixoid.class) {
                object2 = ((PlatformHookUnixoid)Main.platform).getJavaPackageDetails();
                if (object2 != null) {
                    stringBuilder.append("Java package: ").append((String)object2).append('\n');
                }
                if (ShowStatusReportAction.isRunningJavaWebStart() && (object = ((PlatformHookUnixoid)Main.platform).getWebStartPackageDetails()) != null) {
                    stringBuilder.append("WebStart package: ").append((String)object).append('\n');
                }
            }
            try {
                object2 = new ArrayList<String>(ManagementFactory.getRuntimeMXBean().getInputArguments());
                object = object2.listIterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    if (string.contains("=")) {
                        String[] stringArray = string.split("=");
                        if (stringArray[0].toLowerCase(Locale.ENGLISH).startsWith("-dproxy")) {
                            object.set(stringArray[0] + "=xxx");
                            continue;
                        }
                        String string3 = ShowStatusReportAction.paramCleanup(stringArray[1]);
                        if (string3.equals(stringArray[1])) continue;
                        object.set(stringArray[0] + '=' + string3);
                        continue;
                    }
                    if (!string.startsWith("-X")) continue;
                    object.remove();
                }
                if (!object2.isEmpty()) {
                    stringBuilder.append("VM arguments: ").append(object2.toString().replace("\\\\", "\\")).append('\n');
                }
            }
            catch (SecurityException securityException) {
                if (!Main.isTraceEnabled()) break block13;
                Main.trace(securityException.getMessage());
            }
        }
        object2 = Main.getCommandLineArgs();
        if (!object2.isEmpty()) {
            stringBuilder.append("Program arguments: ").append(Arrays.toString(ShowStatusReportAction.paramCleanup(object2).toArray())).append('\n');
        }
        if (Main.main != null && (object = Main.main.getCurrentDataSet()) != null) {
            string = DatasetConsistencyTest.runTests((DataSet)object);
            if (string.isEmpty()) {
                stringBuilder.append("Dataset consistency test: No problems found\n");
            } else {
                stringBuilder.append("\nDataset consistency test:\n").append(string).append('\n');
            }
        }
        stringBuilder.append('\n').append(PluginHandler.getBugReportText()).append('\n');
        ShowStatusReportAction.appendCollection(stringBuilder, "Tagging presets", ShowStatusReportAction.getCustomUrls(TaggingPresetPreference.PresetPrefHelper.INSTANCE));
        ShowStatusReportAction.appendCollection(stringBuilder, "Map paint styles", ShowStatusReportAction.getCustomUrls(MapPaintPreference.MapPaintPrefHelper.INSTANCE));
        ShowStatusReportAction.appendCollection(stringBuilder, "Validator rules", ShowStatusReportAction.getCustomUrls(ValidatorTagCheckerRulesPreference.RulePrefHelper.INSTANCE));
        ShowStatusReportAction.appendCollection(stringBuilder, "Last errors/warnings", Main.getLastErrorAndWarnings());
        return stringBuilder.toString();
    }

    protected static Collection<String> getCustomUrls(SourceEditor.SourcePrefHelper sourcePrefHelper) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (SourceEntry sourceEntry : sourcePrefHelper.get()) {
            treeSet.add(sourceEntry.url);
        }
        for (SourceEditor.ExtendedSourceEntry extendedSourceEntry : sourcePrefHelper.getDefault()) {
            treeSet.remove(extendedSourceEntry.url);
        }
        return treeSet;
    }

    private static List<String> paramCleanup(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (String string : collection) {
            arrayList.add(ShowStatusReportAction.paramCleanup(string));
        }
        return arrayList;
    }

    private static String paramCleanup(String string) {
        String string2 = System.getenv("JAVA_HOME");
        String string3 = Main.isPlatformWindows() ? "%JAVA_HOME%" : "${JAVA_HOME}";
        String string4 = System.getProperty("java.home");
        String string5 = Main.pref.getPreferencesDirectory().toString();
        String string6 = Main.pref.getUserDataDirectory().toString();
        String string7 = Main.pref.getCacheDirectory().toString();
        String string8 = System.getProperty("user.home");
        String string9 = Main.isPlatformWindows() ? "%UserProfile%" : "${HOME}";
        String string10 = string;
        string10 = ShowStatusReportAction.paramReplace(string10, string2, string3);
        string10 = ShowStatusReportAction.paramReplace(string10, string2, string3);
        string10 = ShowStatusReportAction.paramReplace(string10, string4, "<java.home>");
        string10 = ShowStatusReportAction.paramReplace(string10, string5, "<josm.pref>");
        string10 = ShowStatusReportAction.paramReplace(string10, string6, "<josm.userdata>");
        string10 = ShowStatusReportAction.paramReplace(string10, string7, "<josm.cache>");
        string10 = ShowStatusReportAction.paramReplace(string10, string8, string9);
        return string10;
    }

    private static String paramReplace(String string, String string2, String string3) {
        return string2 == null ? string : string.replace(string2, string3);
    }

    protected static <T> void appendCollection(StringBuilder stringBuilder, String string, Collection<T> collection) {
        if (!collection.isEmpty()) {
            stringBuilder.append(string + ":\n");
            for (T t : collection) {
                stringBuilder.append("- ").append(ShowStatusReportAction.paramCleanup(t.toString())).append('\n');
            }
            stringBuilder.append('\n');
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        String string = ShowStatusReportAction.getReportHeader();
        stringBuilder.append(string);
        try {
            object = Main.pref.getAllSettings();
            serializable = new HashSet<String>(object.keySet());
            Iterator<Object> iterator = serializable.iterator();
            while (iterator.hasNext()) {
                String object2 = (String)iterator.next();
                if (!object2.startsWith("marker.show") && !object2.contains("username") && !object2.contains("password") && !object2.contains("access-token")) continue;
                object.remove(object2);
            }
            for (Map.Entry entry : object.entrySet()) {
                stringBuilder.append(ShowStatusReportAction.paramCleanup((String)entry.getKey())).append('=').append(ShowStatusReportAction.paramCleanup(((Setting)entry.getValue()).getValue().toString())).append('\n');
            }
        }
        catch (Exception exception) {
            Main.error(exception);
        }
        object = new DebugTextDisplay(stringBuilder.toString());
        serializable = new ExtendedDialog(Main.parent, I18n.tr("Status Report", new Object[0]), new String[]{I18n.tr("Copy to clipboard and close", new Object[0]), I18n.tr("Report bug", new Object[0]), I18n.tr("Close", new Object[0])});
        ((ExtendedDialog)serializable).setButtonIcons(new String[]{"copy", "bug", "cancel"});
        ((ExtendedDialog)serializable).setContent((Component)object, false);
        ((Window)serializable).setMinimumSize(new Dimension(380, 200));
        ((Component)serializable).setPreferredSize(new Dimension(700, Main.parent.getHeight() - 50));
        switch (((ExtendedDialog)serializable).showDialog().getValue()) {
            case 1: {
                ((DebugTextDisplay)object).copyToClippboard();
                break;
            }
            case 2: {
                BugReportSender.reportBug(string);
            }
        }
    }
}

