/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.Component;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractChangesetDownloadTask;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class ChangesetQueryTask
extends AbstractChangesetDownloadTask {
    private final DownloadTask downloadTask;

    public ChangesetQueryTask(ChangesetQuery changesetQuery) {
        this(Main.parent, changesetQuery);
    }

    public ChangesetQueryTask(Component component, ChangesetQuery changesetQuery) {
        CheckParameterUtil.ensureParameterNotNull(changesetQuery, "query");
        this.downloadTask = new DownloadTask(component, changesetQuery);
        this.setDownloadTask(this.downloadTask);
    }

    class DownloadTask
    extends AbstractChangesetDownloadTask.RunnableDownloadTask {
        private ChangesetQuery query;
        private final OsmServerUserInfoReader userInfoReader;

        DownloadTask(Component component, ChangesetQuery changesetQuery) {
            super(component, I18n.tr("Querying and downloading changesets", new Object[0]));
            this.userInfoReader = new OsmServerUserInfoReader();
            this.query = changesetQuery;
        }

        protected void fullyIdentifyCurrentUser() throws OsmTransferException {
            this.getProgressMonitor().indeterminateSubTask(I18n.tr("Determine user id for current user...", new Object[0]));
            UserInfo userInfo = this.userInfoReader.fetchUserInfo(this.getProgressMonitor().createSubTaskMonitor(1, false));
            JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
            josmUserIdentityManager.setFullyIdentified(josmUserIdentityManager.getUserName(), userInfo);
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
                if (this.query.isRestrictedToPartiallyIdentifiedUser() && josmUserIdentityManager.isCurrentUser(this.query.getUserName())) {
                    if (josmUserIdentityManager.isPartiallyIdentified()) {
                        this.fullyIdentifyCurrentUser();
                    }
                    this.query = this.query.forUser(JosmUserIdentityManager.getInstance().getUserId());
                }
                if (ChangesetQueryTask.this.isCanceled()) {
                    return;
                }
                this.getProgressMonitor().indeterminateSubTask(I18n.tr("Query and download changesets ...", new Object[0]));
                this.downloadedChangesets.addAll(this.reader.queryChangesets(this.query, this.getProgressMonitor().createSubTaskMonitor(0, false)));
            }
            catch (OsmTransferCanceledException osmTransferCanceledException) {
                ChangesetQueryTask.this.setCanceled(true);
            }
            catch (OsmTransferException osmTransferException) {
                if (ChangesetQueryTask.this.isCanceled()) {
                    return;
                }
                this.rememberLastException(osmTransferException);
            }
        }

        @Override
        protected void finish() {
            ChangesetQueryTask.this.rememberDownloadedData(this.downloadedChangesets);
            if (ChangesetQueryTask.this.isCanceled()) {
                return;
            }
            if (this.lastException != null) {
                GuiHelper.runInEDTAndWait(new Runnable(){
                    private final Component parent;
                    {
                        this.parent = DownloadTask.this.progressMonitor != null ? DownloadTask.this.progressMonitor.getWindowParent() : null;
                    }

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(this.parent != null ? this.parent : Main.parent, ExceptionUtil.explainException(DownloadTask.this.lastException), I18n.tr("Errors during download", new Object[0]), 0);
                    }
                });
                return;
            }
            this.updateChangesets();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel() {
            super.cancel();
            DownloadTask downloadTask = this;
            synchronized (downloadTask) {
                if (this.userInfoReader != null) {
                    this.userInfoReader.cancel();
                }
            }
        }
    }
}

