/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.GeoJSONWriter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class GeoJSONExporter
extends FileExporter {
    protected final Projection projection;
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("geojson,json", "geojson", I18n.tr("GeoJSON Files", new Object[0]) + " (*.geojson *.json)");
    public static final ExtensionFileFilter FILE_FILTER_PROJECTED = new ExtensionFileFilter("proj.geojson", "proj.geojson", I18n.tr("Projected GeoJSON Files", new Object[0]) + " (*.proj.geojson)");

    public GeoJSONExporter() {
        this(FILE_FILTER, ProjectionPreference.wgs84.getProjection());
    }

    private GeoJSONExporter(ExtensionFileFilter extensionFileFilter, Projection projection) {
        super(extensionFileFilter);
        this.projection = projection;
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        if (layer instanceof OsmDataLayer) {
            String string = new GeoJSONWriter((OsmDataLayer)layer, Utils.firstNonNull(this.projection, Main.getProjection())).write();
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                bufferedWriter.write(string);
            }
        } else {
            throw new IllegalArgumentException(I18n.tr("Layer ''{0}'' not supported", layer.getClass().toString()));
        }
    }

    public static class CurrentProjection
    extends GeoJSONExporter {
        public CurrentProjection() {
            super(FILE_FILTER_PROJECTED, null);
        }
    }
}

