/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="requiredCapacity", type=RubyNode.class)})
public abstract class ArrayGeneralizeNode
extends RubyNode {
    public ArrayGeneralizeNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeGeneralize(DynamicObject var1, int var2);

    @Specialization(guards={"isNullArray(array)"})
    public DynamicObject generalizeNull(DynamicObject array, int requiredCapacity) {
        Object[] store = new Object[requiredCapacity];
        Layouts.ARRAY.setStore(array, store);
        return array;
    }

    @Specialization(guards={"isIntArray(array)"})
    public DynamicObject generalizeInt(DynamicObject array, int requiredCapacity) {
        int[] store = (int[])Layouts.ARRAY.getStore(array);
        Layouts.ARRAY.setStore(array, ArrayUtils.boxExtra(store, ArrayUtils.capacity(store.length, requiredCapacity) - store.length));
        return array;
    }

    @Specialization(guards={"isLongArray(array)"})
    public DynamicObject generalizeLong(DynamicObject array, int requiredCapacity) {
        long[] store = (long[])Layouts.ARRAY.getStore(array);
        Layouts.ARRAY.setStore(array, ArrayUtils.boxExtra(store, ArrayUtils.capacity(store.length, requiredCapacity) - store.length));
        return array;
    }

    @Specialization(guards={"isDoubleArray(array)"})
    public DynamicObject generalizeDouble(DynamicObject array, int requiredCapacity) {
        double[] store = (double[])Layouts.ARRAY.getStore(array);
        Layouts.ARRAY.setStore(array, ArrayUtils.boxExtra(store, ArrayUtils.capacity(store.length, requiredCapacity) - store.length));
        return array;
    }
}

