/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChildren(value={@NodeChild(value="classToAllocate"), @NodeChild(value="values")})
public abstract class AllocateObjectNode
extends RubyNode {
    private final boolean useCallerFrame;

    public AllocateObjectNode(RubyContext context, SourceSection sourceSection) {
        this(context, sourceSection, true);
    }

    public AllocateObjectNode(RubyContext context, SourceSection sourceSection, boolean useCallerFrame) {
        super(context, sourceSection);
        this.useCallerFrame = useCallerFrame;
    }

    public DynamicObject allocate(DynamicObject classToAllocate, Object ... values) {
        return this.executeAllocateX(classToAllocate, values);
    }

    public DynamicObject allocateHash(DynamicObject classToAllocate, Object store, int size, Entry firstInSequence, Entry lastInSequence, DynamicObject defaultBlock, Object defaultValue, boolean compareByIdentity) {
        return this.allocate(classToAllocate, store, size, firstInSequence, lastInSequence, defaultBlock, defaultValue, compareByIdentity);
    }

    public abstract DynamicObject executeAllocateX(DynamicObject var1, Object[] var2);

    @Specialization(guards={"cachedClassToAllocate == classToAllocate", "!cachedIsSingleton", "!isTracing()"}, assumptions={"getTracingAssumption()"}, limit="getCacheLimit()")
    public DynamicObject allocateCached(DynamicObject classToAllocate, Object[] values, @Cached(value="classToAllocate") DynamicObject cachedClassToAllocate, @Cached(value="isSingleton(classToAllocate)") boolean cachedIsSingleton, @Cached(value="getInstanceFactory(classToAllocate)") DynamicObjectFactory factory) {
        return factory.newInstance(values);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(contains={"allocateCached"}, guards={"!isSingleton(classToAllocate)", "!isTracing()"}, assumptions={"getTracingAssumption()"})
    public DynamicObject allocateUncached(DynamicObject classToAllocate, Object[] values) {
        return this.getInstanceFactory(classToAllocate).newInstance(values);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!isSingleton(classToAllocate)", "isTracing()"}, assumptions={"getTracingAssumption()"})
    public DynamicObject allocateTracing(DynamicObject classToAllocate, Object[] values) {
        Node allocatingNode;
        FrameInstance allocatingFrameInstance;
        DynamicObject object = this.getInstanceFactory(classToAllocate).newInstance(values);
        if (this.useCallerFrame) {
            allocatingFrameInstance = RubyCallStack.getCallerFrame(this.getContext());
            allocatingNode = RubyCallStack.getTopMostUserCallNode();
        } else {
            allocatingFrameInstance = Truffle.getRuntime().getCurrentFrame();
            allocatingNode = this;
        }
        Frame allocatingFrame = allocatingFrameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
        Object allocatingSelf = RubyArguments.getSelf(allocatingFrame.getArguments());
        String allocatingMethod = RubyArguments.getMethod(allocatingFrame.getArguments()).getName();
        SourceSection allocatingSourceSection = allocatingNode.getEncapsulatingSourceSection();
        this.getContext().getObjectSpaceManager().traceAllocation(object, this.string(Layouts.CLASS.getFields(this.getContext().getCoreLibrary().getLogicalClass(allocatingSelf)).getName()), this.getSymbol(allocatingMethod), this.string(allocatingSourceSection.getSource().getName()), allocatingSourceSection.getStartLine());
        return object;
    }

    private DynamicObject string(String value) {
        return this.createString(StringOperations.encodeByteList(value, (Encoding)UTF8Encoding.INSTANCE));
    }

    @Specialization(guards={"isSingleton(classToAllocate)"})
    public DynamicObject allocateSingleton(DynamicObject classToAllocate, Object[] values) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeError("can't create instance of singleton class", this));
    }

    protected Assumption getTracingAssumption() {
        return this.getContext().getObjectSpaceManager().getTracingAssumption();
    }

    protected boolean isTracing() {
        return this.getContext().getObjectSpaceManager().isTracing();
    }

    protected boolean isSingleton(DynamicObject classToAllocate) {
        return Layouts.CLASS.getIsSingleton(classToAllocate);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().ALLOCATE_CLASS_CACHE;
    }
}

