/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChild(value="object", type=RubyNode.class)
public abstract class ClassNode
extends RubyNode {
    public ClassNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract DynamicObject executeGetClass(VirtualFrame var1, Object var2);

    @Specialization(guards={"value"})
    protected DynamicObject getClassTrue(boolean value) {
        return this.getContext().getCoreLibrary().getTrueClass();
    }

    @Specialization(guards={"!value"})
    protected DynamicObject getClassFalse(boolean value) {
        return this.getContext().getCoreLibrary().getFalseClass();
    }

    @Specialization
    protected DynamicObject getClass(int value) {
        return this.getContext().getCoreLibrary().getFixnumClass();
    }

    @Specialization
    protected DynamicObject getClass(long value) {
        return this.getContext().getCoreLibrary().getFixnumClass();
    }

    @Specialization
    protected DynamicObject getClass(double value) {
        return this.getContext().getCoreLibrary().getFloatClass();
    }

    @Specialization
    protected DynamicObject getClass(DynamicObject object) {
        return Layouts.BASIC_OBJECT.getLogicalClass(object);
    }
}

