/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.util.common.StreamUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;

public class FileUtil {
    public static List getLinesFromFile(File file) {
        List list = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            list = StreamUtil.getLinesFromReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NestedApplicationException(fileNotFoundException);
        }
        finally {
            if (null != fileReader) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {
                    throw new NestedApplicationException(exception);
                }
            }
        }
        return list;
    }

    public static File findFile(String string) throws FileNotFoundException {
        File file = new File(string);
        if (FileUtil.isExistingFile(file)) {
            return file;
        }
        file = new File(string = string.replace('\\', '/'));
        if (FileUtil.isExistingFile(file)) {
            return file;
        }
        URL uRL = FileUtil.class.getClassLoader().getResource(string);
        file = FileUtil.decodeFileURL(uRL);
        if (null != file) {
            return file;
        }
        uRL = FileUtil.class.getResource(string);
        file = FileUtil.decodeFileURL(uRL);
        if (null != file) {
            return file;
        }
        throw new FileNotFoundException("Could not find file: " + string);
    }

    private static File decodeFileURL(URL uRL) {
        if (uRL != null) {
            File file = new File(uRL.getFile());
            if (FileUtil.isExistingFile(file)) {
                return file;
            }
            file = new File(URLDecoder.decode(uRL.getFile()));
            if (FileUtil.isExistingFile(file)) {
                return file;
            }
        }
        return null;
    }

    private static boolean isExistingFile(File file) {
        return file.exists() && file.isFile();
    }
}

