#!/usr/bin/env python3

# Copyright 2013 The Meson development team

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import os, sys

def run(args):
    if len(sys.argv) != 2:
        print('delwithsuffix.py <root of subdir to process> <suffix to delete>')
        sys.exit(1)

    topdir = sys.argv[1]
    suffix = sys.argv[2]
    if suffix[0] != '.':
        suffix = '.' + suffix

    for (root, _, files) in os.walk(topdir):
        for f in files:
            if f.endswith(suffix):
                fullname = os.path.join(root, f)
                os.unlink(fullname)
    return 0

if __name__ == '__main__':
    run(sys.argv[1:])
