/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.svg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import org.freehep.graphics2d.TagString;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.font.FontUtilities;
import org.freehep.graphicsio.svg.SVGTagHandler;
import org.freehep.util.UserProperties;
import org.freehep.util.Value;
import org.freehep.util.io.Base64OutputStream;
import org.freehep.util.io.WriterOutputStream;
import org.freehep.xml.util.XMLWriter;

public class SVGGraphics2D
extends AbstractVectorGraphicsIO {
    public static final String VERSION_1_0 = "Version 1.0 (REC-SVG-20010904)";
    public static final String VERSION_1_1 = "Version 1.1 (REC-SVG11-20030114)";
    private static final String rootKey = SVGGraphics2D.class.getName();
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String VERSION = rootKey + ".Version";
    public static final String COMPRESS = rootKey + ".Binary";
    public static final String STYLABLE = rootKey + ".Stylable";
    public static final String IMAGE_SIZE = rootKey + "." + "ImageSize";
    public static final String EXPORT_IMAGES = rootKey + ".ExportImages";
    public static final String EXPORT_SUFFIX = rootKey + ".ExportSuffix";
    public static final String WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
    public static final String FOR = rootKey + "." + "For";
    public static final String TITLE = rootKey + "." + "Title";
    private static final UserProperties defaultProperties = new UserProperties();
    public static final String version = "$Revision: 1.16 $";
    private static final double bias = 0.5;
    private String filename;
    private int bbx;
    private int bby;
    private int bbw;
    private int bbh;
    private OutputStream ros;
    private PrintWriter os;
    Hashtable gradients = new Hashtable();
    Hashtable textures = new Hashtable();
    private Stack closeTags = new Stack();
    private int imageNumber = 0;
    private Value clipNumber;
    private int currentClipNumber;
    private int width;
    private int height;
    private static final Properties replaceFonts;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public SVGGraphics2D(File file, Dimension size) throws IOException {
        this((OutputStream)new FileOutputStream(file), size);
        this.filename = file.getPath();
    }

    public SVGGraphics2D(File file, Component component) throws IOException {
        this((OutputStream)new FileOutputStream(file), component);
        this.filename = file.getPath();
    }

    public SVGGraphics2D(OutputStream os, Dimension size) throws IOException {
        super(size, false);
        this.init(os);
        this.width = size.width;
        this.height = size.height;
    }

    public SVGGraphics2D(OutputStream os, Component component) throws IOException {
        super(component, false);
        this.init(os);
        this.width = this.getSize().width;
        this.height = this.getSize().height;
    }

    private void init(OutputStream os) {
        this.ros = os;
        this.initProperties(SVGGraphics2D.getDefaultProperties());
        this.filename = null;
        this.clipNumber = new Value().set(0);
        this.currentClipNumber = -1;
    }

    protected SVGGraphics2D(SVGGraphics2D graphics, boolean doRestoreOnDispose) {
        super(graphics, doRestoreOnDispose);
        this.filename = graphics.filename;
        this.os = graphics.os;
        this.bbx = graphics.bbx;
        this.bby = graphics.bby;
        this.bbw = graphics.bbw;
        this.bbh = graphics.bbh;
        this.gradients = graphics.gradients;
        this.textures = graphics.textures;
        this.clipNumber = graphics.clipNumber;
        this.currentClipNumber = -1;
    }

    public void setBoundingBox() {
        this.bbx = 0;
        this.bby = 0;
        Dimension size = this.getSize();
        this.bbw = size.width;
        this.bbh = size.height;
    }

    public void writeHeader() throws IOException {
        int h;
        this.ros = new BufferedOutputStream(this.ros);
        if (this.isProperty(COMPRESS)) {
            this.ros = new GZIPOutputStream(this.ros);
        }
        this.os = new PrintWriter(this.ros, true);
        this.setBoundingBox();
        this.imageNumber = 0;
        this.os.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        if (this.getProperty(VERSION).equals(VERSION_1_0)) {
            this.os.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20010904//EN\"");
            this.os.println("  \"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg-20010904.dtd\">");
        } else if (this.getProperty(VERSION).equals(VERSION_1_1)) {
            // empty if block
        }
        this.os.println();
        int x = 0;
        int y = 0;
        Dimension size = this.getPropertyDimension(IMAGE_SIZE);
        int w = size.width;
        if (w <= 0) {
            w = this.width;
        }
        if ((h = size.height) <= 0) {
            h = this.height;
        }
        this.os.println("<svg x=\"" + x + "px\" " + "y=\"" + y + "px\" " + "width=\"" + w + "px\" " + "height=\"" + h + "px\" " + "viewBox=\"" + this.bbx + " " + this.bby + " " + this.bbw + " " + this.bbh + "\" " + this.defaultStyle() + ">");
        this.closeTags.push("</svg> <!-- bounding box -->");
        this.os.println("<title>");
        this.os.println(XMLWriter.normalizeText(this.getProperty(TITLE)));
        this.os.println("</title>");
        String producer = this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        this.os.println("<desc>");
        this.os.println("<Title>" + XMLWriter.normalizeText(this.getProperty(TITLE)) + "</Title>");
        this.os.println("<Creator>" + XMLWriter.normalizeText(this.getCreator()) + "</Creator>");
        this.os.println("<Producer>" + XMLWriter.normalizeText(producer) + "</Producer>");
        this.os.println("<Source>" + XMLWriter.normalizeText(this.getProperty(FOR)) + "</Source>");
        if (!this.isDeviceIndependent()) {
            this.os.println("<Date>" + DateFormat.getDateTimeInstance(0, 0).format(new Date()) + "</Date>");
        }
        this.os.println("</desc>");
        this.writeDefs();
        this.writeSetup();
    }

    private void writeDefs() throws IOException {
        this.os.println("<defs>");
        SVGGraphics2D.copyResourceTo((Object)this, "SVGDefs.txt", this.os);
        if (this.isProperty(STYLABLE)) {
            SVGGraphics2D.copyResourceTo((Object)this, "SVGDefs-stylable.txt", this.os);
        } else {
            SVGGraphics2D.copyResourceTo((Object)this, "SVGDefs-stylable.txt", this.os);
        }
        this.os.println("</defs>\n");
    }

    private void writeSetup() throws IOException {
        this.os.println("<g " + this.defaultStyle() + ">");
        this.setFont(this.getFont());
        this.closeTags.push("</g> <!-- top-level -->");
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
        } else if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        this.writeGraphicsRestore();
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        SVGGraphics2D tempGraphics = new SVGGraphics2D(this, true);
        return tempGraphics;
    }

    public Graphics create(double x, double y, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        SVGGraphics2D graphics = new SVGGraphics2D(this, true);
        this.os.println("<svg x=\"" + this.fixedPrecision(x) + "\" " + "y=\"" + this.fixedPrecision(y) + "\" " + "width=\"" + this.fixedPrecision(width) + "\" " + "height=\"" + this.fixedPrecision(height) + "\" " + ">");
        graphics.closeTags.push("</svg> <!-- graphics context -->");
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
    }

    protected void writeGraphicsRestore() throws IOException {
        while (!this.closeTags.empty()) {
            this.os.println(this.closeTags.pop());
        }
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.os.println("<line " + this.clipPath() + this.style(this.color(this.getPaint(), null)) + " x1=\"" + this.fixedPrecision(x1 + 0.5) + "\" y1=\"" + this.fixedPrecision(y1 + 0.5) + "\" x2=\"" + this.fixedPrecision(x2 + 0.5) + "\" y2=\"" + this.fixedPrecision(y2 + 0.5) + "\" />");
    }

    public void drawRect(double x, double y, double width, double height) {
        this.os.println("<rect " + this.clipPath() + this.style(this.color(this.getPaint(), null)) + " x=\"" + this.fixedPrecision(x + 0.5) + "\" y=\"" + this.fixedPrecision(y + 0.5) + "\" width=\"" + this.fixedPrecision(width) + "\" height=\"" + this.fixedPrecision(height) + "\"/>");
    }

    public void fillRect(double x, double y, double width, double height) {
        this.os.println("<rect " + this.clipPath() + this.style(this.color(null, this.getPaint())) + " x=\"" + this.fixedPrecision(x) + "\" y=\"" + this.fixedPrecision(y) + "\" width=\"" + this.fixedPrecision(width) + "\" height=\"" + this.fixedPrecision(height) + "\"/>");
    }

    public void drawRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.os.println("<rect " + this.clipPath() + this.style(this.color(this.getPaint(), null)) + " x=\"" + this.fixedPrecision(x) + "\" y=\"" + this.fixedPrecision(y) + "\" width=\"" + this.fixedPrecision(width) + "\" height=\"" + this.fixedPrecision(height) + "\" " + "rx=\"" + this.fixedPrecision(arcWidth / 2.0) + "\" ry=\"" + this.fixedPrecision(arcHeight / 2.0) + "\" />");
    }

    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.os.println("<rect " + this.clipPath() + this.style(this.color(null, this.getPaint())) + " x=\"" + this.fixedPrecision(x) + "\" y=\"" + this.fixedPrecision(y) + "\" width=\"" + this.fixedPrecision(width) + "\" height=\"" + this.fixedPrecision(height) + "\" " + "rx=\"" + this.fixedPrecision(arcWidth / 2.0) + "\" ry=\"" + this.fixedPrecision(arcHeight / 2.0) + "\" />");
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.print("<polyline " + this.clipPath() + this.style(this.color(this.getPaint(), null)) + " points=\"");
            for (int i = 0; i < nPoints; ++i) {
                this.os.print((double)xPoints[i] + 0.5 + "," + ((double)yPoints[i] + 0.5) + " ");
            }
            this.os.println("\" />");
        }
    }

    public void drawPolyline(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.print("<polyline " + this.clipPath() + this.style(this.color(this.getPaint(), null)) + " points=\"");
            for (int i = 0; i < nPoints; ++i) {
                this.os.print(this.fixedPrecision(xPoints[i] + 0.5) + "," + this.fixedPrecision(yPoints[i] + 0.5) + " ");
            }
            this.os.println("\" />");
        }
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.print("<polygon " + this.clipPath() + this.style(this.color(this.getPaint(), null)) + " points=\"");
            for (int i = 0; i < nPoints; ++i) {
                this.os.print((double)xPoints[i] + 0.5 + "," + ((double)yPoints[i] + 0.5) + " ");
            }
            this.os.println("\" />");
        }
    }

    public void drawPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.print("<polygon " + this.clipPath() + this.style(this.color(this.getPaint(), null)) + " points=\"");
            for (int i = 0; i < nPoints; ++i) {
                this.os.print(this.fixedPrecision(xPoints[i] + 0.5) + "," + this.fixedPrecision(yPoints[i] + 0.5) + " ");
            }
            this.os.println("\" />");
        }
    }

    public void drawPolygon(Polygon p) {
        this.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.print("<polygon " + this.clipPath() + this.style(this.color(null, this.getPaint()) + "fill-rule:evenodd") + " points=\"");
            for (int i = 0; i < nPoints; ++i) {
                this.os.print(xPoints[i] + "," + yPoints[i] + " ");
            }
            this.os.println("\" />");
        }
    }

    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.print("<polygon " + this.clipPath() + this.style(this.color(null, this.getPaint()) + "fill-rule:evenodd") + " points=\"");
            for (int i = 0; i < nPoints; ++i) {
                this.os.print(this.fixedPrecision(xPoints[i]) + "," + this.fixedPrecision(yPoints[i]) + " ");
            }
            this.os.println("\" />");
        }
    }

    public void fillPolygon(Polygon p) {
        this.fillPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void drawArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        double sa = startAngle * Math.PI / 180.0;
        double aa = arcAngle * Math.PI / 180.0;
        double rx = width / 2.0;
        double ry = height / 2.0;
        double x1 = x + 0.5 + rx + rx * Math.cos(sa);
        double y1 = y + 0.5 + ry - ry * Math.sin(sa);
        double x2 = x + 0.5 + rx + rx * Math.cos(sa + aa);
        double y2 = y + 0.5 + ry - ry * Math.sin(sa + aa);
        int large = Math.abs(arcAngle) <= 180.0 ? 0 : 1;
        int sweep = arcAngle > 0.0 ? 0 : 1;
        this.os.println("<path " + this.clipPath() + this.style(this.color(this.getPaint(), null)) + " d=\"M " + this.fixedPrecision(x1) + " " + this.fixedPrecision(y1) + " A " + this.fixedPrecision(rx) + "," + this.fixedPrecision(ry) + " 0 " + large + " " + sweep + " " + this.fixedPrecision(x2) + "," + this.fixedPrecision(y2) + "\"/>");
    }

    public void fillArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        double sa = startAngle * Math.PI / 180.0;
        double aa = arcAngle * Math.PI / 180.0;
        double rx = width / 2.0;
        double ry = height / 2.0;
        double x1 = x + rx + rx * Math.cos(sa);
        double y1 = y + ry - ry * Math.sin(sa);
        double x2 = x + rx + rx * Math.cos(sa + aa);
        double y2 = y + ry - ry * Math.sin(sa + aa);
        int large = Math.abs(arcAngle) <= 180.0 ? 0 : 1;
        int sweep = arcAngle > 0.0 ? 0 : 1;
        this.os.println("<path " + this.clipPath() + this.style(this.color(null, this.getPaint())) + " d=\"M " + this.fixedPrecision(x1) + " " + this.fixedPrecision(y1) + " A " + this.fixedPrecision(rx) + "," + this.fixedPrecision(ry) + " 0 " + large + " " + sweep + " " + this.fixedPrecision(x2) + "," + this.fixedPrecision(y2) + " L " + this.fixedPrecision(x + rx) + " " + this.fixedPrecision(y + ry) + " z\"/>");
    }

    public void drawOval(double x, double y, double width, double height) {
        this.os.println("<ellipse " + this.clipPath() + this.style(this.color(this.getPaint(), null)) + " cx=\"" + this.fixedPrecision(x + 0.5 + width / 2.0) + "\" cy=\"" + this.fixedPrecision(y + 0.5 + height / 2.0) + "\" " + "rx=\"" + this.fixedPrecision(width / 2.0) + "\" ry=\"" + this.fixedPrecision(height / 2.0) + "\" />");
    }

    public void fillOval(double x, double y, double width, double height) {
        this.os.println("<ellipse " + this.clipPath() + this.style(this.color(null, this.getPaint())) + " cx=\"" + this.fixedPrecision(x + width / 2.0) + "\" cy=\"" + this.fixedPrecision(y + height / 2.0) + "\" " + "rx=\"" + this.fixedPrecision(width / 2.0) + "\" ry=\"" + this.fixedPrecision(height / 2.0) + "\" />");
    }

    public void draw(Shape shape) {
        PathIterator path = shape.getPathIterator(null);
        this.os.println("<g " + this.clipPath() + this.style(this.color(this.getPaint(), null)) + ">");
        this.writePath(path);
        this.os.println("</g> <!-- draw -->");
    }

    public void fill(Shape shape) {
        PathIterator path = shape.getPathIterator(null);
        StringBuffer s = new StringBuffer();
        s.append(this.color(null, this.getPaint()));
        if (path.getWindingRule() == 0) {
            s.append("fill-rule:evenodd;");
        } else {
            s.append("fill-rule:nonzero;");
        }
        this.os.println("<g " + this.clipPath() + this.style(s.toString()) + ">");
        this.writePath(path);
        this.os.println("</g> <!-- fill -->");
    }

    public void fillAndDraw(Shape shape, Color fillColor) {
        PathIterator path = shape.getPathIterator(null);
        StringBuffer s = new StringBuffer();
        if (fillColor != null) {
            s.append(this.color(this.getPaint(), fillColor));
            if (path.getWindingRule() == 0) {
                s.append("fill-rule:evenodd;");
            } else {
                s.append("fill-rule:nonzero;");
            }
        }
        this.os.println("<g " + this.clipPath() + this.style(s.toString()) + ">");
        this.writePath(path);
        this.os.println("</g> <!-- fillAndDraw -->");
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        byte[] imageBytes;
        String encode;
        if (xform != null && !xform.isIdentity()) {
            this.os.println("<g transform=\"matrix(" + this.fixedPrecision(xform.getScaleX()) + ", " + this.fixedPrecision(xform.getShearY()) + ", " + this.fixedPrecision(xform.getShearX()) + ", " + this.fixedPrecision(xform.getScaleY()) + ", " + this.fixedPrecision(xform.getTranslateX()) + ", " + this.fixedPrecision(xform.getTranslateY()) + ")\">");
        }
        this.os.print("<image x=\"0\" y=\"0\" width=\"" + image.getWidth() + "\" " + "height=\"" + image.getHeight() + "\" " + "xlink:href=\"");
        String writeAs = this.getProperty(WRITE_IMAGES_AS);
        boolean isTransparent = image.getColorModel().hasAlpha() && bkg == null;
        byte[] pngBytes = null;
        if (writeAs.equals("PNG") || writeAs.equals("Smallest Size") || isTransparent) {
            ByteArrayOutputStream png = new ByteArrayOutputStream();
            ImageGraphics2D.writeImage(image, "png", new Properties(), (OutputStream)png);
            png.close();
            pngBytes = png.toByteArray();
        }
        byte[] jpgBytes = null;
        if ((writeAs.equals("JPG") || writeAs.equals("Smallest Size")) && !isTransparent) {
            ByteArrayOutputStream jpg = new ByteArrayOutputStream();
            ImageGraphics2D.writeImage(image, "jpg", new Properties(), (OutputStream)jpg);
            jpg.close();
            jpgBytes = jpg.toByteArray();
        }
        if (writeAs.equals("PNG") || isTransparent) {
            encode = "png";
            imageBytes = pngBytes;
        } else if (writeAs.equals("JPG")) {
            encode = "jpg";
            imageBytes = jpgBytes;
        } else {
            encode = (double)jpgBytes.length < 0.5 * (double)pngBytes.length ? "jpg" : "png";
            byte[] byArray = imageBytes = encode.equals("jpg") ? jpgBytes : pngBytes;
        }
        if (this.isProperty(EXPORT_IMAGES)) {
            ++this.imageNumber;
            if (this.filename == null) {
                this.writeWarning("SVG: cannot write embedded images, since SVGGraphics2D");
                this.writeWarning("     was created from an OutputStream rather than a File.");
                return;
            }
            int pos = this.filename.lastIndexOf(File.separatorChar);
            String dirName = pos < 0 ? "" : this.filename.substring(0, pos + 1);
            String imageName = pos < 0 ? this.filename : this.filename.substring(pos + 1);
            imageName = imageName + "." + this.getProperty(EXPORT_SUFFIX) + "-" + this.imageNumber + "." + encode;
            this.os.print(imageName);
            FileOutputStream imageStream = new FileOutputStream(dirName + imageName);
            imageStream.write(imageBytes);
            imageStream.close();
        } else {
            this.os.println("data:image/" + encode + ";base64,");
            Base64OutputStream b64 = new Base64OutputStream(new WriterOutputStream(this.os));
            b64.write(imageBytes);
            b64.finish();
        }
        this.os.println("\"/>");
        if (xform != null && !xform.isIdentity()) {
            this.os.println("</g> <!-- transform -->");
        }
    }

    protected void writeString(String str, double x, double y) throws IOException {
        str = FontUtilities.getEncodedString(str, this.getFont().getName());
        this.os.println("<text " + this.style(this.color(null, this.getPaint())) + " x=\"" + this.fixedPrecision(x) + "\" y=\"" + this.fixedPrecision(y) + "\">");
        this.os.println(XMLWriter.normalizeText(str));
        this.os.println("</text>");
    }

    public void drawString(String str, double x, double y, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        Color color;
        str = FontUtilities.getEncodedString(str, this.getFont().getName());
        LineMetrics metrics = this.getFont().getLineMetrics(str, this.getFontRenderContext());
        double w = this.getFont().getStringBounds(str, this.getFontRenderContext()).getWidth();
        double h = metrics.getHeight();
        double d = metrics.getDescent();
        double adjustment = this.getFont().getSize2D() * 2.0f / 10.0f;
        double ny = SVGGraphics2D.getYalignment(y, h, d, vertical);
        double nx = SVGGraphics2D.getXalignment(x, w, horizontal);
        double rx = nx - adjustment;
        double ry = ny - h + d - adjustment;
        double rw = w + 2.0 * adjustment;
        double rh = h + 2.0 * adjustment;
        if (banner) {
            color = this.getColor();
            this.setColor(bannerColor);
            this.fillRect(rx, ry, rw, rh);
            this.setColor(color);
        }
        if (framed) {
            color = this.getColor();
            this.setColor(frameColor);
            Stroke s = this.getStroke();
            this.setLineWidth(frameWidth);
            this.drawRect(rx, ry, rw, rh);
            this.setColor(color);
            this.setStroke(s);
        }
        this.os.println("<text " + this.style(this.color(null, this.getPaint()) + this.getAlignmentString(horizontal, vertical, metrics)) + " x=\"" + this.fixedPrecision(x) + "\" y=\"" + this.fixedPrecision(y) + "\">");
        this.os.println(XMLWriter.normalizeText(str));
        this.os.println("</text>");
    }

    public void drawString(TagString str, double x, double y, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        Color color;
        SVGTagHandler tagHandler = new SVGTagHandler(this.isProperty(STYLABLE), this.getFont(), this.getFontRenderContext());
        double nx = SVGGraphics2D.getXalignment(x, tagHandler.stringWidth(str), horizontal);
        LineMetrics metrics = this.getFont().getLineMetrics(str.toString(), this.getFontRenderContext());
        double w = tagHandler.stringWidth(str);
        double h = metrics.getHeight();
        double d = metrics.getDescent();
        double adjustment = this.getFont().getSize2D() * 2.0f / 10.0f;
        double ny = SVGGraphics2D.getYalignment(y, h, d, vertical);
        double rx = nx - adjustment;
        double ry = ny - h + d - adjustment;
        double rw = w + 2.0 * adjustment;
        double rh = h + 2.0 * adjustment;
        if (banner) {
            color = this.getColor();
            this.setColor(bannerColor);
            this.fillRect(rx, ry, rw, rh);
            this.setColor(color);
        }
        if (framed) {
            color = this.getColor();
            this.setColor(frameColor);
            Stroke s = this.getStroke();
            this.setLineWidth(frameWidth);
            this.drawRect(rx, ry, rw, rh);
            this.setColor(color);
            this.setStroke(s);
        }
        String string = tagHandler.parse(str);
        string = FontUtilities.getEncodedString(string, this.getFont().getName());
        this.os.println("<text " + this.style(this.color(null, this.getPaint()) + this.getAlignmentString(horizontal, vertical, metrics)) + " x=\"" + this.fixedPrecision(x) + "\" y=\"" + this.fixedPrecision(y) + "\">");
        this.os.println(string);
        this.os.println("</text>");
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.writeWarning(this.getClass() + ": drawString(AttributedCharacterIterator, float, float) not implemented.");
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.writeWarning(this.getClass() + ": drawGlyphVector(GlyphVector, float, float) not implemented.");
    }

    protected void writeTransform(AffineTransform transform) throws IOException {
        this.os.println("<g transform=\"matrix(" + this.fixedPrecision(transform.getScaleX()) + "," + this.fixedPrecision(transform.getShearY()) + "," + this.fixedPrecision(transform.getShearX()) + "," + this.fixedPrecision(transform.getScaleY()) + "," + this.fixedPrecision(transform.getTranslateX()) + "," + this.fixedPrecision(transform.getTranslateY()) + ")\">");
        this.closeTags.push("</g> <!-- transform -->");
    }

    protected void writeClip(Rectangle2D r2d) throws IOException {
        this.writeClip((Shape)r2d);
    }

    protected void writeClip(Shape s) throws IOException {
        if (s == null) {
            this.currentClipNumber = -1;
            return;
        }
        PathIterator path = s.getPathIterator(null);
        this.currentClipNumber = this.clipNumber.getInt();
        this.clipNumber.set(this.currentClipNumber + 1);
        this.os.println("<clipPath id=\"clip" + this.currentClipNumber + "\">");
        this.writePath(path);
        this.os.println("</clipPath>");
    }

    protected void writeWidth(float width) throws IOException {
        if (width == 0.0f) {
            width = 1.0E-6f;
        }
        this.os.println("<g " + this.style("stroke-width:" + this.fixedPrecision(width)) + ">");
        this.closeTags.push("</g> <!-- stroke width -->");
    }

    protected void writeCap(int cap) throws IOException {
        this.os.print("<g ");
        switch (cap) {
            default: {
                this.os.print(this.style("stroke-linecap:butt"));
                break;
            }
            case 1: {
                this.os.print(this.style("stroke-linecap:round"));
                break;
            }
            case 2: {
                this.os.print(this.style("stroke-linecap:square"));
            }
        }
        this.os.println(">");
        this.closeTags.push("</g> <!-- stroke cap -->");
    }

    protected void writeJoin(int join) throws IOException {
        this.os.print("<g ");
        switch (join) {
            default: {
                this.os.print(this.style("stroke-linejoin:miter"));
                break;
            }
            case 1: {
                this.os.print(this.style("stroke-linejoin:round"));
                break;
            }
            case 2: {
                this.os.print(this.style("stroke-linejoin:bevel"));
            }
        }
        this.os.println(">");
        this.closeTags.push("</g> <!-- stroke join -->");
    }

    protected void writeMiterLimit(float limit) throws IOException {
        this.os.println("<g " + this.style("stroke-miterlimit:" + this.fixedPrecision(limit)) + ">");
        this.closeTags.push("</g> <!-- stroke limit -->");
    }

    protected void writeDash(double[] dash, double phase) throws IOException {
        this.os.print("<g ");
        StringBuffer s = new StringBuffer();
        s.append("stroke-dasharray:");
        if (dash.length > 0) {
            for (int i = 0; i < dash.length; ++i) {
                if (i > 0) {
                    s.append(",");
                }
                s.append(this.fixedPrecision(dash[i]));
            }
            s.append(";");
        } else {
            s.append("none;");
        }
        s.append("stroke-dashoffset:" + this.fixedPrecision(phase));
        this.os.println(this.style(s.toString()) + ">");
        this.closeTags.push("</g> <!-- stroke dash -->");
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color c) throws IOException {
    }

    protected void writePaint(GradientPaint paint) throws IOException {
        if (this.gradients.get(paint) == null) {
            String name = "gradient-" + this.gradients.size();
            this.gradients.put(paint, name);
            GradientPaint gp = paint;
            Point2D p1 = gp.getPoint1();
            Point2D p2 = gp.getPoint2();
            this.os.println("<defs>");
            this.os.print("  <linearGradient id=\"" + name + "\" ");
            this.os.print("x1=\"" + this.fixedPrecision(p1.getX()) + "\" ");
            this.os.print("y1=\"" + this.fixedPrecision(p1.getY()) + "\" ");
            this.os.print("x2=\"" + this.fixedPrecision(p2.getX()) + "\" ");
            this.os.print("y2=\"" + this.fixedPrecision(p2.getY()) + "\" ");
            this.os.print("gradientUnits=\"userSpaceOnUse\" ");
            this.os.print("spreadMethod=\"" + (gp.isCyclic() ? "reflect" : "pad") + "\" ");
            this.os.println(">");
            this.os.println("    <stop offset=\"0\" stop-color=\"" + this.hexColor(gp.getColor1()) + "\" " + "opacity-stop=\"" + this.alphaColor(gp.getColor1()) + "\" />");
            this.os.println("    <stop offset=\"1\" stop-color=\"" + this.hexColor(gp.getColor2()) + "\" " + "opacity-stop=\"" + this.alphaColor(gp.getColor2()) + "\" />");
            this.os.println("  </linearGradient>");
            this.os.println("</defs>");
        }
        this.os.println("<g " + this.style("stroke:" + this.hexColor(this.getPaint())) + ">");
        this.closeTags.push("</g> <!-- color -->");
    }

    protected void writePaint(TexturePaint paint) throws IOException {
        if (this.textures.get(paint) == null) {
            String name = "texture-" + this.textures.size();
            this.textures.put(paint, name);
            TexturePaint tp = paint;
            BufferedImage image = tp.getImage();
            Rectangle2D rect = tp.getAnchorRect();
            this.os.println("<defs>");
            this.os.print("  <pattern id=\"" + name + "\" ");
            this.os.print("x=\"0\" ");
            this.os.print("y=\"0\" ");
            this.os.print("width=\"" + this.fixedPrecision(image.getWidth()) + "\" ");
            this.os.print("height=\"" + this.fixedPrecision(image.getHeight()) + "\" ");
            this.os.print("patternUnits=\"userSpaceOnUse\" ");
            this.os.print("patternTransform=\"matrix(" + this.fixedPrecision(rect.getWidth() / (double)image.getWidth()) + "," + "0.0,0.0," + this.fixedPrecision(rect.getHeight() / (double)image.getHeight()) + "," + this.fixedPrecision(rect.getX()) + "," + this.fixedPrecision(rect.getY()) + ")\" ");
            this.os.println(">");
            this.writeImage(image, null, null);
            this.os.println("  </pattern>");
            this.os.println("</defs>");
        }
        this.os.println("<g " + this.style("stroke:" + this.hexColor(this.getPaint())) + ">");
        this.closeTags.push("</g> <!-- color -->");
    }

    protected void writePaint(Paint p) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(Paint) not implemented for " + p.getClass());
    }

    public void setFont(Font font) {
        super.setFont(font);
        StringBuffer svgFont = new StringBuffer();
        svgFont.append("font-family:");
        String fontName = font.getName();
        svgFont.append(replaceFonts.getProperty(fontName, fontName));
        if (font.isBold()) {
            svgFont.append(";font-weight:bold");
        } else {
            svgFont.append(";font-weight:normal");
        }
        if (font.isItalic()) {
            svgFont.append(";font-style:italic");
        } else {
            svgFont.append(";font-style:normal");
        }
        int size = font.getSize();
        svgFont.append(";font-size:" + size);
        this.os.println("<g " + this.style(svgFont.toString()) + ">");
        this.closeTags.push("</g> <!-- font -->");
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.writeWarning(this.getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String s) throws IOException {
        this.os.println("<!-- " + s + " -->");
    }

    public String toString() {
        return "SVGGraphics2D";
    }

    private String color(Paint stroke, Paint fill) {
        StringBuffer s = new StringBuffer();
        s.append("stroke:");
        if (stroke != null) {
            s.append(this.hexColor(stroke));
            s.append(";stroke-opacity:");
            s.append(this.alphaColor(stroke));
        } else {
            s.append("none");
        }
        s.append(";");
        s.append("fill:");
        if (fill != null) {
            s.append(this.hexColor(fill));
            s.append(";fill-opacity:");
            s.append(this.alphaColor(fill));
        } else {
            s.append("none");
        }
        s.append(";");
        return s.toString();
    }

    private float alphaColor(Paint p) {
        if (p instanceof Color) {
            return (float)((double)this.getPrintColor((Color)p).getAlpha() / 255.0);
        }
        if (p instanceof GradientPaint) {
            return 1.0f;
        }
        if (p instanceof TexturePaint) {
            return 1.0f;
        }
        this.writeWarning(this.getClass() + ": alphaColor() not implemented for " + p.getClass() + ".");
        return 1.0f;
    }

    private String hexColor(Paint p) {
        if (p instanceof Color) {
            return this.hexColor(this.getPrintColor((Color)p));
        }
        if (p instanceof GradientPaint) {
            return this.hexColor((GradientPaint)p);
        }
        if (p instanceof TexturePaint) {
            return this.hexColor((TexturePaint)p);
        }
        this.writeWarning(this.getClass() + ": hexColor() not implemented for " + p.getClass() + ".");
        return "#000000";
    }

    private String hexColor(Color c) {
        String s1 = Integer.toHexString(c.getRed());
        s1 = s1.length() != 2 ? "0" + s1 : s1;
        String s2 = Integer.toHexString(c.getGreen());
        s2 = s2.length() != 2 ? "0" + s2 : s2;
        String s3 = Integer.toHexString(c.getBlue());
        s3 = s3.length() != 2 ? "0" + s3 : s3;
        return "#" + s1 + s2 + s3;
    }

    private String hexColor(GradientPaint p) {
        return "url(#" + this.gradients.get(p) + ")";
    }

    private String hexColor(TexturePaint p) {
        return "url(#" + this.textures.get(p) + ")";
    }

    private void writePath(PathIterator path) {
        double[] coords = new double[6];
        double currentX = 0.0;
        double currentY = 0.0;
        this.os.print("<path d=\"");
        while (!path.isDone()) {
            int segType = path.currentSegment(coords);
            switch (segType) {
                case 0: {
                    this.os.print("M " + this.fixedPrecision(coords[0]) + " " + this.fixedPrecision(coords[1]) + " ");
                    currentX = coords[0];
                    currentY = coords[1];
                    break;
                }
                case 1: {
                    this.os.print("L " + this.fixedPrecision(coords[0]) + " " + this.fixedPrecision(coords[1]) + " ");
                    currentX = coords[0];
                    currentY = coords[1];
                    break;
                }
                case 3: {
                    this.os.print("C " + this.fixedPrecision(coords[0]) + " " + this.fixedPrecision(coords[1]) + " " + this.fixedPrecision(coords[2]) + " " + this.fixedPrecision(coords[3]) + " " + this.fixedPrecision(coords[4]) + " " + this.fixedPrecision(coords[5]) + " ");
                    currentX = coords[4];
                    currentY = coords[5];
                    break;
                }
                case 2: {
                    this.os.print("Q " + this.fixedPrecision(coords[0]) + " " + this.fixedPrecision(coords[1]) + " " + this.fixedPrecision(coords[2]) + " " + this.fixedPrecision(coords[3]) + " ");
                    currentX = coords[2];
                    currentY = coords[3];
                    break;
                }
                case 4: {
                    this.os.print("z ");
                    currentX = 0.0;
                    currentY = 0.0;
                }
            }
            path.next();
        }
        this.os.println("\"/>");
    }

    private String clipPath() {
        return this.currentClipNumber < 0 ? "" : "clip-path=\"url(#clip" + this.currentClipNumber + ")\" ";
    }

    private String defaultStyle() {
        return this.style(this.color(this.getPaint(), null) + "stroke-width:1;" + "stroke-linecap:square");
    }

    private String style(String stylableString) {
        return SVGGraphics2D.style(this.isProperty(STYLABLE), stylableString);
    }

    static String style(boolean stylable, String stylableString) {
        if (stylableString == null || stylableString.equals("")) {
            return "";
        }
        if (stylable) {
            return "style=\"" + stylableString + "\"";
        }
        StringBuffer r = new StringBuffer();
        StringTokenizer st1 = new StringTokenizer(stylableString, ";");
        while (st1.hasMoreTokens()) {
            String s = st1.nextToken();
            int colon = s.indexOf(58);
            if (colon < 0) continue;
            r.append(s.substring(0, colon));
            r.append("=\"");
            r.append(s.substring(colon + 1));
            r.append("\" ");
        }
        return r.toString();
    }

    private String getAlignmentString(int horizontal, int vertical, LineMetrics metrics) {
        double alignmentBaseline;
        String textAnchor;
        switch (horizontal) {
            case 2: {
                textAnchor = "middle";
                break;
            }
            case 3: {
                textAnchor = "end";
                break;
            }
            default: {
                textAnchor = "start";
            }
        }
        switch (vertical) {
            case 1: {
                alignmentBaseline = -100.0f * (metrics.getAscent() + metrics.getLeading()) / metrics.getHeight();
                break;
            }
            case 2: {
                alignmentBaseline = -50.0f * metrics.getAscent() / metrics.getHeight();
                break;
            }
            case 3: {
                alignmentBaseline = metrics.getDescent() / metrics.getHeight();
                break;
            }
            default: {
                alignmentBaseline = 0.0;
            }
        }
        return "text-anchor:" + textAnchor + ";" + "baseline-shift:" + this.fixedPrecision(alignmentBaseline) + "%";
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(VERSION, VERSION_1_0);
        defaultProperties.setProperty(COMPRESS, true);
        defaultProperties.setProperty(STYLABLE, true);
        defaultProperties.setProperty(IMAGE_SIZE, new Dimension(0, 0));
        defaultProperties.setProperty(EXPORT_IMAGES, false);
        defaultProperties.setProperty(EXPORT_SUFFIX, "image");
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        defaultProperties.setProperty(FOR, "");
        defaultProperties.setProperty(TITLE, "");
        replaceFonts = new Properties();
        replaceFonts.setProperty("Dialog", "sans-serif");
        replaceFonts.setProperty("DialogInput", "sans-serif");
        replaceFonts.setProperty("Serif", "serif");
        replaceFonts.setProperty("SansSerif", "sans-serif");
        replaceFonts.setProperty("Monospaced", "monospace");
        replaceFonts.setProperty("Symbol", "serif");
        replaceFonts.setProperty("ZapfDingbats", "serif");
        replaceFonts.setProperty("TimesRoman", "serif");
        replaceFonts.setProperty("Helvetica", "sans-serif");
        replaceFonts.setProperty("Courier", "monospace");
    }
}

