/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.zaproxy.zap.view.LayoutHelper;

public class LayoutHelperUnitTest {
    private static final int X = 1;
    private static final int Y = 2;
    private static final int WIDTH = 3;
    private static final int HEIGHT = 4;
    private static final double WEIGHT_X = 4.5;
    private static final double WEIGHT_Y = 6.7;
    private static final int FILL = 8;
    private static final int ANCHOR = 9;
    private static final Insets INSETS = new Insets(10, 11, 12, 13);

    @Test
    public void shouldResizeHorizontallyAndVerticallyByDefault() {
        GridBagConstraints gridBagConstraints = LayoutHelper.getGBC(1, 2, 3, 4.5);
        Assert.assertThat((Object)gridBagConstraints.fill, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void shouldUseNorthWestAnchorByDefault() {
        GridBagConstraints gridBagConstraints = LayoutHelper.getGBC(1, 2, 3, 4.5);
        Assert.assertThat((Object)gridBagConstraints.anchor, (Matcher)Matchers.is((Object)18));
    }

    @Test
    public void shouldKeepDefaultInsetsOnGivenNullParameter() {
        GridBagConstraints gridBagConstraints = LayoutHelper.getGBC(1, 2, 3, 4.5, null);
        Assert.assertThat((Object)gridBagConstraints.insets, (Matcher)Matchers.is((Object)new Insets(0, 0, 0, 0)));
    }

    @Test
    public void shouldSetAllGivenParameters() {
        GridBagConstraints gridBagConstraints = LayoutHelper.getGBC(1, 2, 3, 4, 4.5, 6.7, 8, 9, INSETS);
        Assert.assertThat((Object)gridBagConstraints.gridx, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)gridBagConstraints.gridy, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)gridBagConstraints.gridwidth, (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)gridBagConstraints.gridheight, (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)gridBagConstraints.weightx, (Matcher)Matchers.is((Object)4.5));
        Assert.assertThat((Object)gridBagConstraints.weighty, (Matcher)Matchers.is((Object)6.7));
        Assert.assertThat((Object)gridBagConstraints.fill, (Matcher)Matchers.is((Object)8));
        Assert.assertThat((Object)gridBagConstraints.anchor, (Matcher)Matchers.is((Object)9));
        Assert.assertThat((Object)gridBagConstraints.insets, (Matcher)Matchers.is((Object)INSETS));
    }
}

