/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.widgets;

import java.io.File;
import java.nio.file.Files;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;

public class WritableFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -8600149638325315049L;

    public WritableFileChooser() {
    }

    public WritableFileChooser(File file) {
        super(file);
    }

    @Override
    public void approveSelection() {
        File file = this.getSelectedFile();
        if (!Files.isWritable(file.getParentFile().toPath())) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Constant.messages.getString("report.write.permission.dialog.message"), file.getAbsolutePath()), Constant.messages.getString("report.write.permission.dialog.title"), 0);
            return;
        }
        if (file.exists()) {
            int n = JOptionPane.showConfirmDialog(this, Constant.messages.getString("report.write.overwrite.dialog.message"), Constant.messages.getString("report.write.overwrite.dialog.title"), 0);
            switch (n) {
                case 0: {
                    super.approveSelection();
                    return;
                }
                case -1: 
                case 1: {
                    return;
                }
            }
        }
        Model.getSingleton().getOptionsParam().setUserDirectory(this.getCurrentDirectory());
        super.approveSelection();
    }
}

