/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx.ui;

import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.impl.fx.ui.DialogTemplate;
import com.sun.deploy.uitoolkit.impl.fx.ui.FXDialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.MoreInfoDialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.UITextArea;
import com.sun.deploy.uitoolkit.impl.fx.ui.resources.ResourceManager;
import java.net.URL;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class FXSSV3Dialog {
    private static final int MAIN_TEXT_WIDTH = 460;
    private static final int RISK_TEXT_WIDTH = 540;
    private static final int MAX_URL_WIDTH = 360;
    private AppInfo ainfo;
    private String masthead;
    private String mainText;
    private String location;
    private String prompt;
    private String multiPrompt;
    private String multiText;
    private String runKey;
    private String updateText;
    private String cancelText;
    private URL updateURL;
    private String locationURL = "";
    private String mainJNLPURL;
    private String documentBaseURL;
    private String locationTooltip = "";
    private String mainJNLPTooltip;
    private String documentBaseTooltip;
    private int userAnswer = 1;
    private FXDialog dialog;
    private Button runButton;
    private Button updateButton;
    private Button cancelButton;
    private CheckBox multiClickCheckBox;

    public static int showSSV3Dialog(Object owner, AppInfo ainfo, int messageType, String titleKey, String mastheadKey, String mainTextKey, String locationKey, String promptKey, String multiPromptKey, String multiTextKey, String runKey, String updateKey, String cancelKey, String alwaysTextKey, URL updateURL) {
        FXSSV3Dialog dialog = new FXSSV3Dialog(owner, FXSSV3Dialog.getMessage(titleKey));
        dialog.ainfo = ainfo;
        dialog.masthead = FXSSV3Dialog.getMessage(mastheadKey);
        dialog.mainText = FXSSV3Dialog.getMessage(mainTextKey);
        dialog.location = FXSSV3Dialog.getMessage(locationKey);
        dialog.prompt = FXSSV3Dialog.getMessage(promptKey);
        dialog.multiPrompt = FXSSV3Dialog.getMessage(multiPromptKey);
        dialog.multiText = FXSSV3Dialog.getMessage(multiTextKey);
        dialog.runKey = runKey;
        dialog.updateText = FXSSV3Dialog.getMessage(updateKey);
        dialog.cancelText = FXSSV3Dialog.getMessage(cancelKey);
        dialog.updateURL = updateURL;
        dialog.initComponents();
        dialog.setVisible(true);
        return dialog.getAnswer();
    }

    private FXSSV3Dialog(Object owner, String title) {
        Stage stage = null;
        if (owner instanceof Stage) {
            stage = (Stage)owner;
        }
        this.dialog = new FXDialog(title, stage, true);
    }

    private void initComponents() {
        try {
            try {
                this.locationURL = this.ainfo.getDisplayFrom();
                this.locationTooltip = this.ainfo.getFrom().toString();
            }
            catch (Exception e) {
                this.locationURL = "";
                this.locationTooltip = "";
            }
            if (this.ainfo.shouldDisplayMainJNLP()) {
                this.mainJNLPURL = this.ainfo.getDisplayMainJNLP();
                this.mainJNLPTooltip = this.ainfo.getDisplayMainJNLPTooltip();
            }
            if (this.ainfo.shouldDisplayDocumentBase()) {
                this.documentBaseURL = this.ainfo.getDisplayDocumentBase();
                this.documentBaseTooltip = this.ainfo.getDocumentBase().toString();
            }
            this.dialog.setResizable(false);
            this.dialog.setIconifiable(false);
            Pane contentPane = this.createContentPane();
            contentPane.getChildren().add(this.createMastHead());
            contentPane.getChildren().add(this.createMainContent());
            contentPane.getChildren().add(this.createOkCancelPanel());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private Pane createContentPane() {
        VBox contentPane = new VBox(){

            protected double computePrefHeight(double width) {
                double h = super.computePrefHeight(width);
                return h;
            }
        };
        contentPane.setId("ssv3-content-panel");
        this.dialog.setContentPane(contentPane);
        return contentPane;
    }

    private Node createMastHead() {
        UITextArea text = new UITextArea(this.masthead);
        text.setId("security-masthead-label");
        return text;
    }

    private Pane createMainContent() {
        Pane warningPanel = this.createWarningPanel();
        BorderPane box = new BorderPane();
        box.setTop(warningPanel);
        if (this.multiText == null) {
            UITextArea text = new UITextArea(460.0);
            text.setText(this.prompt);
            text.setId("ssv3-prompt");
            box.setBottom(this.createWarningMorePrompt(text));
        }
        return box;
    }

    private Pane createWarningPanel() {
        BorderPane border = new BorderPane();
        border.setLeft(this.createShieldIcon());
        VBox box = this.createLocationPanel();
        border.setCenter(box);
        return border;
    }

    private VBox createLocationPanel() {
        VBox box = new VBox();
        Text main = new Text(this.mainText);
        main.setId("ssv3-main-text");
        main.setWrappingWidth(460.0);
        box.getChildren().add(main);
        Label locationLabel = new Label(this.location);
        locationLabel.setText(this.location);
        locationLabel.setId("ssv3-location-label");
        Label url = new Label(this.locationURL);
        url.setTooltip(new Tooltip(this.locationTooltip));
        url.setId("ssv3-location-url");
        GridPane gridPane = new GridPane();
        gridPane.setId("ssv3-location-label-url");
        gridPane.add(locationLabel, 0, 0);
        gridPane.add(url, 1, 0);
        int row = 1;
        if (this.mainJNLPURL != null) {
            url = new Label(this.mainJNLPURL);
            url.setTooltip(new Tooltip(this.mainJNLPTooltip));
            url.setMaxWidth(360.0);
            url.setId("ssv3-location-url");
            gridPane.add(url, 1, row++);
        }
        if (this.documentBaseURL != null) {
            url = new Label(this.documentBaseURL);
            url.setTooltip(new Tooltip(this.documentBaseTooltip));
            url.setMaxWidth(360.0);
            url.setId("ssv3-location-url");
            gridPane.add(url, 1, row);
        }
        box.getChildren().add(gridPane);
        return box;
    }

    private Pane createShieldIcon() {
        Label warningIcon = new Label(null, ResourceManager.getIcon("warning48s.image"));
        warningIcon.setId("ssv3-shield");
        VBox box = new VBox();
        box.getChildren().add(warningIcon);
        return box;
    }

    private Pane createOkCancelPanel() {
        HBox decisionPanel = new HBox();
        decisionPanel.getStyleClass().add("security-button-bar");
        this.runButton = new Button(FXSSV3Dialog.getMessage(this.runKey));
        this.runButton.setMnemonicParsing(true);
        Button defaultButton = null;
        decisionPanel.getChildren().add(this.runButton);
        this.runButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent t) {
                FXSSV3Dialog.this.runAction();
            }
        });
        this.cancelButton = new Button(this.cancelText);
        this.cancelButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent e) {
                FXSSV3Dialog.this.userAnswer = 1;
                FXSSV3Dialog.this.closeDialog();
            }
        });
        this.cancelButton.setCancelButton(true);
        if (this.updateText != null) {
            this.updateButton = new Button(this.updateText);
            this.updateButton.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent t) {
                    FXSSV3Dialog.this.updateAction();
                }
            });
            decisionPanel.getChildren().add(this.updateButton);
            defaultButton = this.updateButton;
        } else {
            defaultButton = this.cancelButton;
        }
        decisionPanel.getChildren().add(this.cancelButton);
        VBox vBox = new VBox();
        this.createMultSelectionBox(vBox);
        vBox.getChildren().add(decisionPanel);
        this.setDefaultButton(defaultButton);
        return vBox;
    }

    private void createMultSelectionBox(VBox box) {
        if (this.multiPrompt != null && this.multiText != null) {
            this.runButton.setDisable(true);
            Label multiMessage = new Label(this.multiPrompt);
            multiMessage.setId("ssv3-multi-click");
            VBox createWarningMorePrompt = this.createWarningMorePrompt(multiMessage);
            VBox vb = new VBox(8.0);
            vb.getChildren().add(createWarningMorePrompt);
            vb.getChildren().add(multiMessage);
            HBox mb = new HBox();
            mb.getChildren().add(vb);
            box.getChildren().add(mb);
            this.multiClickCheckBox = new CheckBox(this.multiText);
            this.multiClickCheckBox.setId("ssv3-checkbox");
            box.getChildren().add(this.multiClickCheckBox);
            this.multiClickCheckBox.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent t) {
                    FXSSV3Dialog.this.runButton.setDisable(!FXSSV3Dialog.this.multiClickCheckBox.isSelected());
                    if (FXSSV3Dialog.this.multiClickCheckBox.isSelected()) {
                        FXSSV3Dialog.this.setDefaultButton(FXSSV3Dialog.this.runButton);
                    } else if (FXSSV3Dialog.this.updateButton != null) {
                        FXSSV3Dialog.this.setDefaultButton(FXSSV3Dialog.this.updateButton);
                    } else if (FXSSV3Dialog.this.cancelButton != null) {
                        FXSSV3Dialog.this.setDefaultButton(FXSSV3Dialog.this.cancelButton);
                    }
                }
            });
        }
    }

    private void setDefaultButton(Button defaultButton) {
        this.runButton.setDefaultButton(false);
        if (this.updateButton != null) {
            this.updateButton.setDefaultButton(false);
        }
        this.cancelButton.setDefaultButton(false);
        defaultButton.setDefaultButton(true);
    }

    private void runAction() {
        this.userAnswer = 0;
        this.closeDialog();
    }

    private void updateAction() {
        DialogTemplate.showDocument(this.updateURL.toExternalForm());
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            final FXDialog dlg = this.dialog;
            this.dialog.centerOnScreen();
            Runnable runner = new Runnable(){

                public void run() {
                    dlg.showAndWait();
                }
            };
            runner.run();
        } else {
            this.dialog.hide();
        }
    }

    private int getAnswer() {
        return this.userAnswer;
    }

    private VBox createWarningMorePrompt(Node messagePrompt) {
        VBox vb = new VBox();
        vb.getChildren().add(this.getSecurityWarning());
        vb.getChildren().add(this.getMoreInfoButton());
        vb.getChildren().add(messagePrompt);
        return vb;
    }

    private Hyperlink getMoreInfoButton() {
        Hyperlink moreInfoLbl = null;
        moreInfoLbl = new Hyperlink(FXSSV3Dialog.getMessage("dialog.template.more.info2"));
        moreInfoLbl.setMnemonicParsing(true);
        moreInfoLbl.setId("bottom-more-info-link");
        moreInfoLbl.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent e) {
                FXSSV3Dialog.this.showMoreInfo();
            }
        });
        return moreInfoLbl;
    }

    private static String getMessage(String key) {
        if (key == null) {
            return null;
        }
        return ResourceManager.getMessage(key);
    }

    private BorderPane getSecurityWarning() {
        BorderPane warningPanel = new BorderPane();
        Text redWarning = new Text(FXSSV3Dialog.getMessage("dialog.unsigned.security.risk.warning"));
        redWarning.setFill(Color.web("0xCC0000"));
        redWarning.setFont(Font.font("Amble Cn", FontWeight.BOLD, 15.0));
        redWarning.setWrappingWidth(540.0);
        warningPanel.setLeft(redWarning);
        warningPanel.setPadding(new Insets(8.0, 0.0, 0.0, 0.0));
        return warningPanel;
    }

    private void showMoreInfo() {
        StringBuilder moreInfo = new StringBuilder();
        if (FXSSV3Dialog.isLocalApp(this.ainfo)) {
            moreInfo.append(FXSSV3Dialog.getMessage("sandbox.security.info.local.description"));
        } else {
            moreInfo.append(FXSSV3Dialog.getMessage("sandbox.security.info.description"));
        }
        moreInfo.append("\n\n");
        if (this.updateText != null) {
            moreInfo.append(FXSSV3Dialog.getMessage("deployment.dialog.ssv3.more.insecure"));
            moreInfo.append("\n\n");
        }
        if (FXSSV3Dialog.isLocalApp(this.ainfo)) {
            moreInfo.append(FXSSV3Dialog.getMessage("deployment.dialog.ssv3.more.local"));
            moreInfo.append("\n\n");
        }
        if (this.multiText != null) {
            moreInfo.append(FXSSV3Dialog.getMessage("deployment.dialog.ssv3.more.multi"));
            moreInfo.append("\n\n");
        }
        moreInfo.append(FXSSV3Dialog.getMessage("deployment.dialog.ssv3.more.general"));
        MoreInfoDialog info = new MoreInfoDialog(this.dialog, new String[]{moreInfo.toString()}, null, 0, null, 0, 0, false, false);
        info.showAndWait();
    }

    private static boolean isLocalApp(AppInfo ai) {
        URL u = ai.getFrom();
        return u != null && u.getProtocol().equals("file");
    }
}

