/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.scenario.effect.impl.state.LinearConvolveKernel;

public abstract class HVSeparableKernel
extends LinearConvolveKernel {
    @Override
    public final int getNumberOfPasses() {
        return 2;
    }

    @Override
    public LinearConvolveKernel.PassType getPassType(int n) {
        return n == 0 ? LinearConvolveKernel.PassType.HORIZONTAL_CENTERED : LinearConvolveKernel.PassType.VERTICAL_CENTERED;
    }

    @Override
    public final Rectangle getResultBounds(Rectangle rectangle, int n) {
        int n2 = this.getKernelSize(n);
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (n == 0) {
            rectangle2.grow(n2 / 2, 0);
        } else {
            rectangle2.grow(0, n2 / 2);
        }
        return rectangle2;
    }

    @Override
    public final Rectangle getScaledResultBounds(Rectangle rectangle, int n) {
        int n2 = this.getScaledKernelSize(n);
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (n == 0) {
            rectangle2.grow(n2 / 2, 0);
        } else {
            rectangle2.grow(0, n2 / 2);
        }
        return rectangle2;
    }

    @Override
    public final float[] getVector(Rectangle rectangle, BaseTransform baseTransform, int n) {
        float f;
        float[] fArray = new float[4];
        if (baseTransform.isTranslateOrIdentity()) {
            f = 1.0f;
        } else {
            fArray[0] = n == 0 ? 1.0f : 0.0f;
            fArray[1] = n == 1 ? 1.0f : 0.0f;
            try {
                baseTransform.inverseDeltaTransform(fArray, 0, fArray, 0, 1);
                f = (float)Math.hypot(fArray[0], fArray[1]);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                f = 0.0f;
            }
        }
        float f2 = n == 0 ? f / (float)rectangle.width : 0.0f;
        float f3 = n == 1 ? f / (float)rectangle.height : 0.0f;
        int n2 = this.getScaledKernelSize(n);
        int n3 = n2 / 2;
        fArray[0] = f2;
        fArray[1] = f3;
        fArray[2] = (float)(-n3) * f2;
        fArray[3] = (float)(-n3) * f3;
        return fArray;
    }
}

