/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime.html;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.Parser;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.runtime.html.ElementValidator;
import net.sourceforge.jnlp.util.logging.OutputController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AppletExtractor {
    private final URL html;
    private static final String[] APPLETS = new String[]{"applet", "APPLET", "Applet", "object", "OBJECT", "Object", "embed", "EMBED", "Embed"};
    private final ParserSettings ps;

    public AppletExtractor(URL html) {
        this(html, null);
    }

    public AppletExtractor(URL html, ParserSettings ps) {
        JNLPRuntime.saveHistory(html.toExternalForm());
        this.html = html;
        this.ps = ps;
    }

    public URL getHtml() {
        return this.html;
    }

    private InputStream cleanStreamIfPossible(InputStream is) {
        try {
            if (this.ps != null && this.ps.isMalformedXmlAllowed()) {
                Object parser = Parser.getParserInstance(this.ps);
                Method m = parser.getClass().getMethod("xmlizeInputStream", InputStream.class);
                return (InputStream)m.invoke(null, is);
            }
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("TAGSOUPhtmlNotUsed", OptionsDefinitions.OPTIONS.XML.option));
        }
        catch (Exception ex) {
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("TAGSOUPhtmlBroken"));
            OutputController.getLogger().log(ex);
        }
        return is;
    }

    public List<Element> findAppletsOnPage() {
        try {
            return this.findAppletsOnPageImpl(this.openDocument(this.cleanStreamIfPossible(JNLPFile.openURL(this.html, null, UpdatePolicy.ALWAYS))));
        }
        catch (SAXException sex) {
            throw new RuntimeException(new ParseException(sex));
        }
        catch (IOException | ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private List<Element> findAppletsOnPageImpl(Document doc) throws ParserConfigurationException, SAXException, IOException {
        OutputController.getLogger().log("Root element :" + doc.getDocumentElement().getNodeName());
        return AppletExtractor.findElements(APPLETS, doc.getDocumentElement(), new ElementValidator(){

            @Override
            public boolean isElementValid(Element e) {
                return AppletExtractor.isApplet(e);
            }
        });
    }

    private Document openDocument(InputStream is) throws SAXException, ParserConfigurationException, IOException {
        OutputController.getLogger().log("Reading " + this.html.toExternalForm());
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        doc.getDocumentElement().normalize();
        return doc;
    }

    private static boolean isApplet(Element eElement) {
        if (eElement.getNodeName().toLowerCase().equals("applet")) {
            return true;
        }
        String type = eElement.getAttribute("type");
        String codeType = eElement.getAttribute("codetype");
        String classid = eElement.getAttribute("classid");
        return type != null && type.toLowerCase().contains("application/x-java-applet") || codeType != null && codeType.toLowerCase().contains("application/x-java-applet") || classid != null && classid.equalsIgnoreCase("clsid:8AD9C840-044E-11D1-B3E9-00805F499D93");
    }

    static List<Element> findElements(String[] elements, Element doc, ElementValidator elementValidator) {
        LinkedList<Element> found = new LinkedList<Element>();
        for (String key : elements) {
            NodeList nList = doc.getElementsByTagName(key);
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Element eElement;
                Node nNode = nList.item(temp);
                OutputController.getLogger().log("Found in html: " + nNode.getNodeName());
                if (nNode.getNodeType() != 1 || !elementValidator.isElementValid(eElement = (Element)nNode)) continue;
                found.add(eElement);
            }
        }
        return found;
    }
}

