/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class FunctionCall
extends AstNode {
    protected static final List<AstNode> NO_ARGS = Collections.unmodifiableList(new ArrayList());
    protected AstNode target;
    protected List<AstNode> arguments;
    protected int lp = -1;
    protected int rp = -1;

    public FunctionCall() {
        this.type = 38;
    }

    public FunctionCall(int n) {
        super(n);
        this.type = 38;
    }

    public FunctionCall(int n, int n2) {
        super(n, n2);
        this.type = 38;
    }

    public AstNode getTarget() {
        return this.target;
    }

    public void setTarget(AstNode astNode) {
        this.assertNotNull(astNode);
        this.target = astNode;
        astNode.setParent(this);
    }

    public List<AstNode> getArguments() {
        return this.arguments != null ? this.arguments : NO_ARGS;
    }

    public void setArguments(List<AstNode> list) {
        if (list == null) {
            this.arguments = null;
        } else {
            if (this.arguments != null) {
                this.arguments.clear();
            }
            for (AstNode astNode : list) {
                this.addArgument(astNode);
            }
        }
    }

    public void addArgument(AstNode astNode) {
        this.assertNotNull(astNode);
        if (this.arguments == null) {
            this.arguments = new ArrayList<AstNode>();
        }
        this.arguments.add(astNode);
        astNode.setParent(this);
    }

    public int getLp() {
        return this.lp;
    }

    public void setLp(int n) {
        this.lp = n;
    }

    public int getRp() {
        return this.rp;
    }

    public void setRp(int n) {
        this.rp = n;
    }

    public void setParens(int n, int n2) {
        this.lp = n;
        this.rp = n2;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append(this.target.toSource(0));
        stringBuilder.append("(");
        if (this.arguments != null) {
            this.printList(this.arguments, stringBuilder);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.target.visit(nodeVisitor);
            for (AstNode astNode : this.getArguments()) {
                astNode.visit(nodeVisitor);
            }
        }
    }
}

