/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.intellij.plugins.intelliLang.util.RegExpUtil;
import org.intellij.plugins.intelliLang.util.StringLiteralReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RegExpEnumReference
extends StringLiteralReference {
    private final String myPattern;

    public RegExpEnumReference(PsiLiteralExpression expression, @NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "org/intellij/plugins/intelliLang/inject/java/RegExpEnumReference", "<init>"));
        }
        super((PsiLiteral)expression);
        this.myPattern = pattern;
    }

    @NotNull
    public Object[] getVariants() {
        Set<String> values = this.getEnumValues();
        if (values == null || values.size() == 0) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/java/RegExpEnumReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = ContainerUtil.map2Array(values, (Function)new Function<String, Object>(){

            public Object fun(String s) {
                return LookupElementBuilder.create((String)s).withIcon(PlatformIcons.ENUM_ICON);
            }
        });
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/java/RegExpEnumReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return true;
    }

    @Nullable
    public PsiElement resolve() {
        Set<String> values = this.getEnumValues();
        return values != null ? (values.contains(this.getValue()) ? this.myValue : null) : null;
    }

    @Nullable
    private Set<String> getEnumValues() {
        return RegExpUtil.getEnumValues(this.myValue.getProject(), this.myPattern);
    }
}

