/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;

public class WebResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final WarDirectory myWarDirectory;
    @NotNull
    private final String warRelativePath;
    @NotNull
    private final File file;

    public WebResource(@NotNull WarDirectory warDirectory, @NotNull String warRelativePath, @NotNull File file) {
        if (warDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warDirectory", "org/jetbrains/plugins/gradle/model/data/WebResource", "<init>"));
        }
        if (warRelativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warRelativePath", "org/jetbrains/plugins/gradle/model/data/WebResource", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/gradle/model/data/WebResource", "<init>"));
        }
        this.myWarDirectory = warDirectory;
        this.warRelativePath = WebResource.getAdjustedPath(warRelativePath);
        this.file = file;
    }

    @NotNull
    public WarDirectory getWarDirectory() {
        WarDirectory warDirectory = this.myWarDirectory;
        if (warDirectory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/WebResource", "getWarDirectory"));
        }
        return warDirectory;
    }

    @NotNull
    public String getWarRelativePath() {
        String string = this.warRelativePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/WebResource", "getWarRelativePath"));
        }
        return string;
    }

    @NotNull
    public File getFile() {
        File file = this.file;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/WebResource", "getFile"));
        }
        return file;
    }

    private static String getAdjustedPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/gradle/model/data/WebResource", "getAdjustedPath"));
        }
        return path.isEmpty() || path.charAt(0) != '/' ? '/' + path : path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebResource)) {
            return false;
        }
        WebResource resource = (WebResource)o;
        if (!this.file.getPath().equals(resource.file.getPath())) {
            return false;
        }
        if (this.myWarDirectory != resource.myWarDirectory) {
            return false;
        }
        return this.warRelativePath.equals(resource.warRelativePath);
    }

    public int hashCode() {
        int result = this.myWarDirectory.hashCode();
        result = 31 * result + this.warRelativePath.hashCode();
        result = 31 * result + this.file.getPath().hashCode();
        return result;
    }

    public String toString() {
        return "WebResource{myWarDirectory=" + this.myWarDirectory + ", warRelativePath='" + this.warRelativePath + '\'' + ", file=" + this.file + '}';
    }
}

