/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;

public class GradleDistributionsContributor
implements GradleMethodContextContributor {
    static final String DISTRIBUTIONS = "distributions";
    private static final String CONTENTS_METHOD = "contents";

    @Override
    public void process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        GrLightMethodBuilder methodWithClosure;
        GroovyPsiManager psiManager;
        if (methodCallInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallInfo", "org/jetbrains/plugins/gradle/service/resolve/GradleDistributionsContributor", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleDistributionsContributor", "process"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleDistributionsContributor", "process"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleDistributionsContributor", "process"));
        }
        if (methodCallInfo.isEmpty()) {
            return;
        }
        String methodCall = (String)ContainerUtil.getLastItem(methodCallInfo);
        if (methodCall == null) {
            return;
        }
        if (methodCallInfo.size() > 1 && DISTRIBUTIONS.equals(place.getText()) && place instanceof GrReferenceExpressionImpl) {
            GradleResolverUtil.addImplicitVariable(processor, state, (GrReferenceExpressionImpl)place, "org.gradle.api.distribution.DistributionContainer");
        }
        if (methodCallInfo.size() > 1 && methodCall.equals("project")) {
            methodCallInfo.remove(methodCallInfo.size() - 1);
            methodCall = (String)ContainerUtil.getLastItem(methodCallInfo);
        }
        if (methodCall == null || !StringUtil.startsWith((CharSequence)methodCall, (CharSequence)DISTRIBUTIONS)) {
            return;
        }
        String closureMethod = null;
        String configureClosureClazz = null;
        String contributorClass = null;
        boolean isRootRelated = StringUtil.startsWith((CharSequence)methodCall, (CharSequence)"distributions.");
        if (methodCallInfo.size() == 1) {
            configureClosureClazz = "org.gradle.api.distribution.DistributionContainer";
            if (place instanceof GrReferenceExpressionImpl) {
                String varClazz = StringUtil.startsWith((CharSequence)methodCall, (CharSequence)"distributions.") ? "org.gradle.api.distribution.DistributionContainer" : "org.gradle.api.distribution.Distribution";
                GradleResolverUtil.addImplicitVariable(processor, state, (GrReferenceExpressionImpl)place, varClazz);
            } else {
                contributorClass = "org.gradle.api.distribution.DistributionContainer";
            }
            closureMethod = "configure";
        } else if (methodCallInfo.size() == 2) {
            configureClosureClazz = "org.gradle.api.distribution.Distribution";
            contributorClass = "org.gradle.api.distribution.Distribution";
            closureMethod = "create";
        } else if (methodCallInfo.size() == 3 && CONTENTS_METHOD.equals(place.getText())) {
            psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
            PsiClass psiClass = psiManager.findClassWithCache("org.gradle.api.distribution.Distribution", place.getResolveScope());
            GrLightMethodBuilder methodWithClosure2 = GradleResolverUtil.createMethodWithClosure(CONTENTS_METHOD, "org.gradle.api.file.CopySpec", null, place, psiManager);
            if (methodWithClosure2 != null) {
                PsiMethod psiMethod;
                if (psiClass != null && (psiMethod = (PsiMethod)ArrayUtil.getFirstElement((Object[])psiClass.findMethodsByName(CONTENTS_METHOD, false))) != null) {
                    methodWithClosure2.setNavigationElement((PsiElement)psiMethod);
                }
                processor.execute((PsiElement)methodWithClosure2, state);
            }
        } else if (methodCallInfo.size() == 4 && CONTENTS_METHOD.equals(methodCallInfo.get(1))) {
            GradleResolverUtil.processDeclarations(methodCallInfo.get(0), GroovyPsiManager.getInstance((Project)place.getProject()), processor, state, place, "org.gradle.api.file.CopySpec");
        }
        if (configureClosureClazz != null && !isRootRelated && (methodWithClosure = GradleResolverUtil.createMethodWithClosure(closureMethod, configureClosureClazz, null, place, psiManager = GroovyPsiManager.getInstance((Project)place.getProject()))) != null) {
            processor.execute((PsiElement)methodWithClosure, state);
        }
        if (contributorClass != null) {
            psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
            GradleResolverUtil.processDeclarations(psiManager, processor, state, place, contributorClass);
        }
    }
}

