/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemConfigLocator;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleConfigLocator
implements ExternalSystemConfigLocator {
    @NotNull
    public ProjectSystemId getTargetExternalSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/GradleConfigLocator", "getTargetExternalSystemId"));
        }
        return projectSystemId;
    }

    @Nullable
    public VirtualFile adjust(@NotNull VirtualFile configPath) {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "org/jetbrains/plugins/gradle/service/settings/GradleConfigLocator", "adjust"));
        }
        if (!configPath.isDirectory()) {
            return configPath;
        }
        VirtualFile result = configPath.findChild("build.gradle");
        if (result != null) {
            return result;
        }
        for (VirtualFile child : configPath.getChildren()) {
            String name = child.getName();
            if (!name.endsWith("gradle") || "settings.gradle".equals(name) || child.isDirectory()) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public List<VirtualFile> findAll(@NotNull ExternalProjectSettings externalProjectSettings) {
        if (externalProjectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectSettings", "org/jetbrains/plugins/gradle/service/settings/GradleConfigLocator", "findAll"));
        }
        ArrayList list = ContainerUtil.newArrayList();
        for (String path : externalProjectSettings.getModules()) {
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path));
            if (vFile == null) continue;
            for (VirtualFile child : vFile.getChildren()) {
                String name = child.getName();
                if (child.isDirectory() || !name.endsWith("gradle")) continue;
                list.add(child);
            }
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/GradleConfigLocator", "findAll"));
        }
        return arrayList;
    }
}

