/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.id.IdGenerator;
import org.gradle.messaging.dispatch.DiscardingFailureHandler;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.ProxyDispatchAdapter;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.ChannelLookupProtocol;
import org.gradle.messaging.remote.internal.GroupMessageFilter;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.MessageHub;
import org.gradle.messaging.remote.internal.MessageOriginator;
import org.gradle.messaging.remote.internal.OutgoingBroadcast;
import org.gradle.messaging.remote.internal.OutgoingConnector;
import org.gradle.messaging.remote.internal.ProtocolStack;
import org.gradle.messaging.remote.internal.RemoteConnection;
import org.gradle.messaging.remote.internal.protocol.ChannelAvailable;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.gradle.messaging.remote.internal.protocol.LookupRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOutgoingBroadcast
implements OutgoingBroadcast,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOutgoingBroadcast.class);
    private final MessageOriginator messageOriginator;
    private final String group;
    private final OutgoingConnector outgoingConnector;
    private final ProtocolStack<DiscoveryMessage> discoveryBroadcast;
    private final Lock lock = new ReentrantLock();
    private final StoppableExecutor executor;
    private final Set<String> channels = new HashSet<String>();
    private final Set<Address> connections = new HashSet<Address>();
    private final MessageHub hub;

    public DefaultOutgoingBroadcast(MessageOriginator messageOriginator, String group, AsyncConnection<DiscoveryMessage> connection, OutgoingConnector outgoingConnector, ExecutorFactory executorFactory, IdGenerator<UUID> idGenerator, ClassLoader messagingClassLoader) {
        this.messageOriginator = messageOriginator;
        this.group = group;
        this.outgoingConnector = outgoingConnector;
        DiscardingFailureHandler failureHandler = new DiscardingFailureHandler(LOGGER);
        this.hub = new MessageHub("outgoing broadcast", messageOriginator.getName(), executorFactory, idGenerator, messagingClassLoader);
        this.executor = executorFactory.create("broadcast lookup");
        this.discoveryBroadcast = new ProtocolStack((Executor)this.executor, failureHandler, failureHandler, new ChannelLookupProtocol());
        connection.dispatchTo(new GroupMessageFilter(group, this.discoveryBroadcast.getBottom()));
        this.discoveryBroadcast.getBottom().dispatchTo(connection);
        this.discoveryBroadcast.getTop().dispatchTo(new DiscoveryMessageDispatch());
        LOGGER.info("Created OutgoingBroadcast with {}", (Object)messageOriginator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T addOutgoing(Class<T> type) {
        String channelKey = type.getName();
        this.lock.lock();
        try {
            if (this.channels.add(channelKey)) {
                this.discoveryBroadcast.getTop().dispatch(new LookupRequest(this.messageOriginator, this.group, channelKey));
            }
        }
        finally {
            this.lock.unlock();
        }
        return new ProxyDispatchAdapter<T>(this.hub.addMulticastOutgoing(channelKey), type, new Class[0]).getSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CompositeStoppable stoppable;
        this.lock.lock();
        try {
            stoppable = CompositeStoppable.stoppable((Object[])new Object[]{this.hub, this.discoveryBroadcast, this.executor});
        }
        finally {
            this.connections.clear();
            this.lock.unlock();
        }
        stoppable.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiscoveryMessageDispatch
    implements Dispatch<DiscoveryMessage> {
        private DiscoveryMessageDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch(DiscoveryMessage message) {
            if (message instanceof ChannelAvailable) {
                ChannelAvailable available = (ChannelAvailable)message;
                Address serviceAddress = available.getAddress();
                DefaultOutgoingBroadcast.this.lock.lock();
                try {
                    if (!DefaultOutgoingBroadcast.this.channels.contains(available.getChannel())) {
                        return;
                    }
                    if (DefaultOutgoingBroadcast.this.connections.contains(serviceAddress)) {
                        return;
                    }
                    DefaultOutgoingBroadcast.this.connections.add(serviceAddress);
                }
                finally {
                    DefaultOutgoingBroadcast.this.lock.unlock();
                }
                RemoteConnection<Message> syncConnection = DefaultOutgoingBroadcast.this.outgoingConnector.connect(serviceAddress).create(DiscoveryMessage.class.getClassLoader());
                DefaultOutgoingBroadcast.this.hub.addConnection(syncConnection);
            }
        }
    }
}

