/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.util.AstUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JsObjectLiteral
extends JsLiteral {
    private final List<JsPropertyInitializer> properties;
    private final boolean multiline;

    public JsObjectLiteral() {
        this(new SmartList<JsPropertyInitializer>());
    }

    public JsObjectLiteral(boolean multiline) {
        this(new SmartList<JsPropertyInitializer>(), multiline);
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public JsObjectLiteral(List<JsPropertyInitializer> properties2) {
        this(properties2, false);
    }

    public JsObjectLiteral(List<JsPropertyInitializer> properties2, boolean multiline) {
        this.properties = properties2;
        this.multiline = multiline;
    }

    public List<JsPropertyInitializer> getPropertyInitializers() {
        return this.properties;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitObjectLiteral(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.properties);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptList(this.properties);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsObjectLiteral deepCopy() {
        JsObjectLiteral jsObjectLiteral = new JsObjectLiteral(AstUtil.deepCopy(this.properties), this.multiline).withMetadataFrom(this);
        if (jsObjectLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsObjectLiteral", "deepCopy"));
        }
        return jsObjectLiteral;
    }
}

