/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightReferenceParameterList;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class LightMemberReference
extends LightElement
implements PsiJavaCodeReferenceElement {
    @NotNull
    private final PsiMember myRefMember;
    private final PsiSubstitutor mySubstitutor;
    private LightReferenceParameterList myParameterList;

    public LightMemberReference(PsiManager manager, @NotNull PsiMember refClass, PsiSubstitutor substitutor2) {
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/psi/impl/light/LightMemberReference", "<init>"));
        }
        super(manager, JavaLanguage.INSTANCE);
        this.myRefMember = refClass;
        this.mySubstitutor = substitutor2;
    }

    @Override
    @NotNull
    public PsiElement resolve() {
        PsiMember psiMember = this.myRefMember;
        if (psiMember == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMemberReference", "resolve"));
        }
        return psiMember;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiElement resolved = this.resolve();
        PsiSubstitutor substitutor2 = this.mySubstitutor;
        if (substitutor2 == null) {
            substitutor2 = PsiSubstitutor.EMPTY;
        }
        CandidateInfo candidateInfo = new CandidateInfo(resolved, substitutor2);
        if (candidateInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMemberReference", "advancedResolve"));
        }
        return candidateInfo;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult result2 = this.advancedResolve(incompleteCode);
        if (result2 != JavaResolveResult.EMPTY) {
            JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{result2};
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMemberReference", "multiResolve"));
            }
            return javaResolveResultArray;
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMemberReference", "multiResolve"));
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/light/LightMemberReference", "processVariants"));
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        if (this.myParameterList == null) {
            this.myParameterList = new LightReferenceParameterList(this.myManager, PsiTypeElement.EMPTY_ARRAY);
        }
        return this.myParameterList;
    }

    @Override
    public String getQualifiedName() {
        String qualifiedName;
        PsiClass containingClass = this.myRefMember.getContainingClass();
        if (containingClass != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
            return qualifiedName + '.' + this.myRefMember.getName();
        }
        return this.myRefMember.getName();
    }

    @Override
    public String getReferenceName() {
        return this.getQualifiedName();
    }

    @Override
    public String getText() {
        return this.myRefMember.getName() + this.getParameterList().getText();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String name = this.getQualifiedName();
        if (name == null) {
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMemberReference", "getCanonicalText"));
            }
            return null;
        }
        PsiType[] types2 = this.getTypeParameters();
        if (types2.length == 0) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMemberReference", "getCanonicalText"));
            }
            return string;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append('<');
        for (int i = 0; i < types2.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(types2[i].getCanonicalText());
        }
        buf.append('>');
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMemberReference", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public PsiElement copy() {
        return new LightMemberReference(this.myManager, this.myRefMember, this.mySubstitutor);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/light/LightMemberReference", "bindToElement"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/light/LightMemberReference", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "LightClassReference:" + this.myRefMember.getName();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return element instanceof PsiClass && element.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    public boolean isValid() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList != null && !parameterList.isValid()) {
            return false;
        }
        return this.myRefMember == null || this.myRefMember.isValid();
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        PsiType[] psiTypeArray = parameterList == null ? PsiType.EMPTY_ARRAY : parameterList.getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMemberReference", "getTypeParameters"));
        }
        return psiTypeArray;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    @Override
    public boolean isQualified() {
        return false;
    }
}

